/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.text.TextUtils;
import android.util.AndroidException;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.utils.HEX;
import com.huawei.hms.utils.IOUtils;
import com.huawei.hms.utils.SHA256;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public class PackageManagerHelper {
    public final PackageManager a;

    public PackageManagerHelper(Context context) {
        this.a = context.getPackageManager();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PackageStates getPackageStates(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return PackageStates.NOT_INSTALLED;
        }
        try {
            if (!this.a.getApplicationInfo((String)string, (int)128).enabled) return PackageStates.DISABLED;
        }
        catch (AndroidException androidException) {
            return PackageStates.NOT_INSTALLED;
        }
        return PackageStates.ENABLED;
    }

    public int getPackageVersionCode(String string) {
        block4: {
            PackageManagerHelper packageManagerHelper = packageManagerHelper.a.getPackageInfo(string, 16);
            if (packageManagerHelper == null) break block4;
            try {
                return ((PackageInfo)packageManagerHelper).versionCode;
            }
            catch (RuntimeException runtimeException) {
                HMSLog.e((String)"PackageManagerHelper", (String)"get PackageVersionCode failed", (Throwable)runtimeException);
                return 0;
            }
            catch (AndroidException androidException) {
                HMSLog.e((String)"PackageManagerHelper", (String)("get PackageVersionCode failed " + (Object)((Object)androidException)));
                return 0;
            }
        }
        return 0;
    }

    public String getPackageVersionName(String string) {
        block5: {
            PackageManagerHelper packageManagerHelper = packageManagerHelper.a.getPackageInfo(string, 16);
            if (packageManagerHelper == null) break block5;
            if (((PackageInfo)packageManagerHelper).versionName == null) break block5;
            try {
                return ((PackageInfo)packageManagerHelper).versionName;
            }
            catch (RuntimeException runtimeException) {
                HMSLog.e((String)"PackageManagerHelper", (String)"get getPackageVersionName failed", (Throwable)runtimeException);
                return "";
            }
            catch (AndroidException androidException) {
                return "";
            }
        }
        return "";
    }

    public String getPackageSignature(String string) {
        byte[] byArray = ((PackageManagerHelper)object).a(string);
        Object object = byArray;
        if (byArray != null && ((Object)object).length != 0) {
            return HEX.encodeHexString(SHA256.digest((byte[])object), true);
        }
        return null;
    }

    public boolean hasProvider(String string, String string2) {
        block8: {
            int n;
            ProviderInfo[] providerInfoArray = providerInfoArray.a.getPackageInfo(string, 8);
            if (providerInfoArray == null) break block8;
            if (providerInfoArray.providers == null) break block8;
            providerInfoArray = providerInfoArray.providers;
            try {
                n = providerInfoArray.providers.length;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
            catch (AndroidException androidException) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (!string2.equals(providerInfoArray[i].authority)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyPackageArchive(String string, String string2, String string3) {
        Throwable throwable2;
        block6: {
            boolean bl;
            Object object = ((PackageManagerHelper)object).a.getPackageArchiveInfo(string, 64);
            if (object == null) return false;
            if (((PackageInfo)object).signatures.length <= 0) return false;
            if (!string2.equals(((PackageInfo)object).packageName)) {
                return false;
            }
            PackageManagerHelper packageManagerHelper = object;
            object = null;
            try {
                object = IOUtils.toInputStream(((PackageInfo)packageManagerHelper).signatures[0].toByteArray());
                bl = string3.equalsIgnoreCase(HEX.encodeHexString(SHA256.digest(CertificateFactory.getInstance("X.509").generateCertificate((InputStream)object).getEncoded()), true));
            }
            catch (Throwable throwable2) {
                break block6;
            }
            catch (CertificateException certificateException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            IOUtils.closeQuietly((InputStream)object);
            return bl;
            {
                void var1_4;
                HMSLog.e((String)"PackageManagerHelper", (String)("Failed to get application signature certificate fingerprint." + var1_4.getMessage()));
            }
            IOUtils.closeQuietly((InputStream)object);
            return false;
        }
        IOUtils.closeQuietly((InputStream)object);
        throw throwable2;
    }

    public String getApplicationName(String string) {
        PackageManagerHelper packageManagerHelper;
        try {
            PackageManagerHelper packageManagerHelper2 = packageManagerHelper3;
            packageManagerHelper = packageManagerHelper2;
            PackageManagerHelper packageManagerHelper3 = packageManagerHelper2.a.getApplicationInfo(string, 128);
        }
        catch (AndroidException androidException) {
            HMSLog.e((String)"PackageManagerHelper", (String)("Failed to get application name for " + string));
            return null;
        }
        return packageManagerHelper.a.getApplicationLabel((ApplicationInfo)packageManagerHelper3).toString();
    }

    public long getPackageFirstInstallTime(String string) {
        block4: {
            PackageManagerHelper packageManagerHelper = packageManagerHelper.a.getPackageInfo(string, 128);
            if (packageManagerHelper == null) break block4;
            try {
                return ((PackageInfo)packageManagerHelper).firstInstallTime;
            }
            catch (RuntimeException runtimeException) {
                return 0L;
            }
            catch (AndroidException androidException) {
                return 0L;
            }
        }
        return 0L;
    }

    public boolean isPackageFreshInstall(String string) {
        block4: {
            PackageManagerHelper packageManagerHelper = packageManagerHelper.a.getPackageInfo(string, 128);
            if (packageManagerHelper == null) break block4;
            try {
                return ((PackageInfo)packageManagerHelper).firstInstallTime == ((PackageInfo)packageManagerHelper).lastUpdateTime;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
            catch (AndroidException androidException) {
                return false;
            }
        }
        return false;
    }

    public final byte[] a(String string) {
        block6: {
            PackageManagerHelper packageManagerHelper = packageManagerHelper.a.getPackageInfo(string, 64);
            if (packageManagerHelper == null) break block6;
            if (((PackageInfo)packageManagerHelper).signatures == null) break block6;
            if (((PackageInfo)packageManagerHelper).signatures.length <= 0) break block6;
            try {
                return ((PackageInfo)packageManagerHelper).signatures[0].toByteArray();
            }
            catch (RuntimeException runtimeException) {
                HMSLog.e((String)"PackageManagerHelper", (String)"Failed to get application signature certificate fingerprint.", (Throwable)runtimeException);
            }
            catch (AndroidException androidException) {
                HMSLog.e((String)"PackageManagerHelper", (String)("Failed to get application signature certificate fingerprint." + androidException.getMessage()));
            }
        }
        HMSLog.e((String)"PackageManagerHelper", (String)"Failed to get application signature certificate fingerprint.");
        return new byte[0];
    }

    public static enum PackageStates {
        ENABLED,
        DISABLED,
        NOT_INSTALLED,
        SPOOF;

    }
}

