/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.platform.vivo.business;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.engagelab.privates.common.api.MTCommonPrivatesApi;
import com.engagelab.privates.common.global.MTGlobal;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.common.utils.SM4Util;
import com.engagelab.privates.push.api.MTPushPrivatesApi;
import com.engagelab.privates.push.api.NotificationMessage;
import com.engagelab.privates.push.api.PlatformTokenMessage;
import com.engagelab.privates.push.utils.ApplicationContextUtil;
import com.engagelab.privates.push.utils.NotificationUtil;
import com.vivo.push.PushClient;
import com.vivo.push.PushConfig;
import com.vivo.push.listener.IPushQueryActionListener;
import com.vivo.push.model.UPSNotificationMessage;
import java.lang.reflect.Field;
import org.json.JSONObject;

public class MTVivoBusiness {
    private static final String TAG = "MTVivoBusiness";
    private static final String VIVO_APPID = "com.vivo.push.app_id";
    private static final String VIVO_APPKEY = "com.vivo.push.api_key";
    private boolean isSupport;
    private static Application mApplication;
    private static volatile MTVivoBusiness instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MTVivoBusiness getInstance() {
        if (instance != null) return instance;
        Class<MTVivoBusiness> clazz = MTVivoBusiness.class;
        synchronized (MTVivoBusiness.class) {
            instance = new MTVivoBusiness();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(final Context context) {
        try {
            String appId = MTGlobal.getMetaData((Context)context, (String)VIVO_APPID);
            if (TextUtils.isEmpty((CharSequence)appId)) {
                this.isSupport = false;
                MTCommonLog.e((String)TAG, (String)"not support vivo push, vivo appId is empty");
                return;
            }
            String appKey = MTGlobal.getMetaData((Context)context, (String)VIVO_APPKEY);
            if (TextUtils.isEmpty((CharSequence)appKey)) {
                this.isSupport = false;
                MTCommonLog.e((String)TAG, (String)"not support vivo push, vivo appKey is empty");
                return;
            }
            this.isSupport = PushClient.getInstance((Context)context).isSupport();
            if (!this.isSupport) {
                MTCommonLog.e((String)TAG, (String)"not support vivo push");
                this.onNode(context, 3002, 0, 3900, 1);
                return;
            }
            MTCommonLog.d((String)TAG, (String)"support vivo push");
            PushConfig config = new PushConfig.Builder().agreePrivacyStatement(true).build();
            PushClient.getInstance((Context)context).initialize(config);
            PushClient.getInstance((Context)context).getRegId(new IPushQueryActionListener(){

                public void onSuccess(String token) {
                    if (TextUtils.isEmpty((CharSequence)token)) {
                        MTCommonLog.d((String)MTVivoBusiness.TAG, (String)"getRegId onTokenFailed:get token is empty");
                        MTVivoBusiness.this.onNode(context, 3003, 0, 3900, 1);
                        return;
                    }
                    MTCommonLog.d((String)MTVivoBusiness.TAG, (String)("getRegId onTokenSuccess:get token is " + token));
                    MTVivoBusiness.this.onToken(context, token, 1);
                }

                public void onFail(Integer integer) {
                    MTCommonLog.d((String)MTVivoBusiness.TAG, (String)("getRegId onTokenFailed code:" + integer));
                    MTVivoBusiness.this.onNode(context, 3003, integer, 3900, 1);
                }
            });
        }
        catch (Throwable throwable) {
            this.isSupport = false;
            MTCommonLog.e((String)TAG, (String)("init failed " + throwable.getMessage()));
        }
    }

    public void onToken(Context context, String token, int from) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            MTCommonLog.d((String)TAG, (String)"onToken:token is empty");
            return;
        }
        PlatformTokenMessage platformTokenMessage = new PlatformTokenMessage().setPlatform((byte)5).setToken(token);
        Bundle bundle = new Bundle();
        bundle.putParcelable("message", (Parcelable)platformTokenMessage);
        MTPushPrivatesApi.init((Context)context);
        MTCommonPrivatesApi.sendMessageToMainProcess((Context)context.getApplicationContext(), (int)3021, (Bundle)bundle);
        this.onNode(context, 3008, 0, 3901, from);
    }

    public void onNode(Context context, int code, int mCode, int type, int from) {
        Bundle bundle = new Bundle();
        bundle.putByte("platform", (byte)5);
        bundle.putInt("code", code);
        bundle.putInt("mCode", mCode);
        bundle.putInt("type", type);
        bundle.putInt("from", from);
        MTCommonPrivatesApi.sendMessageToMainProcess((Context)context, (int)3022, (Bundle)bundle);
    }

    public void turnOnPush(Context context) {
        try {
            if (!this.isSupport) {
                return;
            }
            PushClient.getInstance((Context)context).turnOnPush(null);
            this.onNode(context, 3101, 0, 3902, 0);
        }
        catch (Throwable throwable) {
            MTCommonLog.d((String)TAG, (String)("turnOnPush failed " + throwable.getMessage()));
        }
    }

    public void turnOffPush(Context context) {
        try {
            if (!this.isSupport) {
                return;
            }
            PushClient.getInstance((Context)context).turnOffPush(null);
            this.onNode(context, 3102, 0, 3903, 0);
        }
        catch (Throwable throwable) {
            MTCommonLog.d((String)TAG, (String)("turnOffPush failed " + throwable.getMessage()));
        }
    }

    public void onForegroundMessageArrived(UPSNotificationMessage msg) {
        try {
            if (!this.isSupport) {
                return;
            }
            MTCommonLog.d((String)TAG, (String)("onForegroundMessageArrived:" + msg.toString()));
            String skipContent = msg.getSkipContent();
            if (TextUtils.isEmpty((CharSequence)skipContent)) {
                return;
            }
            Intent intent = NotificationUtil.parseUri((String)skipContent);
            if (intent == null) {
                return;
            }
            Bundle bundle1 = intent.getExtras();
            if (bundle1.size() <= 0) {
                return;
            }
            String mtMessageExtra = bundle1.getString("MTMessageExtra");
            if (TextUtils.isEmpty((CharSequence)mtMessageExtra)) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)(mtMessageExtra = SM4Util.decodeMessage((String)mtMessageExtra)))) {
                return;
            }
            JSONObject object = new JSONObject(mtMessageExtra);
            if (object == null) {
                return;
            }
            String messageId = NotificationUtil.getMessageId((JSONObject)object);
            if (TextUtils.isEmpty((CharSequence)messageId)) {
                return;
            }
            Context applicationContext = MTVivoBusiness.getApplication().getApplicationContext();
            Bundle extras = NotificationUtil.convertJsonToBundle((JSONObject)object.optJSONObject("n_extras"));
            NotificationMessage notificationMessage = new NotificationMessage().setMessageId(messageId).setPlatform((byte)1).setPlatformMessageId(msg.getMsgId() + "").setTitle(msg.getTitle()).setContent(msg.getContent()).setDisplayForeground("0").setExtras(extras);
            Bundle bundle = new Bundle();
            bundle.putParcelable("message", (Parcelable)notificationMessage);
            MTCommonPrivatesApi.sendMessageToMainProcess((Context)applicationContext, (int)3303, (Bundle)bundle);
        }
        catch (Throwable throwable) {
            MTCommonLog.d((String)TAG, (String)("onForegroundMessageArrived failed " + throwable.getMessage()));
        }
    }

    public static Application getApplication() {
        if (mApplication != null) {
            return mApplication;
        }
        try {
            Context context = ApplicationContextUtil.getAppContext();
            if (context instanceof Application) {
                mApplication = (Application)context;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (null == mApplication) {
            mApplication = MTVivoBusiness.getApplicationByReflect();
        }
        return mApplication;
    }

    public static Application getApplicationByReflect() {
        try {
            if (mApplication != null) {
                return mApplication;
            }
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Object thread = MTVivoBusiness.getActivityThread();
            Object app = activityThreadClass.getMethod("getApplication", new Class[0]).invoke(thread, new Object[0]);
            if (app == null) {
                return null;
            }
            mApplication = (Application)app;
            return mApplication;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object getActivityThread() {
        Object activityThread = MTVivoBusiness.getActivityThreadInActivityThreadStaticField();
        if (activityThread != null) {
            return activityThread;
        }
        return MTVivoBusiness.getActivityThreadInActivityThreadStaticMethod();
    }

    private static Object getActivityThreadInActivityThreadStaticField() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Field sCurrentActivityThreadField = activityThreadClass.getDeclaredField("sCurrentActivityThread");
            sCurrentActivityThreadField.setAccessible(true);
            return sCurrentActivityThreadField.get(null);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static Object getActivityThreadInActivityThreadStaticMethod() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            return activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }

    static {
        instance = null;
    }
}

