/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common.data;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.huawei.hms.common.data.DataHolder;
import com.huawei.hms.common.internal.Objects;
import com.huawei.hms.common.internal.Preconditions;

public class DataBufferRef {
    protected final DataHolder mDataHolder;
    protected int mDataRow;
    private int windowIndex;

    public DataBufferRef(DataHolder dataHolder, int n) {
        DataHolder dataHolder2 = dataHolder;
        Preconditions.checkNotNull((Object)dataHolder2, (Object)"dataHolder cannot be null");
        this.mDataHolder = dataHolder2;
        this.getWindowIndex(n);
    }

    protected int getDataRow() {
        return this.mDataRow;
    }

    protected final void getWindowIndex(int n) {
        Preconditions.checkArgument((n >= 0 && n < this.mDataHolder.getCount() ? 1 : 0) != 0, (Object)"rowNum is out of index");
        this.mDataRow = n;
        this.windowIndex = this.mDataHolder.getWindowIndex(this.mDataRow);
    }

    public boolean isDataValid() {
        return this.mDataHolder.isClosed() ^ true;
    }

    public boolean hasColumn(String string) {
        return this.mDataHolder.hasColumn(string);
    }

    protected long getLong(String string) {
        Object object = ((DataBufferRef)object).mDataHolder.getValue(string, ((DataBufferRef)object).mDataRow, ((DataBufferRef)object).windowIndex, "type_long");
        if (object != null) {
            return (Long)object;
        }
        return -1L;
    }

    protected int getInteger(String string) {
        Object object = ((DataBufferRef)object).mDataHolder.getValue(string, ((DataBufferRef)object).mDataRow, ((DataBufferRef)object).windowIndex, "type_int");
        if (object != null) {
            return (Integer)object;
        }
        return -1;
    }

    protected boolean getBoolean(String string) {
        Object object = ((DataBufferRef)object).mDataHolder.getValue(string, ((DataBufferRef)object).mDataRow, ((DataBufferRef)object).windowIndex, "type_boolean");
        if (object != null) {
            return (Boolean)object;
        }
        return false;
    }

    protected String getString(String string) {
        Object object = ((DataBufferRef)object).mDataHolder.getValue(string, ((DataBufferRef)object).mDataRow, ((DataBufferRef)object).windowIndex, "type_string");
        if (object != null) {
            return (String)object;
        }
        return "";
    }

    protected float getFloat(String string) {
        Object object = ((DataBufferRef)object).mDataHolder.getValue(string, ((DataBufferRef)object).mDataRow, ((DataBufferRef)object).windowIndex, "type_float");
        if (object != null) {
            return ((Float)object).floatValue();
        }
        return -1.0f;
    }

    protected double getDouble(String string) {
        Object object = ((DataBufferRef)object).mDataHolder.getValue(string, ((DataBufferRef)object).mDataRow, ((DataBufferRef)object).windowIndex, "type_double");
        if (object != null) {
            return (Double)object;
        }
        return -1.0;
    }

    protected byte[] getByteArray(String string) {
        Object object = ((DataBufferRef)object).mDataHolder.getValue(string, ((DataBufferRef)object).mDataRow, ((DataBufferRef)object).windowIndex, "type_byte_array");
        if (object != null) {
            return (byte[])object;
        }
        return null;
    }

    protected Uri parseUri(String string) {
        String string2 = (String)((DataBufferRef)((Object)string2)).mDataHolder.getValue(string, ((DataBufferRef)((Object)string2)).mDataRow, ((DataBufferRef)((Object)string2)).windowIndex, "type_string");
        if (string2 == null) {
            return null;
        }
        return Uri.parse((String)string2);
    }

    protected void copyToBuffer(String string, CharArrayBuffer charArrayBuffer) {
        this.mDataHolder.copyToBuffer(string, this.mDataRow, this.windowIndex, charArrayBuffer);
    }

    protected boolean hasNull(String string) {
        return this.mDataHolder.hasNull(string, this.mDataRow, this.windowIndex);
    }

    public int hashCode() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mDataRow;
        objectArray2[1] = this.windowIndex;
        objectArray[2] = this.mDataHolder;
        return Objects.hashCode((Object[])objectArray);
    }

    public boolean equals(Object object) {
        if (object instanceof DataBufferRef) {
            object = (DataBufferRef)object;
            return ((DataBufferRef)object).mDataRow == this.mDataRow && ((DataBufferRef)object).windowIndex == this.windowIndex && ((DataBufferRef)object).mDataHolder == this.mDataHolder;
        }
        return false;
    }
}

