/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

final class SharedPreferencesQueue {
    private final SharedPreferences sharedPreferences;
    private final String queueName;
    private final String itemSeparator;
    @GuardedBy(value="internalQueue")
    @VisibleForTesting
    final ArrayDeque<String> internalQueue = new ArrayDeque();
    private final Executor syncExecutor;
    @GuardedBy(value="internalQueue")
    private boolean bulkOperation = false;

    private SharedPreferencesQueue(SharedPreferences sharedPreferences, String queueName, String itemSeparator, Executor syncExecutor) {
        this.sharedPreferences = sharedPreferences;
        this.queueName = queueName;
        this.itemSeparator = itemSeparator;
        this.syncExecutor = syncExecutor;
    }

    @WorkerThread
    static SharedPreferencesQueue createInstance(SharedPreferences sharedPreferences, String queueName, String itemSeparator, Executor syncExecutor) {
        SharedPreferencesQueue queue = new SharedPreferencesQueue(sharedPreferences, queueName, itemSeparator, syncExecutor);
        queue.initQueue();
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void initQueue() {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            this.internalQueue.clear();
            String queue = this.sharedPreferences.getString(this.queueName, "");
            if (TextUtils.isEmpty((CharSequence)queue) || !queue.contains(this.itemSeparator)) {
                return;
            }
            String[] queueItems = queue.split(this.itemSeparator, -1);
            if (queueItems.length == 0) {
                Log.e((String)"FirebaseMessaging", (String)"Corrupted queue. Please check the queue contents and item separator provided");
            }
            for (String item : queueItems) {
                if (TextUtils.isEmpty((CharSequence)item)) continue;
                this.internalQueue.add(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<String> toList() {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            return new ArrayList<String>(this.internalQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(@NonNull String item) {
        if (TextUtils.isEmpty((CharSequence)item) || item.contains(this.itemSeparator)) {
            return false;
        }
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            return this.checkAndSyncState(this.internalQueue.add(item));
        }
    }

    @GuardedBy(value="internalQueue")
    private String checkAndSyncState(String transactionValue) {
        this.checkAndSyncState(transactionValue != null);
        return transactionValue;
    }

    @GuardedBy(value="internalQueue")
    private boolean checkAndSyncState(boolean transactionState) {
        if (transactionState && !this.bulkOperation) {
            this.syncStateAsync();
        }
        return transactionState;
    }

    private void syncStateAsync() {
        this.syncExecutor.execute(this::syncState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void syncState() {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            this.sharedPreferences.edit().putString(this.queueName, this.serialize()).commit();
        }
    }

    @GuardedBy(value="internalQueue")
    @NonNull
    public String serialize() {
        StringBuilder builder = new StringBuilder();
        for (String item : this.internalQueue) {
            builder.append(item).append(this.itemSeparator);
        }
        return builder.toString();
    }

    @GuardedBy(value="internalQueue")
    public void beginTransaction() {
        this.bulkOperation = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void beginTransactionSync() {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            this.beginTransaction();
        }
    }

    @GuardedBy(value="internalQueue")
    public void commitTransaction() {
        this.bulkOperation = false;
        this.syncStateAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void commitTransactionSync() {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            this.commitTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public String serializeSync() {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            return this.serialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(@Nullable Object o) {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            return this.checkAndSyncState(this.internalQueue.remove(o));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String remove() {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            return this.checkAndSyncState(this.internalQueue.remove());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            this.internalQueue.clear();
            this.checkAndSyncState(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String peek() {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            return this.internalQueue.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            return this.internalQueue.size();
        }
    }
}

