/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common.internal;

import android.os.Parcelable;
import com.huawei.hmf.tasks.CancellationToken;
import com.huawei.hmf.tasks.TaskCompletionSource;
import com.huawei.hms.common.internal.AnyClient;
import com.huawei.hms.common.internal.ResponseErrorCode;
import com.huawei.hms.support.log.HMSLog;

public abstract class TaskApiCall<ClientT extends AnyClient, ResultT> {
    private static final String TAG = "TaskApiCall";
    private final String mUri;
    private final String mRequestJson;
    private Parcelable parcelable;
    private String transactionId;
    private CancellationToken token;
    private int apiLevel;

    @Deprecated
    public TaskApiCall(String string, String string2) {
        TaskApiCall taskApiCall = this;
        this.apiLevel = 1;
        this.mUri = string;
        taskApiCall.mRequestJson = string2;
        taskApiCall.parcelable = null;
        taskApiCall.transactionId = null;
    }

    public TaskApiCall(String string, String string2, String string3) {
        TaskApiCall taskApiCall = this;
        this.apiLevel = 1;
        this.mUri = string;
        taskApiCall.mRequestJson = string2;
        taskApiCall.parcelable = null;
        this.transactionId = string3;
    }

    public TaskApiCall(String string, String string2, String string3, int n) {
        TaskApiCall taskApiCall = this;
        this.apiLevel = 1;
        this.mUri = string;
        taskApiCall.mRequestJson = string2;
        taskApiCall.parcelable = null;
        this.transactionId = string3;
        this.apiLevel = n;
    }

    public CancellationToken getToken() {
        return this.token;
    }

    public void setToken(CancellationToken cancellationToken) {
        this.token = cancellationToken;
    }

    public String getUri() {
        return this.mUri;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String string) {
        this.transactionId = string;
    }

    public String getRequestJson() {
        return this.mRequestJson;
    }

    public Parcelable getParcelable() {
        return this.parcelable;
    }

    public void setParcelable(Parcelable parcelable) {
        this.parcelable = parcelable;
    }

    public int getApiLevel() {
        return this.apiLevel;
    }

    public void setApiLevel(int n) {
        this.apiLevel = n;
    }

    protected abstract void doExecute(ClientT var1, ResponseErrorCode var2, String var3, TaskCompletionSource<ResultT> var4);

    @Deprecated
    public int getMinApkVersion() {
        return 30000000;
    }

    public final void onResponse(ClientT ClientT, ResponseErrorCode responseErrorCode, String string, TaskCompletionSource<ResultT> taskCompletionSource) {
        CancellationToken cancellationToken = this.token;
        if (cancellationToken != null && cancellationToken.isCancellationRequested()) {
            HMSLog.i((String)TAG, (String)("This Task has been canceled, uri:" + this.mUri + ", transactionId:" + this.transactionId));
            return;
        }
        HMSLog.i((String)TAG, (String)("doExecute, uri:" + this.mUri + ", errorCode:" + responseErrorCode.getErrorCode() + ", transactionId:" + this.transactionId));
        this.doExecute(ClientT, responseErrorCode, string, taskCompletionSource);
    }
}

