/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.encoders.proto;

import androidx.annotation.NonNull;
import java.io.OutputStream;

final class LengthCountingOutputStream
extends OutputStream {
    private long length = 0L;

    LengthCountingOutputStream() {
    }

    @Override
    public void write(int b) {
        ++this.length;
    }

    @Override
    public void write(byte[] b) {
        this.length += (long)b.length;
    }

    @Override
    public void write(@NonNull byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.length += (long)len;
    }

    long getLength() {
        return this.length;
    }
}

