/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.support.api;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Pair;
import com.huawei.hms.adapter.BaseAdapter;
import com.huawei.hms.common.internal.TransactionIdCreater;
import com.huawei.hms.core.aidl.AbstractMessageEntity;
import com.huawei.hms.core.aidl.IMessageEntity;
import com.huawei.hms.support.api.client.ApiClient;
import com.huawei.hms.support.api.client.InnerPendingResult;
import com.huawei.hms.support.api.client.Result;
import com.huawei.hms.support.api.client.ResultCallback;
import com.huawei.hms.support.api.client.Status;
import com.huawei.hms.support.api.client.SubAppInfo;
import com.huawei.hms.support.api.transport.DatagramTransport;
import com.huawei.hms.support.gentyref.GenericTypeReflector;
import com.huawei.hms.support.hianalytics.HiAnalyticsUtil;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.utils.Util;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class PendingResultImpl<R extends Result, T extends IMessageEntity>
extends InnerPendingResult<R> {
    private static final String TAG = "PendingResultImpl";
    protected DatagramTransport transport;
    private CountDownLatch countLatch;
    private R result;
    private WeakReference<ApiClient> api;
    private String url;
    private String transId;
    private boolean isNeedReport;

    public PendingResultImpl(ApiClient apiClient, String string, IMessageEntity iMessageEntity) {
        PendingResultImpl pendingResultImpl = this;
        pendingResultImpl.transport = null;
        pendingResultImpl.result = null;
        pendingResultImpl.url = null;
        pendingResultImpl.transId = null;
        pendingResultImpl.isNeedReport = true;
        this.init(apiClient, string, iMessageEntity, pendingResultImpl.getResponseType(), 0);
    }

    public PendingResultImpl(ApiClient apiClient, String string, IMessageEntity iMessageEntity, Class<T> clazz) {
        this.transport = null;
        this.result = null;
        this.url = null;
        this.transId = null;
        this.isNeedReport = true;
        this.init(apiClient, string, iMessageEntity, clazz, 0);
    }

    public PendingResultImpl(ApiClient apiClient, String string, IMessageEntity iMessageEntity, int n) {
        PendingResultImpl pendingResultImpl = this;
        pendingResultImpl.transport = null;
        pendingResultImpl.result = null;
        pendingResultImpl.url = null;
        pendingResultImpl.transId = null;
        pendingResultImpl.isNeedReport = true;
        this.init(apiClient, string, iMessageEntity, pendingResultImpl.getResponseType(), n);
    }

    /*
     * WARNING - void declaration
     */
    private void init(ApiClient apiClient, String string, IMessageEntity iMessageEntity, Class<T> clazz, int n) {
        void var0_7;
        HMSLog.i((String)TAG, (String)("init uri:" + string));
        this.url = string;
        if (apiClient == null) {
            HMSLog.e((String)TAG, (String)"client is null");
            return;
        }
        PendingResultImpl pendingResultImpl = this;
        pendingResultImpl.api = new WeakReference<ApiClient>(apiClient);
        pendingResultImpl.countLatch = new CountDownLatch(1);
        Class<?> clazz2 = Class.forName(apiClient.getTransportName());
        Class[] classArray = new Class[4];
        classArray[0] = String.class;
        classArray[1] = IMessageEntity.class;
        classArray[2] = Class.class;
        classArray[3] = Integer.TYPE;
        Constructor<?> constructor = clazz2.getConstructor(classArray);
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = objectArray;
        objectArray[0] = string;
        objectArray[1] = iMessageEntity;
        objectArray[2] = clazz;
        try {
            objectArray3[3] = n;
            this.transport = (DatagramTransport)constructor.newInstance(objectArray2);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        HMSLog.e((String)TAG, (String)("gen transport error:" + var0_7.getMessage()));
        throw new IllegalStateException("Instancing transport exception, " + var0_7.getMessage(), (Throwable)var0_7);
    }

    private void setResult(int n, IMessageEntity iMessageEntity) {
        Object object;
        HMSLog.i((String)TAG, (String)("setResult:" + n));
        Object object2 = null;
        if (iMessageEntity instanceof AbstractMessageEntity) {
            object2 = ((AbstractMessageEntity)iMessageEntity).getCommonStatus();
        }
        this.result = n == 0 ? this.onComplete(iMessageEntity) : this.onError(n);
        if (this.isNeedReport) {
            this.biReportEvent(n, 2);
        }
        if ((object = this.result) != null && (object = ((Result)object).getStatus()) != null && object2 != null) {
            int n2 = ((Status)object).getStatusCode();
            String string = ((Status)object).getStatusMessage();
            int n3 = ((Status)object2).getStatusCode();
            object2 = ((Status)object2).getStatusMessage();
            if (n2 != n3) {
                HMSLog.e((String)TAG, (String)("rstStatus code (" + n2 + ") is not equal commonStatus code (" + n3 + ")"));
                HMSLog.e((String)TAG, (String)("rstStatus msg (" + string + ") is not equal commonStatus msg (" + (String)object2 + ")"));
            } else if (TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)object2)) {
                HMSLog.i((String)TAG, (String)("rstStatus msg (" + string + ") is not equal commonStatus msg (" + (String)object2 + ")"));
                ((Result)this.result).setStatus(new Status(n2, (String)object2, ((Status)object).getResolution()));
            }
        }
    }

    private void biReportEvent(int n, int n2) {
        HMSLog.i((String)TAG, (String)"biReportEvent ====== ");
        ApiClient apiClient = (ApiClient)stringArray.api.get();
        if (apiClient != null && stringArray.url != null && !HiAnalyticsUtil.getInstance().hasError(apiClient.getContext())) {
            SubAppInfo subAppInfo;
            HashMap<String, String> hashMap;
            HashMap<String, String> hashMap2 = hashMap;
            hashMap2();
            hashMap.put("package", apiClient.getPackageName());
            hashMap.put("baseVersion", "6.5.0.300");
            if (n2 == 1) {
                hashMap2.put("direction", "req");
            } else {
                hashMap2.put("direction", "rsp");
                hashMap2.put("result", String.valueOf(n));
                R r = stringArray.result;
                if (r != null && ((Result)r).getStatus() != null) {
                    hashMap2.put("statusCode", String.valueOf(((Result)stringArray.result).getStatus().getStatusCode()));
                }
            }
            hashMap2.put("version", "0");
            String string = Util.getAppId(apiClient.getContext());
            if (TextUtils.isEmpty((CharSequence)string) && (subAppInfo = apiClient.getSubAppInfo()) != null) {
                string = subAppInfo.getSubAppID();
            }
            hashMap2.put("appid", string);
            if (TextUtils.isEmpty((CharSequence)stringArray.transId)) {
                stringArray.transId = TransactionIdCreater.getId(string, stringArray.url);
                hashMap2.put("transId", stringArray.transId);
            } else {
                hashMap2.put("transId", stringArray.transId);
                stringArray.transId = null;
            }
            String[] stringArray = stringArray.url.split("\\.");
            if (stringArray.length >= 2) {
                hashMap2.put("service", stringArray[0]);
                hashMap2.put("apiName", stringArray[1]);
            }
            HashMap<String, String> hashMap3 = hashMap2;
            hashMap3.put("callTime", String.valueOf(System.currentTimeMillis()));
            hashMap3.put("phoneType", Util.getSystemProperties("ro.logsystem.usertype", ""));
            HiAnalyticsUtil.getInstance().onEvent(apiClient.getContext(), "HMS_SDK_BASE_CALL_AIDL", hashMap2);
            return;
        }
    }

    protected Class<T> getResponseType() {
        if ((this = this.getClass().getGenericSuperclass()) != null && (this = ((ParameterizedType)this).getActualTypeArguments()[1]) != null) {
            return (Class)this;
        }
        return null;
    }

    @Override
    public final R await() {
        HMSLog.i((String)TAG, (String)"await");
        if (Looper.myLooper() != Looper.getMainLooper()) {
            return this.awaitOnAnyThread();
        }
        HMSLog.e((String)TAG, (String)"await in main thread");
        throw new IllegalStateException("await must not be called on the UI thread");
    }

    @Override
    public final R awaitOnAnyThread() {
        HMSLog.i((String)TAG, (String)"awaitOnAnyThread");
        Object object = this.api;
        if (object == null) {
            PendingResultImpl pendingResultImpl = this;
            HMSLog.e((String)TAG, (String)"api is null");
            pendingResultImpl.setResult(907135003, null);
            return pendingResultImpl.result;
        }
        if (!this.checkApiClient((ApiClient)(object = (ApiClient)((Reference)object).get()))) {
            PendingResultImpl pendingResultImpl = this;
            HMSLog.e((String)TAG, (String)"client invalid");
            pendingResultImpl.setResult(907135003, null);
            return pendingResultImpl.result;
        }
        if (this.isNeedReport) {
            this.biReportEvent(0, 1);
        }
        PendingResultImpl pendingResultImpl = this;
        pendingResultImpl.transport.send((ApiClient)object, new DatagramTransport.a(){

            @Override
            public void a(int n, IMessageEntity iMessageEntity) {
                a a2 = this;
                a2.PendingResultImpl.this.setResult(n, iMessageEntity);
                a2.PendingResultImpl.this.countLatch.countDown();
            }
        });
        try {
            pendingResultImpl.countLatch.await();
        }
        catch (InterruptedException interruptedException) {
            HMSLog.e((String)TAG, (String)"await in anythread InterruptedException");
            this.setResult(907135001, null);
        }
        return this.result;
    }

    @Override
    public R await(long l, TimeUnit timeUnit) {
        HMSLog.i((String)TAG, (String)("await timeout:" + l + " unit:" + timeUnit.toString()));
        if (Looper.myLooper() != Looper.getMainLooper()) {
            return this.awaitOnAnyThread(l, timeUnit);
        }
        HMSLog.i((String)TAG, (String)"await in main thread");
        throw new IllegalStateException("await must not be called on the UI thread");
    }

    @Override
    public final R awaitOnAnyThread(long l, TimeUnit timeUnit) {
        block6: {
            AtomicBoolean atomicBoolean;
            HMSLog.i((String)TAG, (String)("awaitOnAnyThread timeout:" + l + " unit:" + timeUnit.toString()));
            Object object = this.api;
            if (object == null) {
                PendingResultImpl pendingResultImpl = this;
                HMSLog.e((String)TAG, (String)"api is null");
                pendingResultImpl.setResult(907135003, null);
                return pendingResultImpl.result;
            }
            if (!this.checkApiClient((ApiClient)(object = (ApiClient)((Reference)object).get()))) {
                PendingResultImpl pendingResultImpl = this;
                HMSLog.e((String)TAG, (String)"client invalid");
                pendingResultImpl.setResult(907135003, null);
                return pendingResultImpl.result;
            }
            final AtomicBoolean atomicBoolean2 = atomicBoolean;
            atomicBoolean = new AtomicBoolean();
            if (this.isNeedReport) {
                this.biReportEvent(0, 1);
            }
            PendingResultImpl pendingResultImpl = this;
            pendingResultImpl.transport.post((ApiClient)object, new DatagramTransport.a(){

                @Override
                public void a(int n, IMessageEntity iMessageEntity) {
                    if (!atomicBoolean2.get()) {
                        PendingResultImpl.this.setResult(n, iMessageEntity);
                    }
                    PendingResultImpl.this.countLatch.countDown();
                }
            });
            if (pendingResultImpl.countLatch.await(l, timeUnit)) break block6;
            try {
                atomicBoolean2.set(true);
                this.setResult(907135004, null);
            }
            catch (InterruptedException interruptedException) {
                HMSLog.e((String)TAG, (String)"awaitOnAnyThread InterruptedException");
                this.setResult(907135001, null);
            }
        }
        return this.result;
    }

    @Override
    public void setResultCallback(ResultCallback<R> resultCallback) {
        this.isNeedReport = resultCallback instanceof BaseAdapter.BaseRequestResultCallback ^ true;
        this.setResultCallback(Looper.getMainLooper(), resultCallback);
    }

    @Override
    public final void setResultCallback(Looper object, final ResultCallback<R> resultCallback) {
        HMSLog.i((String)TAG, (String)"setResultCallback");
        if (object == null) {
            object = Looper.myLooper();
        }
        final d<R> d2 = new d<R>((Looper)object);
        object = this.api;
        if (object == null) {
            HMSLog.e((String)TAG, (String)"api is null");
            this.setResult(907135003, null);
            return;
        }
        if (!this.checkApiClient((ApiClient)(object = (ApiClient)((Reference)object).get()))) {
            PendingResultImpl pendingResultImpl = this;
            HMSLog.e((String)TAG, (String)"client is invalid");
            pendingResultImpl.setResult(907135003, null);
            d2.a(resultCallback, pendingResultImpl.result);
            return;
        }
        if (this.isNeedReport) {
            this.biReportEvent(0, 1);
        }
        this.transport.post((ApiClient)object, new DatagramTransport.a(){

            @Override
            public void a(int n, IMessageEntity iMessageEntity) {
                c c2 = this;
                c2.PendingResultImpl.this.setResult(n, iMessageEntity);
                c2.d2.a(resultCallback, PendingResultImpl.this.result);
            }
        });
    }

    @Override
    @Deprecated
    public void cancel() {
    }

    @Override
    @Deprecated
    public boolean isCanceled() {
        return false;
    }

    @Override
    @Deprecated
    public void setResultCallback(ResultCallback<R> resultCallback, long l, TimeUnit timeUnit) {
        this.setResultCallback(resultCallback);
    }

    public abstract R onComplete(T var1);

    protected R onError(int n) {
        Type type = this.getClass().getGenericSuperclass();
        Type type2 = null;
        if (type != null) {
            type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        type = null;
        if (type2 != null) {
            type = GenericTypeReflector.getType((Type)type2);
        }
        if (type != null) {
            try {
                this.result = (Result)((Class)type).newInstance();
                ((Result)this.result).setStatus(new Status(n));
            }
            catch (Exception exception) {
                HMSLog.e((String)TAG, (String)("on Error:" + exception.getMessage()));
                return null;
            }
        }
        return this.result;
    }

    protected boolean checkApiClient(ApiClient apiClient) {
        return true;
    }

    protected static class d<R extends Result>
    extends Handler {
        public d(Looper looper) {
            super(looper);
        }

        public void a(ResultCallback<? super R> resultCallback, R r) {
            Pair pair;
            d d2 = d3;
            d d3 = pair;
            pair = new Pair(resultCallback, r);
            d2.sendMessage(d2.obtainMessage(1, (Object)d3));
        }

        public void handleMessage(Message message) {
            if (message.what == 1) {
                d d2 = d3;
                d d3 = (Pair)message.obj;
                d2.b((ResultCallback)((Pair)d3).first, (Result)((Pair)d3).second);
            }
        }

        protected void b(ResultCallback<? super R> resultCallback, R r) {
            resultCallback.onResult(r);
        }
    }
}

