/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.huawei.hms.activity.BridgeActivity;
import com.huawei.hms.adapter.sysobs.SystemManager;
import com.huawei.hms.adapter.sysobs.SystemObserver;
import com.huawei.hms.adapter.ui.NotInstalledHmsAdapter;
import com.huawei.hms.adapter.ui.UpdateAdapter;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.update.note.AppSpoofResolution;
import com.huawei.hms.utils.Checker;
import com.huawei.hms.utils.HMSPackageManager;
import com.huawei.hms.utils.PackageManagerHelper;
import com.huawei.hms.utils.UIUtil;

public class AvailableAdapter {
    public final int a;
    public AvailableCallBack b;
    public boolean c;
    public SystemObserver d;

    public AvailableAdapter(int n) {
        AvailableAdapter availableAdapter = this;
        this.d = new SystemObserver(){

            @Override
            public boolean onUpdateResult(int n) {
                AvailableCallBack availableCallBack = availableCallBack.AvailableAdapter.this.a();
                if (availableCallBack == null) {
                    HMSLog.e((String)"AvailableAdapter", (String)"onUpdateResult baseCallBack null");
                    return true;
                }
                availableCallBack.onComplete(n);
                return true;
            }

            @Override
            public boolean onNoticeResult(int n) {
                AvailableCallBack availableCallBack = availableCallBack.AvailableAdapter.this.a();
                if (availableCallBack == null) {
                    HMSLog.e((String)"AvailableAdapter", (String)"onNoticeResult baseCallBack null");
                    return true;
                }
                availableCallBack.onComplete(n);
                return true;
            }

            @Override
            public boolean onSolutionResult(Intent intent, String string) {
                return false;
            }
        };
        availableAdapter.a = n;
        availableAdapter.c = false;
    }

    public void setCalledBySolutionInstallHms(boolean bl) {
        this.c = bl;
    }

    public int isHuaweiMobileServicesAvailable(Context context) {
        Context context2 = context;
        Checker.checkNonNull((Object)context2, (String)"context must not be null.");
        int n = this.a(context2);
        if (n != 0) {
            return n;
        }
        if (HMSPackageManager.getInstance((Context)context).isApkUpdateNecessary(this.a)) {
            HMSLog.i((String)"AvailableAdapter", (String)"The current version does not meet the minimum version requirements");
            n = 2;
        }
        return n;
    }

    public int checkHuaweiMobileServicesForUpdate(Context context) {
        Context context2 = context;
        Checker.checkNonNull((Object)context2, (String)"context must not be null.");
        int n = this.a(context2);
        if (n != 0) {
            return n;
        }
        if (HMSPackageManager.getInstance((Context)context).isApkNeedUpdate(this.a)) {
            HMSLog.i((String)"AvailableAdapter", (String)"The current version does not meet the target version requirements");
            n = 2;
        }
        return n;
    }

    public boolean isUserResolvableError(int n) {
        return n == 1 || n == 2;
    }

    public boolean isUserNoticeError(int n) {
        return n == 29;
    }

    public void startResolution(Activity activity, AvailableCallBack availableCallBack) {
        if (activity != null && availableCallBack != null) {
            if (UIUtil.isBackground((Context)activity)) {
                HMSLog.i((String)"AvailableAdapter", (String)"current app is in Background");
                availableCallBack.onComplete(28);
                return;
            }
            if (!this.a(activity)) {
                this.a(activity, availableCallBack);
                return;
            }
            HMSLog.i((String)"AvailableAdapter", (String)"startResolution");
            this.b = availableCallBack;
            SystemManager.getSystemNotifier().registerObserver(this.d);
            availableCallBack = BridgeActivity.getIntentStartBridgeActivity((Activity)activity, (String)UpdateAdapter.class.getName());
            availableCallBack.putExtra("update_version", this.a);
            if (this.c) {
                availableCallBack.putExtra("installHMS", "installHMS");
            }
            AvailableCallBack availableCallBack2 = availableCallBack;
            availableCallBack2.putExtra("new_update", true);
            activity.startActivity((Intent)availableCallBack2);
            return;
        }
    }

    public void startNotice(Activity activity, AvailableCallBack availableCallBack) {
        if (activity != null && availableCallBack != null) {
            if (UIUtil.isBackground((Context)activity)) {
                HMSLog.i((String)"AvailableAdapter", (String)"current app is in Background");
                availableCallBack.onComplete(28);
                return;
            }
            Activity activity2 = activity;
            HMSLog.i((String)"AvailableAdapter", (String)"startNotice");
            this.b = availableCallBack;
            SystemManager.getSystemNotifier().registerObserver(this.d);
            activity2.startActivity(BridgeActivity.getIntentStartBridgeActivity((Activity)activity2, (String)AppSpoofResolution.class.getName()));
            return;
        }
    }

    public final int a(Context context) {
        if (Build.VERSION.SDK_INT < 16) {
            HMSLog.i((String)"AvailableAdapter", (String)"HMS can not be supported under android 4.1");
            return 21;
        }
        AvailableAdapter availableAdapter = HMSPackageManager.getInstance((Context)context).getHMSPackageStatesForMultiService();
        if (PackageManagerHelper.PackageStates.NOT_INSTALLED.equals((Object)availableAdapter)) {
            HMSLog.i((String)"AvailableAdapter", (String)"HMS is not installed");
            return 1;
        }
        if (PackageManagerHelper.PackageStates.SPOOF.equals((Object)availableAdapter)) {
            HMSLog.i((String)"AvailableAdapter", (String)"HMS is spoofed");
            return 29;
        }
        if (PackageManagerHelper.PackageStates.DISABLED.equals((Object)availableAdapter)) {
            HMSLog.i((String)"AvailableAdapter", (String)"HMS is disabled");
            return 3;
        }
        return 0;
    }

    public final void a(Activity activity, AvailableCallBack availableCallBack) {
        HMSLog.i((String)"AvailableAdapter", (String)"<showHmsApkNotInstalledDialog> startResolution");
        if (NotInstalledHmsAdapter.getShowLock()) {
            Activity activity2 = activity;
            this.b = availableCallBack;
            SystemManager.getSystemNotifier().registerObserver(this.d);
            activity2.startActivity(BridgeActivity.getIntentStartBridgeActivity((Activity)activity2, (String)NotInstalledHmsAdapter.class.getName()));
        } else {
            availableCallBack.onComplete(31);
        }
    }

    public final boolean a(Activity activity) {
        boolean bl = false;
        if (HMSPackageManager.getInstance((Context)activity).getHmsVersionCode() >= 40000000) {
            HMSLog.i((String)"AvailableAdapter", (String)"enter 4.0 HmsCore upgrade process");
            bl = true;
        }
        return bl;
    }

    public final AvailableCallBack a() {
        return this.b;
    }

    public static interface AvailableCallBack {
        public void onComplete(int var1);
    }
}

