/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.activity;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.huawei.hms.activity.IBridgeActivityDelegate;
import com.huawei.hms.activity.internal.BusResponseCallback;
import com.huawei.hms.activity.internal.BusResponseResult;
import com.huawei.hms.activity.internal.ForegroundBusResponseMgr;
import com.huawei.hms.activity.internal.ForegroundInnerHeader;
import com.huawei.hms.adapter.AvailableAdapter;
import com.huawei.hms.api.HuaweiApiAvailability;
import com.huawei.hms.common.internal.RequestHeader;
import com.huawei.hms.common.internal.ResponseHeader;
import com.huawei.hms.support.hianalytics.HiAnalyticsUtil;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.utils.HMSPackageManager;
import com.huawei.hms.utils.JsonUtil;
import com.huawei.hms.utils.UIUtil;
import com.huawei.hms.utils.Util;
import java.lang.ref.WeakReference;
import java.util.Map;

public class ForegroundBusDelegate
implements IBridgeActivityDelegate {
    public static final String HMS_FOREGROUND_REQ_HEADER = "HMS_FOREGROUND_REQ_HEADER";
    public static final String HMS_FOREGROUND_REQ_BODY = "HMS_FOREGROUND_REQ_BODY";
    public static final String HMS_FOREGROUND_REQ_INNER = "HMS_FOREGROUND_REQ_INNER";
    public static final String HMS_FOREGROUND_RESP_HEADER = "HMS_FOREGROUND_RESP_HEADER";
    public static final String INNER_PKG_NAME = "INNER_PACKAGE_NAME";
    private static final String TAG = "ForegroundBusDelegate";
    private static final String UI_JUMP_ACTIVITY_NAME = "com.huawei.hms.core.activity.UiJumpActivity";
    private static final String EXTRA_DELEGATE_NAME = "intent.extra.hms.core.DELEGATE_NAME";
    private static final String EXTRA_DELEGATE_VALUE = "com.huawei.hms.core.activity.ForegroundBus";
    private static final int REQUEST_CODE_BUS = 431057;
    private RequestHeader foregroundHeader;
    private String foregroundBody;
    private ForegroundInnerHeader innerHeader = new ForegroundInnerHeader();
    private ResponseHeader responseHeader;
    private WeakReference<Activity> mThisWeakRef;
    private boolean isUseInnerHms;

    private BusResponseCallback getResponseCallback(String string) {
        return ForegroundBusResponseMgr.getInstance().get(string);
    }

    private void succeedReturn(int n, Intent intent) {
        HMSLog.i((String)TAG, (String)"succeedReturn");
        Activity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        activity.setResult(n, intent);
        this.finishBridgeActivity();
    }

    private void errorReturn(int n, String string) {
        HMSLog.e((String)TAG, (String)string);
        Activity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        ForegroundBusDelegate foregroundBusDelegate = this;
        BusResponseCallback busResponseCallback = foregroundBusDelegate.getResponseCallback(foregroundBusDelegate.innerHeader.getResponseCallbackKey());
        if (busResponseCallback != null) {
            BusResponseResult busResponseResult = busResponseCallback.innerError((Activity)this.mThisWeakRef.get(), n, string);
            if (busResponseResult == null) {
                activity.setResult(0);
            } else {
                activity.setResult(busResponseResult.getCode(), busResponseResult.getIntent());
            }
        } else {
            activity.setResult(0);
        }
        this.finishBridgeActivity();
    }

    private void finishBridgeActivity() {
        if ((this = this.getActivity()) != null && !this.isFinishing()) {
            this.finish();
            return;
        }
    }

    private Activity getActivity() {
        WeakReference<Activity> weakReference = ((ForegroundBusDelegate)((Object)weakReference)).mThisWeakRef;
        if (weakReference == null) {
            return null;
        }
        return (Activity)weakReference.get();
    }

    private void checkMinVersion() {
        if (this.getActivity() == null) {
            HMSLog.e((String)TAG, (String)"checkMinVersion failed, activity must not be null.");
            return;
        }
        if (this.isUseInnerHms) {
            this.startApkHubActivity();
            return;
        }
        if (!Util.isAvailableLibExist(this.getActivity().getApplicationContext())) {
            if (HuaweiApiAvailability.getInstance().isHuaweiMobileServicesAvailable(this.getActivity().getApplicationContext(), this.innerHeader.getApkVersion()) != 0) {
                HMSLog.e((String)TAG, (String)"checkMinVersion failed, and no available lib exists.");
                return;
            }
            this.startApkHubActivity();
        } else {
            AvailableAdapter availableAdapter;
            MyAvailableCallBack myAvailableCallBack;
            MyAvailableCallBack myAvailableCallBack2 = myAvailableCallBack;
            myAvailableCallBack = new MyAvailableCallBack();
            AvailableAdapter availableAdapter2 = availableAdapter;
            availableAdapter2(this.innerHeader.getApkVersion());
            int n = availableAdapter.isHuaweiMobileServicesAvailable((Context)this.getActivity());
            if (n == 0) {
                myAvailableCallBack2.onComplete(n);
            } else if (availableAdapter2.isUserResolvableError(n)) {
                ForegroundBusDelegate.resolution(this.getActivity(), availableAdapter2, myAvailableCallBack2);
            } else {
                myAvailableCallBack2.onComplete(n);
            }
        }
    }

    private static void resolution(Activity activity, AvailableAdapter availableAdapter, AvailableAdapter.AvailableCallBack availableCallBack) {
        if (activity == null) {
            HMSLog.i((String)TAG, (String)"null activity, could not start resolution intent");
        }
        availableAdapter.startResolution(activity, availableCallBack);
    }

    private void startApkHubActivity() {
        Intent intent;
        HMSLog.i((String)TAG, (String)"startApkHubActivity");
        Activity activity = this.getActivity();
        if (activity == null) {
            HMSLog.e((String)TAG, (String)"startApkHubActivity but activity is null");
            return;
        }
        String string = this.isUseInnerHms ? activity.getPackageName() : HMSPackageManager.getInstance((Context)activity.getApplicationContext()).getHMSPackageNameForMultiService();
        Intent intent2 = intent;
        intent2(this.innerHeader.getAction());
        intent2.putExtra(HMS_FOREGROUND_REQ_BODY, this.foregroundBody);
        try {
            intent.setPackage(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HMSLog.e((String)TAG, (String)"IllegalArgumentException when startApkHubActivity intent.setPackage");
        }
        Intent intent3 = intent2;
        intent2.putExtra("intent.extra.isfullscreen", UIUtil.isActivityFullscreen((Activity)activity));
        intent2.setClassName(string, UI_JUMP_ACTIVITY_NAME);
        intent3.putExtra(HMS_FOREGROUND_REQ_HEADER, this.foregroundHeader.toJson());
        intent3.putExtra(EXTRA_DELEGATE_NAME, EXTRA_DELEGATE_VALUE);
        try {
            this.biReportRequestEntryStartCore();
            activity.startActivityForResult(intent2, 431057);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            HMSLog.e((String)TAG, (String)"Launch sign in Intent failed. hms is probably being updated\uff1a", (Throwable)activityNotFoundException);
            this.errorReturn(0, "launch bus intent failed");
        }
    }

    private void biReportRequestEntryForegroundBus() {
        Map<String, String> map = HiAnalyticsUtil.getInstance().getMapFromForegroundRequestHeader(this.foregroundHeader);
        map.put("direction", "req");
        map.put("version", HiAnalyticsUtil.versionCodeToName(String.valueOf(this.foregroundHeader.getKitSdkVersion())));
        if (this.getActivity() != null) {
            HiAnalyticsUtil.getInstance().onNewEvent(this.getActivity().getApplicationContext(), "HMS_SDK_BASE_ACTIVITY_STARTED", map);
        }
    }

    private void biReportRequestEntryStartCore() {
        Map<String, String> map = HiAnalyticsUtil.getInstance().getMapFromForegroundRequestHeader(this.foregroundHeader);
        map.put("direction", "req");
        map.put("version", HiAnalyticsUtil.versionCodeToName(String.valueOf(this.foregroundHeader.getKitSdkVersion())));
        if (this.getActivity() != null) {
            HiAnalyticsUtil.getInstance().onNewEvent(this.getActivity().getApplicationContext(), "HMS_SDK_BASE_START_CORE_ACTIVITY", map);
        }
    }

    private void biReportRequestReturnForegroundBus() {
        if (this.foregroundHeader != null) {
            Map<String, String> map = HiAnalyticsUtil.getInstance().getMapFromForegroundRequestHeader(this.foregroundHeader);
            map.put("direction", "rsp");
            map.put("version", HiAnalyticsUtil.versionCodeToName(String.valueOf(this.foregroundHeader.getKitSdkVersion())));
            ResponseHeader responseHeader = this.responseHeader;
            if (responseHeader != null) {
                map.put("statusCode", String.valueOf(responseHeader.getStatusCode()));
                map.put("result", String.valueOf(this.responseHeader.getErrorCode()));
            }
            if (this.getActivity() != null) {
                HiAnalyticsUtil.getInstance().onNewEvent(this.getActivity().getApplicationContext(), "HMS_SDK_BASE_ACTIVITY_STARTED", map);
            }
        }
    }

    private void biReportRequestReturnStartCore() {
        Map<String, String> map = HiAnalyticsUtil.getInstance().getMapFromForegroundRequestHeader(this.foregroundHeader);
        map.put("direction", "rsp");
        map.put("version", HiAnalyticsUtil.versionCodeToName(String.valueOf(this.foregroundHeader.getKitSdkVersion())));
        ResponseHeader responseHeader = this.responseHeader;
        if (responseHeader != null) {
            map.put("statusCode", String.valueOf(responseHeader.getStatusCode()));
            map.put("result", String.valueOf(this.responseHeader.getErrorCode()));
        }
        if (this.getActivity() != null) {
            HiAnalyticsUtil.getInstance().onNewEvent(this.getActivity().getApplicationContext(), "HMS_SDK_BASE_START_CORE_ACTIVITY", map);
        }
    }

    public void onBridgeActivityCreate(Activity activity) {
        this.mThisWeakRef = new WeakReference<Activity>(activity);
        activity = activity.getIntent();
        Object object = activity.getStringExtra(HMS_FOREGROUND_REQ_HEADER);
        this.foregroundHeader = new RequestHeader();
        if (!this.foregroundHeader.fromJson((String)object)) {
            this.errorReturn(0, "header is invalid");
            return;
        }
        this.foregroundBody = activity.getStringExtra(HMS_FOREGROUND_REQ_BODY);
        object = this.innerHeader;
        if (object == null) {
            this.errorReturn(0, "inner header is invalid");
            return;
        }
        ((ForegroundInnerHeader)object).fromJson(activity.getStringExtra(HMS_FOREGROUND_REQ_INNER));
        if (TextUtils.isEmpty((CharSequence)this.foregroundHeader.getApiName())) {
            this.errorReturn(0, "action is invalid");
            return;
        }
        this.biReportRequestEntryForegroundBus();
        if (!TextUtils.isEmpty((CharSequence)activity.getStringExtra(INNER_PKG_NAME))) {
            HMSLog.i((String)TAG, (String)"isUseInnerHms: true");
            this.isUseInnerHms = true;
        }
        this.checkMinVersion();
    }

    public void onBridgeActivityDestroy() {
        this.biReportRequestReturnForegroundBus();
        this.mThisWeakRef = null;
    }

    public boolean onBridgeActivityResult(int n, int n2, Intent intent) {
        if (n == 431057) {
            if (intent != null && intent.hasExtra(HMS_FOREGROUND_RESP_HEADER)) {
                this.responseHeader = new ResponseHeader();
                JsonUtil.jsonToEntity(intent.getStringExtra(HMS_FOREGROUND_RESP_HEADER), this.responseHeader);
            }
            ForegroundBusDelegate foregroundBusDelegate = this;
            foregroundBusDelegate.biReportRequestReturnStartCore();
            Object object = foregroundBusDelegate.getResponseCallback(foregroundBusDelegate.innerHeader.getResponseCallbackKey());
            if (object == null) {
                this.succeedReturn(n2, intent);
            } else if ((object = object.succeedReturn((Activity)this.mThisWeakRef.get(), n2, intent)) == null) {
                this.succeedReturn(n2, intent);
            } else {
                this.succeedReturn(((BusResponseResult)object).getCode(), ((BusResponseResult)object).getIntent());
            }
            return true;
        }
        return false;
    }

    public void onBridgeConfigurationChanged() {
    }

    public int getRequestCode() {
        return 431057;
    }

    public void onKeyUp(int n, KeyEvent keyEvent) {
    }

    private class MyAvailableCallBack
    implements AvailableAdapter.AvailableCallBack {
        private MyAvailableCallBack() {
        }

        public void onComplete(int n) {
            if (n == 0) {
                ForegroundBusDelegate.this.startApkHubActivity();
            } else {
                HMSLog.i((String)ForegroundBusDelegate.TAG, (String)"version check failed");
                ForegroundBusDelegate.this.errorReturn(0, "apk version is invalid");
            }
        }
    }
}

