/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common.internal;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import com.huawei.hms.adapter.AvailableAdapter;
import com.huawei.hms.adapter.BinderAdapter;
import com.huawei.hms.adapter.InnerBinderAdapter;
import com.huawei.hms.adapter.OuterBinderAdapter;
import com.huawei.hms.api.ConnectionResult;
import com.huawei.hms.api.FailedBinderCallBack;
import com.huawei.hms.api.HuaweiApiAvailability;
import com.huawei.hms.api.IPCTransport;
import com.huawei.hms.common.HuaweiApi;
import com.huawei.hms.common.internal.ClientSettings;
import com.huawei.hms.common.internal.RequestManager;
import com.huawei.hms.core.aidl.IAIDLInvoke;
import com.huawei.hms.support.api.client.AidlApiClient;
import com.huawei.hms.support.api.client.SubAppInfo;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.utils.HMSPackageManager;
import com.huawei.hms.utils.Util;
import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BaseHmsClient
implements AidlApiClient {
    private static final String TAG = "BaseHmsClient";
    private static final int MSG_CONN_TIMEOUT = 2;
    private static final int DISCONNECTED = 1;
    private static final int BINDING = 5;
    private static final int CONNECTED = 3;
    protected static final int TIMEOUT_DISCONNECTED = 6;
    private static final Object LOCK_CONNECT_TIMEOUT_HANDLER = new Object();
    private static final AtomicInteger CONN_STATUS = new AtomicInteger(1);
    private static final AtomicInteger INNER_CONN_STATUS = new AtomicInteger(1);
    private static BinderAdapter mOuterBinderAdapter;
    private static BinderAdapter mInnerBinderAdapter;
    private final Context mContext;
    private String mAppID;
    private final ClientSettings mClientSettings;
    private volatile IAIDLInvoke mService;
    protected String sessionId;
    private final ConnectionCallbacks mConnectionCallbacks;
    private final OnConnectionFailedListener mConnectionFailedListener;
    private Handler mConnectTimeoutHandler = null;
    private HuaweiApi.RequestHandler internalRequest;

    public BaseHmsClient(Context context, ClientSettings clientSettings, OnConnectionFailedListener onConnectionFailedListener, ConnectionCallbacks connectionCallbacks) {
        this.mContext = context;
        this.mClientSettings = clientSettings;
        this.mAppID = this.mClientSettings.getAppID();
        this.mConnectionFailedListener = onConnectionFailedListener;
        this.mConnectionCallbacks = connectionCallbacks;
    }

    private void bindCoreInternal(String string, String string2) {
        if (this.mClientSettings.isUseInnerHms()) {
            BaseHmsClient baseHmsClient = this;
            mInnerBinderAdapter = InnerBinderAdapter.getInstance(baseHmsClient.mContext, string2, string);
            if (baseHmsClient.isConnected()) {
                BaseHmsClient baseHmsClient2 = this;
                HMSLog.i((String)TAG, (String)"The binder is already connected.");
                baseHmsClient2.getAdapter().updateDelayTask();
                baseHmsClient2.connectedInternal(baseHmsClient2.getAdapter().getServiceBinder());
                return;
            }
            this.setConnectStatus(5);
            mInnerBinderAdapter.binder(this.newBinderCallBack());
            return;
        }
        BaseHmsClient baseHmsClient = this;
        mOuterBinderAdapter = OuterBinderAdapter.getInstance(baseHmsClient.mContext, string2, string);
        if (baseHmsClient.isConnected()) {
            BaseHmsClient baseHmsClient3 = this;
            HMSLog.i((String)TAG, (String)"The binder is already connected.");
            baseHmsClient3.getAdapter().updateDelayTask();
            baseHmsClient3.connectedInternal(baseHmsClient3.getAdapter().getServiceBinder());
            return;
        }
        this.setConnectStatus(5);
        mOuterBinderAdapter.binder(this.newBinderCallBack());
    }

    private BinderAdapter.BinderCallBack newBinderCallBack() {
        return new BinderAdapter.BinderCallBack(){

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                HMSLog.i((String)BaseHmsClient.TAG, (String)"Enter onServiceConnected.");
                BaseHmsClient.this.connectedInternal(iBinder);
            }

            @Override
            public void onBinderFailed(int n) {
                this.onBinderFailed(n, null);
            }

            @Override
            public void onBinderFailed(int n, Intent intent) {
                if (intent != null) {
                    Activity activity = Util.getActiveActivity(this_.BaseHmsClient.this.getClientSettings().getCpActivity(), this_.BaseHmsClient.this.getContext());
                    if (activity != null) {
                        Intent intent2 = intent;
                        HMSLog.i((String)BaseHmsClient.TAG, (String)"onBinderFailed: SDK try to resolve and reConnect!");
                        long l = new Timestamp(System.currentTimeMillis()).getTime();
                        FailedBinderCallBack.getInstance().setCallBack(l, new FailedBinderCallBack.BinderCallBack(){

                            @Override
                            public void binderCallBack(int n) {
                                if (n != 0) {
                                    1 v0 = this;
                                    v0.BaseHmsClient.this.notifyFailed(new ConnectionResult(10, null));
                                    BaseHmsClient.access$102(v0.BaseHmsClient.this, null);
                                }
                            }
                        });
                        intent2.putExtra("callId", l);
                        activity.startActivity(intent2);
                    } else {
                        1 v1 = this_;
                        HMSLog.i((String)BaseHmsClient.TAG, (String)"onBinderFailed: return pendingIntent to kit and cp");
                        1 this_ = PendingIntent.getActivity((Context)v1.BaseHmsClient.this.mContext, (int)11, (Intent)intent, (int)0x4000000);
                        v1.BaseHmsClient.this.notifyFailed(new ConnectionResult(10, (PendingIntent)this_));
                        BaseHmsClient.access$102(v1.BaseHmsClient.this, null);
                    }
                } else {
                    1 v2 = this_;
                    HMSLog.i((String)BaseHmsClient.TAG, (String)"onBinderFailed: intent is null!");
                    v2.BaseHmsClient.this.notifyFailed(new ConnectionResult(10, null));
                    BaseHmsClient.access$102(v2.BaseHmsClient.this, null);
                }
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                1 v0 = this;
                HMSLog.i((String)BaseHmsClient.TAG, (String)"Enter onServiceDisconnected.");
                v0.BaseHmsClient.this.setConnectStatus(1);
                RequestManager.getHandler().sendEmptyMessage(10013);
                if (v0.BaseHmsClient.this.mConnectionCallbacks != null && !(BaseHmsClient.this.mConnectionCallbacks instanceof HuaweiApi.RequestHandler)) {
                    BaseHmsClient.this.mConnectionCallbacks.onConnectionSuspended(1);
                }
            }

            @Override
            public void onNullBinding(ComponentName componentName) {
                1 v0 = this;
                v0.BaseHmsClient.this.setConnectStatus(1);
                v0.BaseHmsClient.this.notifyFailed(10);
            }

            @Override
            public void onTimedDisconnected() {
                1 v0 = this;
                v0.BaseHmsClient.this.setConnectStatus(6);
                if (v0.BaseHmsClient.this.mConnectionCallbacks != null && !(BaseHmsClient.this.mConnectionCallbacks instanceof HuaweiApi.RequestHandler)) {
                    BaseHmsClient.this.mConnectionCallbacks.onConnectionSuspended(1);
                }
            }
        };
    }

    private void tryUnBind() {
        HMSLog.w((String)TAG, (String)"Failed to get service as interface, trying to unbind.");
        if (this.mClientSettings.isUseInnerHms()) {
            BinderAdapter binderAdapter = mInnerBinderAdapter;
            if (binderAdapter == null) {
                HMSLog.w((String)TAG, (String)"mInnerBinderAdapter is null.");
                return;
            }
            binderAdapter.unBind();
        } else {
            BinderAdapter binderAdapter = mOuterBinderAdapter;
            if (binderAdapter == null) {
                HMSLog.w((String)TAG, (String)"mOuterBinderAdapter is null.");
                return;
            }
            binderAdapter.unBind();
        }
        BaseHmsClient baseHmsClient = this;
        baseHmsClient.setConnectStatus(1);
        baseHmsClient.notifyFailed(10);
    }

    private void unBindAdapter() {
        Object object;
        if (((BaseHmsClient)object).mClientSettings.isUseInnerHms()) {
            object = mInnerBinderAdapter;
            if (object != null) {
                ((BinderAdapter)object).unBind();
            }
            return;
        }
        object = mOuterBinderAdapter;
        if (object != null) {
            ((BinderAdapter)object).unBind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cancelConnDelayHandle() {
        Object object = LOCK_CONNECT_TIMEOUT_HANDLER;
        synchronized (object) {
            if (this.mConnectTimeoutHandler != null) {
                this.mConnectTimeoutHandler.removeMessages(2);
                this.mConnectTimeoutHandler = null;
            }
            return;
        }
    }

    private void checkAvailabilityAndConnect(int n, boolean bl) {
        HMSLog.i((String)TAG, (String)"====== HMSSDK version: 60500300 ======");
        int n2 = this.mClientSettings.isUseInnerHms() ? INNER_CONN_STATUS.get() : CONN_STATUS.get();
        HMSLog.i((String)TAG, (String)("Enter connect, Connection Status: " + n2));
        if (!(bl || n2 != 3 && n2 != 5)) {
            return;
        }
        if (this.getMinApkVersion() > n) {
            n = this.getMinApkVersion();
        }
        HMSLog.i((String)TAG, (String)("connect minVersion:" + n + " packageName:" + this.mClientSettings.getInnerHmsPkg()));
        if (this.mContext.getPackageName().equals(this.mClientSettings.getInnerHmsPkg())) {
            HMSLog.i((String)TAG, (String)"service packageName is same, bind core service return");
            this.bindCoreService();
            return;
        }
        if (Util.isAvailableLibExist(this.mContext)) {
            AvailableAdapter availableAdapter;
            AvailableAdapter availableAdapter2 = availableAdapter;
            availableAdapter2(n);
            n = availableAdapter.isHuaweiMobileServicesAvailable(this.mContext);
            HMSLog.i((String)TAG, (String)("check available result: " + n));
            if (n == 0) {
                this.bindCoreService();
            } else if (availableAdapter2.isUserResolvableError(n)) {
                HMSLog.i((String)TAG, (String)"bindCoreService3.0 fail, start resolution now.");
                this.resolution(availableAdapter2, n);
            } else if (availableAdapter2.isUserNoticeError(n)) {
                HMSLog.i((String)TAG, (String)"bindCoreService3.0 fail, start notice now.");
                this.notice(availableAdapter2, n);
            } else {
                HMSLog.i((String)TAG, (String)("bindCoreService3.0 fail: " + n + " is not resolvable."));
                this.notifyFailed(n);
            }
        } else {
            n = HuaweiApiAvailability.getInstance().isHuaweiMobileServicesAvailable(this.mContext, n);
            HMSLog.i((String)TAG, (String)("HuaweiApiAvailability check available result: " + n));
            if (n == 0) {
                this.bindCoreService();
            } else {
                this.notifyFailed(n);
            }
        }
    }

    private void notice(AvailableAdapter availableAdapter, int n) {
        HMSLog.i((String)TAG, (String)"enter notice");
        if (!baseHmsClient2.getClientSettings().isHasActivity()) {
            if (n == 29) {
                n = 9;
            }
            BaseHmsClient baseHmsClient = baseHmsClient2;
            BaseHmsClient baseHmsClient2 = HuaweiApiAvailability.getInstance().getErrPendingIntent(baseHmsClient2.mContext, n, 0);
            baseHmsClient.notifyFailed(new ConnectionResult(26, (PendingIntent)baseHmsClient2));
            return;
        }
        Activity activity = Util.getActiveActivity(baseHmsClient2.getClientSettings().getCpActivity(), baseHmsClient2.getContext());
        if (activity != null) {
            availableAdapter.startNotice(activity, new AvailableAdapter.AvailableCallBack(){

                public void onComplete(int n) {
                    BaseHmsClient.this.notifyFailed(n);
                }
            });
        } else {
            baseHmsClient2.notifyFailed(26);
        }
    }

    private void resolution(AvailableAdapter availableAdapter, int n) {
        HMSLog.i((String)TAG, (String)"enter HmsCore resolution");
        if (!baseHmsClient2.getClientSettings().isHasActivity()) {
            BaseHmsClient baseHmsClient = baseHmsClient2;
            BaseHmsClient baseHmsClient2 = HuaweiApiAvailability.getInstance().getErrPendingIntent(baseHmsClient2.mContext, n, 0);
            baseHmsClient.notifyFailed(new ConnectionResult(26, (PendingIntent)baseHmsClient2));
            return;
        }
        Activity activity = Util.getActiveActivity(baseHmsClient2.getClientSettings().getCpActivity(), baseHmsClient2.getContext());
        if (activity != null) {
            availableAdapter.startResolution(activity, new AvailableAdapter.AvailableCallBack(){

                public void onComplete(int n) {
                    if (n == 0) {
                        BaseHmsClient.this.bindCoreService();
                    } else {
                        BaseHmsClient.this.notifyFailed(n);
                    }
                }
            });
        } else {
            baseHmsClient2.notifyFailed(26);
        }
    }

    private void notifyFailed(int n) {
        Message message;
        HMSLog.i((String)TAG, (String)("notifyFailed result: " + n));
        Message message2 = message;
        new Message().what = 10012;
        new Message().obj = new ConnectionResultWrapper(((BaseHmsClient)((Object)onConnectionFailedListener)).internalRequest, new ConnectionResult(n));
        RequestManager.getHandler().sendMessage(message2);
        OnConnectionFailedListener onConnectionFailedListener = ((BaseHmsClient)((Object)onConnectionFailedListener)).mConnectionFailedListener;
        if (onConnectionFailedListener != null && !(onConnectionFailedListener instanceof HuaweiApi.RequestHandler)) {
            onConnectionFailedListener.onConnectionFailed(new ConnectionResult(n));
        }
    }

    private void notifyFailed(ConnectionResult connectionResult) {
        Message message;
        BaseHmsClient baseHmsClient = object;
        HMSLog.i((String)TAG, (String)("notifyFailed result: " + connectionResult.getErrorCode()));
        Message message2 = message;
        message2();
        message2.what = 10012;
        Object object = ((BaseHmsClient)object).internalRequest;
        v2.internalRequest = null;
        message.obj = new ConnectionResultWrapper((HuaweiApi.RequestHandler)object, connectionResult);
        RequestManager.getHandler().sendMessage(message2);
        object = baseHmsClient.mConnectionFailedListener;
        if (object != null && !(object instanceof HuaweiApi.RequestHandler)) {
            object.onConnectionFailed(connectionResult);
        }
    }

    static /* synthetic */ IAIDLInvoke access$102(BaseHmsClient baseHmsClient, IAIDLInvoke iAIDLInvoke) {
        baseHmsClient.mService = iAIDLInvoke;
        return iAIDLInvoke;
    }

    public void onConnecting() {
        this.connectionConnected();
    }

    protected final void connectionConnected() {
        BaseHmsClient baseHmsClient = connectionCallbacks;
        baseHmsClient.setConnectStatus(3);
        RequestManager.getHandler().sendEmptyMessage(10011);
        ConnectionCallbacks connectionCallbacks = baseHmsClient.mConnectionCallbacks;
        if (connectionCallbacks != null && !(connectionCallbacks instanceof HuaweiApi.RequestHandler)) {
            connectionCallbacks.onConnected();
        }
    }

    public String getServiceAction() {
        BaseHmsClient baseHmsClient = baseHmsClient2;
        BaseHmsClient baseHmsClient2 = HMSPackageManager.getInstance((Context)baseHmsClient.mContext);
        return baseHmsClient.mClientSettings.isUseInnerHms() ? baseHmsClient2.getInnerServiceAction() : baseHmsClient2.getServiceAction();
    }

    void bindCoreService() {
        BaseHmsClient baseHmsClient = this;
        String string = baseHmsClient.mClientSettings.getInnerHmsPkg();
        String string2 = this.getServiceAction();
        HMSLog.i((String)TAG, (String)("enter bindCoreService, packageName is " + string + ", serviceAction is " + string2));
        baseHmsClient.bindCoreInternal(string, string2);
    }

    public void connectedInternal(IBinder iBinder) {
        this.mService = IAIDLInvoke.Stub.asInterface(iBinder);
        if (this.mService == null) {
            HMSLog.e((String)TAG, (String)"mService is null, try to unBind.");
            this.tryUnBind();
            return;
        }
        this.onConnecting();
    }

    @Override
    public String getAppID() {
        return this.mAppID;
    }

    @Override
    public boolean isConnected() {
        return this.mClientSettings.isUseInnerHms() ? INNER_CONN_STATUS.get() == 3 : CONN_STATUS.get() == 3;
    }

    public int getConnectionStatus() {
        return this.mClientSettings.isUseInnerHms() ? INNER_CONN_STATUS.get() : CONN_STATUS.get();
    }

    public boolean isConnecting() {
        return (this.mClientSettings.isUseInnerHms() ? INNER_CONN_STATUS.get() : CONN_STATUS.get()) == 5;
    }

    public BinderAdapter getAdapter() {
        HMSLog.i((String)TAG, (String)("getAdapter:isInner:" + this.mClientSettings.isUseInnerHms() + ", mInnerBinderAdapter:" + mInnerBinderAdapter + ", mOuterBinderAdapter:" + mOuterBinderAdapter));
        return this.mClientSettings.isUseInnerHms() ? mInnerBinderAdapter : mOuterBinderAdapter;
    }

    public void disconnect() {
        int n = this.mClientSettings.isUseInnerHms() ? INNER_CONN_STATUS.get() : CONN_STATUS.get();
        HMSLog.i((String)TAG, (String)("Enter disconnect, Connection Status: " + n));
        if (n != 1) {
            if (n != 3) {
                if (n == 5) {
                    BaseHmsClient baseHmsClient = this;
                    baseHmsClient.cancelConnDelayHandle();
                    baseHmsClient.setConnectStatus(1);
                }
            } else {
                BaseHmsClient baseHmsClient = this;
                baseHmsClient.unBindAdapter();
                baseHmsClient.setConnectStatus(1);
            }
        }
    }

    void setConnectStatus(int n) {
        if (this.mClientSettings.isUseInnerHms()) {
            INNER_CONN_STATUS.set(n);
        } else {
            CONN_STATUS.set(n);
        }
    }

    public void connect(int n) {
        this.checkAvailabilityAndConnect(n, false);
    }

    public void connect(int n, boolean bl) {
        this.checkAvailabilityAndConnect(n, bl);
    }

    @Override
    public IAIDLInvoke getService() {
        return this.mService;
    }

    public void setService(IAIDLInvoke iAIDLInvoke) {
        this.mService = iAIDLInvoke;
    }

    protected final void checkConnected() {
        if (this.isConnected()) {
            return;
        }
        throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Deprecated
    public int getMinApkVersion() {
        return 30000000;
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public SubAppInfo getSubAppInfo() {
        return this.mClientSettings.getSubAppID();
    }

    @Override
    public String getPackageName() {
        return this.mClientSettings.getClientPackageName();
    }

    @Override
    public String getCpID() {
        return this.mClientSettings.getCpID();
    }

    @Override
    public String getTransportName() {
        return IPCTransport.class.getName();
    }

    @Override
    public List<String> getApiNameList() {
        return this.mClientSettings.getApiName();
    }

    protected ClientSettings getClientSettings() {
        return this.mClientSettings;
    }

    public final void setInternalRequest(HuaweiApi.RequestHandler requestHandler) {
        this.internalRequest = requestHandler;
    }

    public static final class ConnectionResultWrapper {
        private HuaweiApi.RequestHandler request;
        private ConnectionResult connectionResult;

        public ConnectionResultWrapper(HuaweiApi.RequestHandler requestHandler, ConnectionResult connectionResult) {
            this.request = requestHandler;
            this.connectionResult = connectionResult;
        }

        public HuaweiApi.RequestHandler getRequest() {
            return this.request;
        }

        public ConnectionResult getConnectionResult() {
            return this.connectionResult;
        }
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;
        public static final int CAUSE_API_CLIENT_EXPIRED = 3;

        public void onConnected();

        public void onConnectionSuspended(int var1);
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(ConnectionResult var1);
    }
}

