/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common.internal.safeparcel;

import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public class SafeParcelWriter {
    private static final int BIT16_MARK = 65535;
    private static final int NEGATIVE_MARK = -65536;
    private static final int OFFSET16 = 16;
    private static final int FIELD_ID_CHECKER = 20293;

    private SafeParcelWriter() {
    }

    private static void setHeader(Parcel parcel, int n, int n2) {
        if (n2 >= 65535) {
            parcel.writeInt(n | 0xFFFF0000);
            parcel.writeInt(n2);
            return;
        }
        parcel.writeInt(n2 << 16 | n);
    }

    private static int getStartPosition(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        parcel2.writeInt(n | 0xFFFF0000);
        parcel2.writeInt(0);
        return parcel2.dataPosition();
    }

    private static void handleDataOver(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        int n2 = parcel2.dataPosition();
        int n3 = n2 - n;
        parcel.setDataPosition(n - 4);
        parcel.writeInt(n3);
        parcel2.setDataPosition(n2);
    }

    private static <P extends Parcelable> void setSizeOfData(Parcel parcel, P p, int n) {
        Parcel parcel2 = parcel;
        int n2 = n;
        Parcel parcel3 = parcel;
        int n3 = parcel3.dataPosition();
        parcel3.writeInt(1);
        n = parcel3.dataPosition();
        p.writeToParcel(parcel, n2);
        int n4 = parcel2.dataPosition();
        parcel.setDataPosition(n3);
        parcel.writeInt(n4 - n);
        parcel2.setDataPosition(n4);
    }

    public static int beginObjectHeader(Parcel parcel) {
        return SafeParcelWriter.getStartPosition(parcel, 20293);
    }

    public static void finishObjectHeader(Parcel parcel, int n) {
        SafeParcelWriter.handleDataOver(parcel, n);
    }

    public static void writeBoolean(Parcel parcel, int n, boolean bl) {
        SafeParcelWriter.setHeader(parcel, n, 4);
        if (bl) {
            parcel.writeInt(1);
        } else {
            parcel.writeInt(0);
        }
    }

    public static void writeBooleanObject(Parcel parcel, int n, Boolean bl, boolean bl2) {
        if (bl != null) {
            SafeParcelWriter.setHeader(parcel, n, 4);
            parcel.writeInt(bl.booleanValue() ? 1 : 0);
        } else if (bl2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeByte(Parcel parcel, int n, byte by) {
        SafeParcelWriter.setHeader(parcel, n, 4);
        parcel.writeInt((int)by);
    }

    public static void writeChar(Parcel parcel, int n, char c2) {
        SafeParcelWriter.setHeader(parcel, n, 4);
        parcel.writeInt((int)c2);
    }

    public static void writeShort(Parcel parcel, int n, short s) {
        SafeParcelWriter.setHeader(parcel, n, 4);
        parcel.writeInt((int)s);
    }

    public static void writeInt(Parcel parcel, int n, int n2) {
        SafeParcelWriter.setHeader(parcel, n, 4);
        parcel.writeInt(n2);
    }

    public static void writeIntegerObject(Parcel parcel, int n, Integer n2, boolean bl) {
        if (n2 != null) {
            SafeParcelWriter.setHeader(parcel, n, 4);
            parcel.writeInt(n2.intValue());
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeLong(Parcel parcel, int n, long l) {
        SafeParcelWriter.setHeader(parcel, n, 8);
        parcel.writeLong(l);
    }

    public static void writeLongObject(Parcel parcel, int n, Long l, boolean bl) {
        if (l != null) {
            SafeParcelWriter.setHeader(parcel, n, 8);
            parcel.writeLong(l.longValue());
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeBigInteger(Parcel parcel, int n, BigInteger bigInteger, boolean bl) {
        if (bigInteger != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeByteArray(bigInteger.toByteArray());
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeFloat(Parcel parcel, int n, float f) {
        SafeParcelWriter.setHeader(parcel, n, 4);
        parcel.writeFloat(f);
    }

    public static void writeFloatObject(Parcel parcel, int n, Float f, boolean bl) {
        if (f != null) {
            SafeParcelWriter.setHeader(parcel, n, 4);
            parcel.writeFloat(f.floatValue());
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeDouble(Parcel parcel, int n, double d2) {
        SafeParcelWriter.setHeader(parcel, n, 8);
        parcel.writeDouble(d2);
    }

    public static void writeDoubleObject(Parcel parcel, int n, Double d2, boolean bl) {
        if (d2 != null) {
            SafeParcelWriter.setHeader(parcel, n, 8);
            parcel.writeDouble(d2.doubleValue());
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeBigDecimal(Parcel parcel, int n, BigDecimal bigDecimal, boolean bl) {
        if (bigDecimal != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeByteArray(bigDecimal.unscaledValue().toByteArray());
            parcel.writeInt(bigDecimal.scale());
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeString(Parcel parcel, int n, String string, boolean bl) {
        if (string != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeString(string);
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeIBinder(Parcel parcel, int n, IBinder iBinder, boolean bl) {
        if (iBinder != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeStrongBinder(iBinder);
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeParcelable(Parcel parcel, int n, Parcelable parcelable, int n2, boolean bl) {
        if (parcelable != null) {
            Parcel parcel2 = parcel;
            int n3 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcelable.writeToParcel(parcel, n2);
            SafeParcelWriter.handleDataOver(parcel2, n3);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeBundle(Parcel parcel, int n, Bundle bundle, boolean bl) {
        if (bundle != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeBundle(bundle);
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeByteArray(Parcel parcel, int n, byte[] byArray, boolean bl) {
        if (byArray != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeByteArray(byArray);
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeByteArrayArray(Parcel parcel, int n, byte[][] byArray, boolean n2) {
        if (byArray != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = byArray.length;
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeByteArray(byArray[i]);
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeBooleanArray(Parcel parcel, int n, boolean[] blArray, boolean bl) {
        if (blArray != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeBooleanArray(blArray);
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeCharArray(Parcel parcel, int n, char[] cArray, boolean bl) {
        if (cArray != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeCharArray(cArray);
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeIntArray(Parcel parcel, int n, int[] nArray, boolean bl) {
        if (nArray != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeIntArray(nArray);
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeLongArray(Parcel parcel, int n, long[] lArray, boolean bl) {
        if (lArray != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeLongArray(lArray);
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeBigIntegerArray(Parcel parcel, int n, BigInteger[] bigIntegerArray, boolean n2) {
        if (bigIntegerArray != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = bigIntegerArray.length;
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeByteArray(bigIntegerArray[i].toByteArray());
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeFloatArray(Parcel parcel, int n, float[] fArray, boolean bl) {
        if (fArray != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeFloatArray(fArray);
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeDoubleArray(Parcel parcel, int n, double[] dArray, boolean bl) {
        if (dArray != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeDoubleArray(dArray);
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeBigDecimalArray(Parcel parcel, int n, BigDecimal[] bigDecimalArray, boolean n2) {
        if (bigDecimalArray != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = bigDecimalArray.length;
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeByteArray(bigDecimalArray[i].unscaledValue().toByteArray());
                parcel.writeInt(bigDecimalArray[i].scale());
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeStringArray(Parcel parcel, int n, String[] stringArray, boolean bl) {
        if (stringArray != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeStringArray(stringArray);
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeIBinderArray(Parcel parcel, int n, IBinder[] iBinderArray, boolean bl) {
        if (iBinderArray != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeBinderArray(iBinderArray);
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeBooleanList(Parcel parcel, int n, List<Boolean> list, boolean n2) {
        if (list != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = list.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeInt(list.get(i).booleanValue() ? 1 : 0);
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeIntegerList(Parcel parcel, int n, List<Integer> list, boolean n2) {
        if (list != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = list.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeInt(list.get(i).intValue());
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeLongList(Parcel parcel, int n, List<Long> list, boolean n2) {
        if (list != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = list.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeLong(list.get(i).longValue());
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeFloatList(Parcel parcel, int n, List<Float> list, boolean n2) {
        if (list != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = list.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeFloat(list.get(i).floatValue());
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeDoubleList(Parcel parcel, int n, List<Double> list, boolean n2) {
        if (list != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = list.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeDouble(list.get(i).doubleValue());
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeStringList(Parcel parcel, int n, List<String> list, boolean bl) {
        if (list != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeStringList(list);
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeIBinderList(Parcel parcel, int n, List<IBinder> list, boolean bl) {
        if (list != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeBinderList(list);
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static <P extends Parcelable> void writeTypedArray(Parcel parcel, int n, P[] PArray, int n2, boolean n3) {
        if (PArray != null) {
            Parcel parcel2 = parcel;
            n = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel2.writeInt(n);
            n3 = PArray.length;
            for (int i = 0; i < n3; ++i) {
                if (PArray[i] != null) {
                    SafeParcelWriter.setSizeOfData(parcel, PArray[i], n2);
                    continue;
                }
                parcel.writeInt(0);
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n3) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static <T extends Parcelable> void writeTypedList(Parcel parcel, int n, List<T> list, boolean n2) {
        if (list != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = list.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                Parcelable parcelable = (Parcelable)list.get(i);
                if (parcelable != null) {
                    SafeParcelWriter.setSizeOfData(parcel, parcelable, 0);
                    continue;
                }
                parcel.writeInt(0);
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeParcel(Parcel parcel, int n, Parcel parcel2, boolean bl) {
        if (parcel2 != null) {
            Parcel parcel3 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel3, n);
            Parcel parcel4 = parcel2;
            parcel.appendFrom(parcel4, 0, parcel4.dataSize());
            SafeParcelWriter.handleDataOver(parcel3, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeParcelArray(Parcel parcel, int n, Parcel[] parcelArray, boolean n2) {
        if (parcelArray != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = parcelArray.length;
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                if (parcelArray[i] == null) {
                    parcel.writeInt(0);
                    continue;
                }
                parcel.writeInt(parcelArray[i].dataSize());
                parcel.appendFrom(parcelArray[i], 0, parcelArray[i].dataSize());
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeParcelList(Parcel parcel, int n, List<Parcel> list, boolean n2) {
        if (list != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = list.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                Parcel parcel2 = list.get(i);
                if (parcel2 == null) {
                    parcel.writeInt(0);
                    continue;
                }
                Parcel parcel3 = parcel2;
                parcel.writeInt(parcel2.dataSize());
                parcel.appendFrom(parcel3, 0, parcel3.dataSize());
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeList(Parcel parcel, int n, List list, boolean bl) {
        if (list != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeList(list);
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeSparseBooleanArray(Parcel parcel, int n, SparseBooleanArray sparseBooleanArray, boolean bl) {
        if (sparseBooleanArray != null) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.getStartPosition(parcel2, n);
            parcel.writeSparseBooleanArray(sparseBooleanArray);
            SafeParcelWriter.handleDataOver(parcel2, n2);
        } else if (bl) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeDoubleSparseArray(Parcel parcel, int n, SparseArray<Double> sparseArray, boolean n2) {
        if (sparseArray != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = sparseArray.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeInt(sparseArray.keyAt(i));
                parcel.writeDouble(((Double)sparseArray.valueAt(i)).doubleValue());
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeFloatSparseArray(Parcel parcel, int n, SparseArray<Float> sparseArray, boolean n2) {
        if (sparseArray != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = sparseArray.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeInt(sparseArray.keyAt(i));
                parcel.writeFloat(((Float)sparseArray.valueAt(i)).floatValue());
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeSparseIntArray(Parcel parcel, int n, SparseIntArray sparseIntArray, boolean n2) {
        if (sparseIntArray != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = sparseIntArray.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeInt(sparseIntArray.keyAt(i));
                parcel.writeInt(sparseIntArray.valueAt(i));
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeSparseLongArray(Parcel parcel, int n, SparseLongArray sparseLongArray, boolean n2) {
        int n3 = 0;
        if (sparseLongArray != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = 0;
            if (Build.VERSION.SDK_INT >= 18) {
                n2 = sparseLongArray.size();
            }
            parcel.writeInt(n2);
            while (n3 < n2) {
                if (Build.VERSION.SDK_INT >= 18) {
                    parcel.writeInt(sparseLongArray.keyAt(n3));
                }
                if (Build.VERSION.SDK_INT >= 18) {
                    parcel.writeLong(sparseLongArray.valueAt(n3));
                }
                ++n3;
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeStringSparseArray(Parcel parcel, int n, SparseArray<String> sparseArray, boolean n2) {
        if (sparseArray != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = sparseArray.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeInt(sparseArray.keyAt(i));
                parcel.writeString((String)sparseArray.valueAt(i));
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeParcelSparseArray(Parcel parcel, int n, SparseArray<Parcel> sparseArray, boolean n2) {
        if (sparseArray != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = sparseArray.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeInt(sparseArray.keyAt(i));
                Parcel parcel2 = (Parcel)sparseArray.valueAt(i);
                if (parcel2 == null) {
                    parcel.writeInt(0);
                    continue;
                }
                Parcel parcel3 = parcel2;
                parcel.writeInt(parcel2.dataSize());
                parcel.appendFrom(parcel3, 0, parcel3.dataSize());
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static <T extends Parcelable> void writeTypedSparseArray(Parcel parcel, int n, SparseArray<T> sparseArray, boolean n2) {
        if (sparseArray != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = sparseArray.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeInt(sparseArray.keyAt(i));
                Parcelable parcelable = (Parcelable)sparseArray.valueAt(i);
                if (parcelable != null) {
                    SafeParcelWriter.setSizeOfData(parcel, parcelable, 0);
                    continue;
                }
                parcel.writeInt(0);
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeIBinderSparseArray(Parcel parcel, int n, SparseArray<IBinder> sparseArray, boolean n2) {
        if (sparseArray != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = sparseArray.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeInt(sparseArray.keyAt(i));
                parcel.writeStrongBinder((IBinder)sparseArray.valueAt(i));
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }

    public static void writeByteArraySparseArray(Parcel parcel, int n, SparseArray<byte[]> sparseArray, boolean n2) {
        if (sparseArray != null) {
            n = SafeParcelWriter.getStartPosition(parcel, n);
            n2 = sparseArray.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeInt(sparseArray.keyAt(i));
                parcel.writeByteArray((byte[])sparseArray.valueAt(i));
            }
            SafeParcelWriter.handleDataOver(parcel, n);
        } else if (n2) {
            SafeParcelWriter.setHeader(parcel, n, 0);
        }
    }
}

