/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.android;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.text.TextUtils;
import com.huawei.hms.android.HwBuildEx;
import com.huawei.hms.support.log.HMSLog;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;

public class SystemUtils {
    public static boolean isChinaROM() {
        String string = SystemUtils.b();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return "cn".equalsIgnoreCase(string);
        }
        string = SystemUtils.a();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string.toLowerCase(Locale.US).contains("cn");
        }
        string = SystemUtils.getLocalCountry();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return "cn".equalsIgnoreCase(string);
        }
        return false;
    }

    public static String b() {
        return SystemUtils.getSystemProperties("ro.product.locale.region", "");
    }

    public static String a() {
        return SystemUtils.getSystemProperties("ro.product.locale", "");
    }

    public static String getLocalCountry() {
        String string = "";
        Locale locale = Locale.getDefault();
        if (locale != null) {
            string = locale.getCountry();
        }
        return string;
    }

    public static String getSystemProperties(String string, String string2) {
        Class<?> clazz = Class.forName("android.os.SystemProperties");
        Class[] classArray = new Class[2];
        classArray[0] = String.class;
        try {
            classArray[1] = String.class;
            return (String)clazz.getDeclaredMethod("get", classArray).invoke(clazz, string, string2);
        }
        catch (ClassCastException classCastException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        HMSLog.e((String)"SystemUtils", (String)("An exception occurred while reading: getSystemProperties:" + string));
        return string2;
    }

    public static String getNetType(Context context) {
        String string = "";
        if (context != null && (context = (ConnectivityManager)context.getSystemService("connectivity")) != null && (context = context.getActiveNetworkInfo()) != null && context.isAvailable()) {
            string = context.getTypeName();
        }
        return string;
    }

    public static boolean isEMUI() {
        HMSLog.i((String)"SystemUtils", (String)("is Emui :" + HwBuildEx.VERSION.EMUI_SDK_INT));
        return HwBuildEx.VERSION.EMUI_SDK_INT > 0;
    }

    public static boolean isSystemApp(Context context, String string) {
        Context context2 = context;
        context = null;
        try {
            context = context2.getPackageManager().getPackageInfo(string, 16384);
        }
        catch (RuntimeException runtimeException) {
            HMSLog.e((String)"SystemUtils", (String)("isSystemApp RuntimeException:" + runtimeException));
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            HMSLog.e((String)"SystemUtils", (String)("isSystemApp Exception: " + (Object)((Object)nameNotFoundException)));
        }
        return context != null && (context.applicationInfo.flags & 1) > 0;
    }

    public static boolean isTVDevice() {
        return SystemUtils.getSystemProperties("ro.build.characteristics", "default").equalsIgnoreCase("tv");
    }
}

