/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations.remote;

import androidx.annotation.GuardedBy;
import com.google.firebase.installations.Utils;
import java.util.concurrent.TimeUnit;

class RequestLimiter {
    private static final long MAXIMUM_BACKOFF_DURATION_FOR_CONFIGURATION_ERRORS = TimeUnit.HOURS.toMillis(24L);
    private static final long MAXIMUM_BACKOFF_DURATION_FOR_SERVER_ERRORS = TimeUnit.MINUTES.toMillis(30L);
    private final Utils utils;
    @GuardedBy(value="this")
    private long nextRequestTime;
    @GuardedBy(value="this")
    private int attemptCount;

    RequestLimiter(Utils utils) {
        this.utils = utils;
    }

    RequestLimiter() {
        this.utils = Utils.getInstance();
    }

    public synchronized void setNextRequestTime(int responseCode) {
        if (RequestLimiter.isSuccessfulOrRequiresNewFidCreation(responseCode)) {
            this.resetBackoffStrategy();
            return;
        }
        ++this.attemptCount;
        long backOffTime = this.getBackoffDuration(responseCode);
        this.nextRequestTime = this.utils.currentTimeInMillis() + backOffTime;
    }

    private synchronized void resetBackoffStrategy() {
        this.attemptCount = 0;
    }

    private synchronized long getBackoffDuration(int responseCode) {
        if (!RequestLimiter.isRetryableError(responseCode)) {
            return MAXIMUM_BACKOFF_DURATION_FOR_CONFIGURATION_ERRORS;
        }
        return (long)Math.min(Math.pow(2.0, this.attemptCount) + (double)this.utils.getRandomDelayForSyncPrevention(), (double)MAXIMUM_BACKOFF_DURATION_FOR_SERVER_ERRORS);
    }

    private static boolean isRetryableError(int responseCode) {
        return responseCode == 429 || responseCode >= 500 && responseCode < 600;
    }

    private static boolean isSuccessfulOrRequiresNewFidCreation(int responseCode) {
        return responseCode >= 200 && responseCode < 300 || responseCode == 401 || responseCode == 404;
    }

    public synchronized boolean isRequestAllowed() {
        return this.attemptCount == 0 || this.utils.currentTimeInMillis() > this.nextRequestTime;
    }
}

