/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.common.utils;

import android.content.Context;
import android.text.TextUtils;
import com.engagelab.privates.common.global.MTGlobal;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.common.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public class FileUtils {
    private static final String TAG = "FileUtils";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object readObject(File file) throws Exception {
        Throwable throwable2;
        ObjectInputStream objectInputStream;
        block6: {
            Object object;
            ObjectInputStream objectInputStream2;
            File file2;
            if (file == null) return null;
            if (!file2.exists()) return null;
            if (file2.isDirectory()) {
                return null;
            }
            ObjectInputStream objectInputStream3 = null;
            objectInputStream = objectInputStream2;
            try {
                objectInputStream2 = new ObjectInputStream(new FileInputStream(file2));
            }
            catch (Throwable throwable2) {
                objectInputStream = objectInputStream3;
                break block6;
            }
            try {
                object = objectInputStream2.readObject();
            }
            catch (Throwable throwable2) {
                break block6;
            }
            Utils.closeQuietly(objectInputStream);
            return object;
        }
        Utils.closeQuietly(objectInputStream);
        throw throwable2;
    }

    public static String read2Str(File file) {
        byte[] byArray = FileUtils.read2Bytes(file);
        Object object = byArray;
        if (byArray == null) {
            return null;
        }
        try {
            return new String((byte[])object, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MTCommonLog.d(TAG, "can't encoding, give up read :" + unsupportedEncodingException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] read2Bytes(File file) {
        FileInputStream fileInputStream;
        block6: {
            byte[] byArray;
            FileInputStream fileInputStream2;
            File file2;
            if (file == null) return null;
            if (!file2.exists()) return null;
            if (file2.isDirectory()) {
                return null;
            }
            Object var1_1 = null;
            fileInputStream = fileInputStream2;
            try {
                fileInputStream2 = new FileInputStream(file2);
            }
            catch (Throwable throwable) {
                fileInputStream = var1_1;
                break block6;
            }
            try {
                byArray = Utils.readAvailable(fileInputStream2);
            }
            catch (Throwable throwable) {
                break block6;
            }
            Utils.closeQuietly(fileInputStream);
            return byArray;
        }
        Utils.closeQuietly(fileInputStream);
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveObject(File file, Object object) {
        File file2;
        if (file != null && !file2.isDirectory()) {
            ObjectOutputStream objectOutputStream;
            block8: {
                void v1;
                ObjectOutputStream objectOutputStream2;
                ObjectOutputStream objectOutputStream3 = null;
                try {
                    FileUtils.createFileIfNeed(file2);
                }
                catch (Throwable throwable) {
                    objectOutputStream = objectOutputStream3;
                    break block8;
                }
                objectOutputStream = objectOutputStream2;
                {
                    void var1_1;
                    v1 = var1_1;
                    objectOutputStream(new FileOutputStream(file2));
                }
                try {
                    objectOutputStream2.writeObject(v1);
                }
                catch (Throwable throwable) {
                    break block8;
                }
                Utils.closeQuietly(objectOutputStream2);
                return true;
            }
            try {
                void var1_4;
                MTCommonLog.w(TAG, "save to file exception:" + var1_4 + " path = " + file2.getAbsolutePath());
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(objectOutputStream);
                throw throwable;
            }
            Utils.closeQuietly(objectOutputStream);
            return false;
        }
        MTCommonLog.w(TAG, "file should not be null or a directory");
        return false;
    }

    public static void createFileIfNeed(File file) {
        File file2;
        if (file != null && !file2.exists()) {
            File file3 = file2.getParentFile();
            if (file3 != null && !file3.exists()) {
                file3.mkdirs();
            }
            try {
                file2.createNewFile();
            }
            catch (Throwable throwable) {}
        }
    }

    public static boolean isFileExist(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        try {
            String string;
            return new File(string).exists();
        }
        catch (Throwable throwable) {
            MTCommonLog.w(TAG, "FileUtils e:" + throwable);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static File inFiles(Context context, String path, String file) {
        void var2_2;
        Object object;
        if (context != null && (object = object.getFilesDir()) != null) {
            void var1_1;
            return new File(((File)object).getAbsolutePath() + File.separator + (String)var1_1, (String)var2_2);
        }
        MTCommonLog.w(TAG, "can't get file :" + (String)var2_2);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static File getAppKeyDir(Context context, String path, String name) {
        void var2_2;
        void var1_1;
        Object object;
        StringBuilder stringBuilder = new StringBuilder().append(MTGlobal.getAppKey((Context)object));
        object = File.separator;
        if ((object = FileUtils.inFiles(context, stringBuilder.append((String)object).append((String)var1_1).append((String)object).append((String)var2_2).toString(), "cache")) == null) {
            MTCommonLog.w(TAG, (String)var2_2 + " can't be null");
            return null;
        }
        if (!((File)(object = ((File)object).getParentFile())).exists()) {
            ((File)object).mkdirs();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static File getAppKeyFile(Context context, String path, String name) {
        void var2_2;
        void var1_1;
        Context context2;
        return FileUtils.inFiles(context, MTGlobal.getAppKey(context2) + File.separator + (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static File getAppKeyFile(Context context, String name) {
        void var1_1;
        Context context2 = context;
        return FileUtils.inFiles(context2, MTGlobal.getAppKey(context2), (String)var1_1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean save(String path, String data) {
        Exception exception2;
        String string;
        byte[] byArray;
        if (data != null) {
            try {
                byArray = byArray.getBytes("UTF-8");
                return FileUtils.save(string, byArray);
            }
            catch (Exception exception2) {}
        } else {
            byArray = null;
            return FileUtils.save(string, byArray);
        }
        MTCommonLog.w(TAG, "getBytes exception:" + exception2);
        return false;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean save(String path, byte[] data) {
        Throwable throwable2;
        FileOutputStream fileOutputStream;
        block12: {
            String string;
            block11: {
                FileOutputStream fileOutputStream2;
                File file;
                byte[] byArray;
                if (TextUtils.isEmpty((CharSequence)path)) {
                    return false;
                }
                if (byArray == null) {
                    byArray = new byte[]{};
                }
                FileOutputStream fileOutputStream3 = null;
                File file2 = file;
                FileUtils.createFileIfNeed(new File(string));
                fileOutputStream = fileOutputStream2;
                byte[] byArray2 = byArray;
                fileOutputStream(file2);
                try {
                    fileOutputStream2.write(byArray2);
                }
                catch (Exception exception) {
                    break block11;
                }
                Utils.closeQuietly(fileOutputStream2);
                return true;
                catch (Throwable throwable2) {
                    fileOutputStream = fileOutputStream3;
                    break block12;
                }
                catch (Exception exception) {
                    fileOutputStream = fileOutputStream3;
                }
            }
            try {
                void var1_4;
                MTCommonLog.w(TAG, "save to file exception:" + var1_4 + " path = " + string);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            Utils.closeQuietly(fileOutputStream);
            return false;
        }
        Utils.closeQuietly(fileOutputStream);
        throw throwable2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean createHtmlFile(String filePath, String content) {
        void var1_1;
        String string;
        MTCommonLog.d(TAG, "action:createHtmlFile - filePath:" + string + ", content:" + (String)var1_1);
        if (!TextUtils.isEmpty((CharSequence)content)) {
            return FileUtils.save(string, (String)var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean createImgFile(String filePath, byte[] buffer) {
        void var1_1;
        if (buffer != null && ((void)var1_1).length > 0) {
            String string;
            return FileUtils.save(string, (byte[])var1_1);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean deleteDirectory(File dir) {
        block14: {
            block13: {
                if (dir.exists()) break block13;
                return false;
            }
            if (!var0.isFile()) ** GOTO lbl9
            return var0.delete();
lbl9:
            // 1 sources

            var1_1 = var0.list();
            if (var1_1 == null) break block14;
            var2_2 = var1_1.length;
            block11: for (var3_3 = 0; var3_3 < var2_2; ++var3_3) {
                block15: {
                    var4_4 = var1_1[var3_3];
                    var5_5 = v0;
                    if (!new File(var0, var4_4).isDirectory()) break block15;
                    v1 = FileUtils.deleteDirectory(var5_5);
lbl21:
                    // 2 sources

                    continue block11;
                }
                v1 = var5_5.delete();
                ** continue;
            }
        }
        try {
            return var0.delete();
        }
        catch (Exception v2) {
            MTCommonLog.e("FileUtils", "Delete dir error");
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void deleteCacheFileMaximum(String cacheParentPath, int maximum) {
        block20: {
            block18: {
                int n2;
                void var1_1;
                Object object;
                block19: {
                    File file;
                    block17: {
                        block16: {
                            File file2;
                            block15: {
                                if (!TextUtils.isEmpty((CharSequence)cacheParentPath)) break block15;
                                return;
                            }
                            file = file2;
                            if (new File((String)object).exists()) break block16;
                            return;
                        }
                        if (!file.isFile()) break block17;
                        return;
                    }
                    object = file.listFiles();
                    if (object == null) break block18;
                    if (((File[])object).length == 0) break block18;
                    MTCommonLog.d(TAG, "cacheFiles.length " + ((File[])object).length);
                    if (((File[])object).length > var1_1) break block19;
                    return;
                }
                object = Arrays.asList(object);
                try {
                    Collections.sort(object, new Comparator<File>(){

                        public int a(File file, File file2) {
                            long l2 = file.lastModified() - file2.lastModified() - 0L;
                            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                            if (l3 < 0) {
                                return -1;
                            }
                            if (l3 > 0) {
                                return 1;
                            }
                            return 0;
                        }
                    });
                    n2 = 0;
                }
                catch (Throwable throwable) {}
                while (true) {
                    block21: {
                        if (n2 >= object.size() - var1_1) break block20;
                        File file = (File)object.get(n2);
                        if (!file.exists()) break block21;
                        MTCommonLog.d(TAG, "Delete cacheFile " + file.getAbsolutePath());
                        FileUtils.deleteDirectory(file);
                    }
                    ++n2;
                }
            }
            return;
        }
    }

    public static String change(String str) {
        String string;
        block8: {
            if (!TextUtils.isEmpty((CharSequence)str)) break block8;
            return string;
        }
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (true) {
            if (n2 >= cArray.length) break;
            char[] cArray2 = cArray;
            int n3 = n2;
            char c2 = cArray[n2];
            cArray2[n3] = (char)(c2 ^ 0x7D0);
            ++n2;
            continue;
            break;
        }
        try {
            return new String(cArray);
        }
        catch (Throwable throwable) {
            return string;
        }
    }
}

