/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.utils;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.push.api.NotificationMessage;
import com.engagelab.privates.push.utils.NotificationUtil;

public class NotificationChannelUtil {
    private static final String TAG = "NotificationChannelUtil";
    private static final String CHANNEL_LOW = "ENGAGELAB_PRIVATES_CHANNEL_low";
    private static final String CHANNEL_DEFAULT = "ENGAGELAB_PRIVATES_CHANNEL_normal";
    private static final String CHANNEL_HIGH = "ENGAGELAB_PRIVATES_CHANNEL_high";
    private static final String CHANNEL_SILENCE = "ENGAGELAB_PRIVATES_CHANNEL_silence";

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getChannel(Context context, boolean isNotificationSilenceTime, NotificationMessage notificationMessage) {
        int n2;
        NotificationChannel notificationChannel;
        int n3;
        Object object;
        NotificationManager notificationManager;
        String string;
        boolean bl;
        block8: {
            Throwable throwable2;
            block7: {
                NotificationChannel notificationChannel2;
                void var2_4;
                Context context2;
                if (Build.VERSION.SDK_INT < 26) {
                    return null;
                }
                Context context3 = context2;
                string = NotificationChannelUtil.getChannelId(context3, bl, (NotificationMessage)var2_4);
                notificationManager = (NotificationManager)context3.getSystemService("notification");
                object = notificationManager.getNotificationChannel(string);
                n3 = NotificationChannelUtil.getChannelImportance(context2, bl, (NotificationMessage)var2_4);
                if (object != null) {
                    if (-1 != var2_4.getImportance()) {
                        object.setImportance(n3);
                        MTCommonLog.d(TAG, "has channelId:" + string + " and set channelImportance:" + n3);
                    }
                    MTCommonLog.d(TAG, "has channelId:" + string);
                    return string;
                }
                object = NotificationChannelUtil.getChannelName(context2, bl, (NotificationMessage)var2_4);
                notificationChannel = notificationChannel2;
                notificationChannel2 = new NotificationChannel(string, (CharSequence)object, n3);
                Uri uri = NotificationUtil.getSoundUri(context2, bl, (NotificationMessage)var2_4);
                n2 = NotificationUtil.getDefaults(context2, bl, (NotificationMessage)var2_4);
                notificationChannel.setLockscreenVisibility(NotificationUtil.getVisibility(context2, bl, (NotificationMessage)var2_4));
                if (uri != null) {
                    try {
                        notificationChannel.setSound(uri, null);
                    }
                    catch (Throwable throwable2) {
                        break block7;
                    }
                }
                if (!((n2 & 1) != 0)) {
                    notificationChannel.setSound(null, null);
                }
                break block8;
            }
            MTCommonLog.w(TAG, "setSound fail:" + throwable2);
        }
        bl = (n2 & 4) != 0;
        notificationChannel.enableLights(bl);
        n2 = (n2 & 2) != 0 ? 1 : 0;
        NotificationChannel notificationChannel3 = notificationChannel;
        notificationChannel3.enableVibration(n2 != 0);
        notificationManager.createNotificationChannel(notificationChannel3);
        MTCommonLog.d(TAG, "build channel channelId:" + string + ", channelName:" + (String)object + ", channelImportance:" + n3);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static String getChannelId(Context context, boolean isNotificationSilenceTime, NotificationMessage notificationMessage) {
        void var2_2;
        if (isNotificationSilenceTime) {
            return "N_ENGAGELAB_PRIVATES_CHANNEL_silence_" + var2_2.getPriority();
        }
        if (!TextUtils.isEmpty((CharSequence)var2_2.getChannelId())) {
            return var2_2.getChannelId();
        }
        switch (var2_2.getPriority()) {
            default: {
                if (!TextUtils.isEmpty((CharSequence)var2_2.getSound())) break;
                return "N_ENGAGELAB_PRIVATES_CHANNEL_normal_" + var2_2.getPriority() + "_" + var2_2.getDefaults();
            }
            case 1: 
            case 2: {
                if (TextUtils.isEmpty((CharSequence)var2_2.getSound())) {
                    return "N_ENGAGELAB_PRIVATES_CHANNEL_high_" + var2_2.getPriority() + "_" + var2_2.getDefaults();
                }
                return "N_ENGAGELAB_PRIVATES_CHANNEL_high_" + var2_2.getPriority() + "_" + var2_2.getDefaults() + "_" + var2_2.getSound();
            }
            case -2: 
            case -1: {
                return "N_ENGAGELAB_PRIVATES_CHANNEL_low_" + var2_2.getPriority();
            }
        }
        return "N_ENGAGELAB_PRIVATES_CHANNEL_normal_" + var2_2.getPriority() + "_" + var2_2.getDefaults() + "_" + var2_2.getSound();
    }

    /*
     * WARNING - void declaration
     */
    private static String getChannelName(Context context, boolean isNotificationSilenceTime, NotificationMessage notificationMessage) {
        String string;
        void var2_6;
        Context context2;
        if (isNotificationSilenceTime) {
            String string2 = context2.getPackageName();
            int n2 = context2.getResources().getIdentifier(CHANNEL_SILENCE, "string", string2);
            if (n2 > 0) {
                return context2.getString(n2);
            }
            return "SILENCE";
        }
        switch (var2_6.getPriority()) {
            default: {
                string = CHANNEL_DEFAULT;
                break;
            }
            case 1: 
            case 2: {
                string = CHANNEL_HIGH;
                break;
            }
            case -2: 
            case -1: {
                string = CHANNEL_LOW;
            }
        }
        int n3 = context2.getResources().getIdentifier(string, "string", context2.getPackageName());
        if (n3 > 0) {
            return context2.getString(n3);
        }
        return "NORMAL";
    }

    /*
     * WARNING - void declaration
     */
    private static int getChannelImportance(Context context, boolean isNotificationSilenceTime, NotificationMessage notificationMessage) {
        void var2_2;
        if (isNotificationSilenceTime) {
            if (var2_2.getPriority() != -2) {
                return 2;
            }
            return 1;
        }
        return NotificationChannelUtil.getImportance(var2_2.getPriority());
    }

    private static int getImportance(int priority) {
        switch (priority) {
            default: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 1: {
                return 4;
            }
            case -1: {
                return 2;
            }
            case -2: 
        }
        return 1;
    }
}

