/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.platform.google.business;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.engagelab.privates.common.api.MTCommonPrivatesApi;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.push.api.MTPushPrivatesApi;
import com.engagelab.privates.push.api.PlatformTokenMessage;
import com.engagelab.privates.push.platform.google.callback.MTGoogleListener;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.firebase.messaging.FirebaseMessaging;

public class MTGoogleBusiness {
    private static final String TAG = "MTGoogleBusiness";
    private static volatile MTGoogleBusiness instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MTGoogleBusiness getInstance() {
        if (instance != null) return instance;
        Class<MTGoogleBusiness> clazz = MTGoogleBusiness.class;
        synchronized (MTGoogleBusiness.class) {
            instance = new MTGoogleBusiness();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Context context) {
        try {
            int code = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context);
            if (code != 0) {
                MTCommonLog.e((String)TAG, (String)("not support google push, code:" + code));
                this.onNode(context, 3002, code, 3900, 1);
                return;
            }
            MTCommonLog.d((String)TAG, (String)"support google push");
            FirebaseMessaging.getInstance().getToken().addOnCompleteListener((OnCompleteListener)new MTGoogleListener(context));
        }
        catch (Throwable throwable) {
            MTCommonLog.e((String)TAG, (String)("init failed " + throwable.getMessage()));
        }
    }

    public void onToken(Context context, String token, int from) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            MTCommonLog.d((String)TAG, (String)"onToken:token is empty");
            return;
        }
        PlatformTokenMessage platformTokenMessage = new PlatformTokenMessage().setPlatform((byte)8).setToken(token);
        Bundle bundle = new Bundle();
        bundle.putParcelable("message", (Parcelable)platformTokenMessage);
        MTPushPrivatesApi.init((Context)context);
        MTCommonPrivatesApi.sendMessageToMainProcess((Context)context, (int)3021, (Bundle)bundle);
        this.onNode(context, 3008, 0, 3901, from);
    }

    public void onNode(Context context, int code, int mCode, int type, int from) {
        Bundle bundle = new Bundle();
        bundle.putByte("platform", (byte)8);
        bundle.putInt("code", code);
        bundle.putInt("mCode", mCode);
        bundle.putInt("type", type);
        bundle.putInt("from", from);
        MTCommonPrivatesApi.sendMessageToMainProcess((Context)context, (int)3022, (Bundle)bundle);
    }
}

