/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.platform.huawei.business;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.engagelab.privates.common.api.MTCommonPrivatesApi;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.push.api.MTPushPrivatesApi;
import com.engagelab.privates.push.api.PlatformTokenMessage;
import com.huawei.agconnect.AGConnectInstance;
import com.huawei.hms.aaid.HmsInstanceId;
import com.huawei.hms.api.HuaweiApiAvailability;
import com.huawei.hms.push.HmsMessaging;

public class MTHuaweiBusiness {
    private static final String TAG = "MTHuaweiBusiness";
    private boolean isSupport;
    private static volatile MTHuaweiBusiness instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MTHuaweiBusiness getInstance() {
        if (instance != null) return instance;
        Class<MTHuaweiBusiness> clazz = MTHuaweiBusiness.class;
        synchronized (MTHuaweiBusiness.class) {
            instance = new MTHuaweiBusiness();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Context context) {
        try {
            int code = HuaweiApiAvailability.getInstance().isHuaweiMobileServicesAvailable(context);
            if (code != 0) {
                this.isSupport = false;
                MTCommonLog.e((String)TAG, (String)("not support huawei push, code:" + code));
                this.onNode(context, 3002, code, 3900, 1);
                return;
            }
            this.isSupport = true;
            MTCommonLog.d((String)TAG, (String)"support huawei push");
            String appId = AGConnectInstance.getInstance().getOptions().getString("client/app_id");
            String token = HmsInstanceId.getInstance((Context)context).getToken(appId, "HCM");
            if (TextUtils.isEmpty((CharSequence)token)) {
                MTCommonLog.d((String)TAG, (String)"onTokenFailed:get token is empty");
                this.onNode(context, 3003, 0, 3900, 1);
                return;
            }
            MTCommonLog.d((String)TAG, (String)("onTokenSuccess:get token is " + token));
            this.onToken(context, token, 1);
        }
        catch (Throwable throwable) {
            this.isSupport = false;
            MTCommonLog.e((String)TAG, (String)("init failed " + throwable.getMessage()));
        }
    }

    public void onToken(Context context, String token, int from) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            MTCommonLog.d((String)TAG, (String)"onToken:token is empty");
            return;
        }
        PlatformTokenMessage platformTokenMessage = new PlatformTokenMessage().setPlatform((byte)2).setToken(token);
        Bundle bundle = new Bundle();
        bundle.putParcelable("message", (Parcelable)platformTokenMessage);
        MTPushPrivatesApi.init((Context)context);
        MTCommonPrivatesApi.sendMessageToMainProcess((Context)context.getApplicationContext(), (int)3021, (Bundle)bundle);
        this.onNode(context, 3008, 0, 3901, from);
    }

    public void onNode(Context context, int code, int mCode, int type, int from) {
        Bundle bundle = new Bundle();
        bundle.putByte("platform", (byte)2);
        bundle.putInt("code", code);
        bundle.putInt("mCode", mCode);
        bundle.putInt("type", type);
        bundle.putInt("from", from);
        MTCommonPrivatesApi.sendMessageToMainProcess((Context)context, (int)3022, (Bundle)bundle);
    }

    public void turnOnPush(Context context) {
        try {
            if (!this.isSupport) {
                return;
            }
            HmsMessaging.getInstance((Context)context).turnOnPush();
            this.onNode(context, 3101, 0, 3902, 0);
        }
        catch (Throwable throwable) {
            MTCommonLog.w((String)TAG, (String)("turnOnPush failed " + throwable.getMessage()));
        }
    }

    public void turnOffPush(Context context) {
        try {
            if (!this.isSupport) {
                return;
            }
            HmsMessaging.getInstance((Context)context).turnOffPush();
            this.onNode(context, 3102, 0, 3903, 0);
        }
        catch (Throwable throwable) {
            MTCommonLog.w((String)TAG, (String)("turnOffPush failed " + throwable.getMessage()));
        }
    }
}

