/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.d.a;
import com.meizu.cloud.pushsdk.d.i;
import com.meizu.cloud.pushsdk.d.l.d;
import java.io.File;
import java.util.Locale;

public class MzSystemUtils {
    private static final String TAG = "MzSystemUtils";
    private static final String PUSH_SERVICE_PROCESS_NAME = "mzservice_v1";
    private static int flymeVersion = -1;
    private static String sCharacteristics;

    private static String getServicesByPackageName(Context serviceInfoArray, String string) {
        PackageManager packageManager = serviceInfoArray.getPackageManager();
        serviceInfoArray = null;
        try {
            serviceInfoArray = packageManager.getPackageInfo((String)string, (int)4).services;
        }
        catch (Exception exception) {}
        if (serviceInfoArray == null) {
            return null;
        }
        for (ServiceInfo serviceInfo : serviceInfoArray) {
            if (!"com.meizu.cloud.pushsdk.pushservice.MzPushService".equals(serviceInfo.name)) continue;
            return serviceInfo.processName;
        }
        return null;
    }

    public static String getMzPushServicePackageName(Context object) {
        String string;
        block6: {
            string = object.getPackageName();
            String string2 = MzSystemUtils.isWatch() ? "com.meizu.wearable.cloud" : "com.meizu.cloud";
            object = MzSystemUtils.getServicesByPackageName((Context)object, string2);
            if (TextUtils.isEmpty((CharSequence)object)) break block6;
            try {
                if (((String)object).contains(PUSH_SERVICE_PROCESS_NAME)) {
                    return string2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        DebugLogger.i(TAG, "start service package name " + string);
        return string;
    }

    public static String getAppVersionName(Context object, String string) {
        block3: {
            try {
                object = object.getPackageManager().getPackageInfo((String)string, (int)0).versionName;
                if (object == null) break block3;
            }
            catch (Exception exception) {
                DebugLogger.e(TAG, "Exception message " + exception.getMessage());
                return "";
            }
            if (((String)object).length() <= 0) break block3;
            return object;
        }
        return "";
    }

    public static boolean compareVersion(String stringArray, String stringArray2) {
        stringArray = stringArray.split("\\.");
        stringArray2 = stringArray2.split("\\.");
        int n2 = Math.min(stringArray.length, stringArray2.length);
        int n3 = 0;
        for (int i2 = 0; i2 < n2 && (n3 = stringArray[i2].length() - stringArray2[i2].length()) == 0 && (n3 = stringArray[i2].compareTo(stringArray2[i2])) == 0; ++i2) {
        }
        if (n3 == 0) {
            n3 = stringArray.length - stringArray2.length;
        }
        return n3 >= 0;
    }

    public static void sendMessageFromBroadcast(Context context, Intent intent, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            intent.setAction(string);
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            intent.setPackage(string2);
        }
        if (!TextUtils.isEmpty((CharSequence)(string = MzSystemUtils.findReceiver(context, string, string2)))) {
            intent.setClassName(string2, string);
        }
        context.sendBroadcast(intent);
    }

    @SuppressLint(value={"QueryPermissionsNeeded"})
    public static String findReceiver(Context object, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            block7: {
                Intent intent;
                Context context = object;
                object = intent;
                object(string);
                intent.setPackage(string2);
                object = context.getPackageManager().queryBroadcastReceivers((Intent)object, 0);
                if (object.size() <= 0) break block7;
                try {
                    return ((ResolveInfo)object.get((int)0)).activityInfo.name;
                }
                catch (Exception exception) {
                    DebugLogger.e(TAG, "findReceiver error " + exception.getMessage());
                }
            }
            return null;
        }
        return null;
    }

    public static boolean isBrandMeizu(Context context) {
        boolean bl = MzSystemUtils.isMeizu();
        if (!bl) {
            com.meizu.cloud.pushsdk.c.a.c(context.getApplicationContext());
        }
        return bl;
    }

    public static boolean isMeizu() {
        String string = Build.BRAND;
        return "meizu".equalsIgnoreCase(string) || "mblu".equalsIgnoreCase(string) || !TextUtils.isEmpty((CharSequence)i.a("ro.vendor.meizu.product.model")) || !TextUtils.isEmpty((CharSequence)i.a("ro.meizu.product.model"));
    }

    public static boolean isWatch() {
        if (TextUtils.isEmpty((CharSequence)sCharacteristics)) {
            sCharacteristics = i.a("ro.build.characteristics");
        }
        if (TextUtils.isEmpty((CharSequence)sCharacteristics)) {
            sCharacteristics = "phone";
            return false;
        }
        return sCharacteristics.contains("watch");
    }

    public static boolean isOverseas() {
        return MzSystemUtils.isInternational() || MzSystemUtils.isIndiaLocal();
    }

    public static boolean isInternational() {
        return a.a().a ? (Boolean)a.a().b : false;
    }

    public static boolean isIndiaLocal() {
        return "india".equals(i.a("ro.meizu.locale.region"));
    }

    public static boolean isMeizuAndFlyme() {
        d<Boolean> d2 = a.b();
        if (d2.a) {
            return (Boolean)d2.b ^ true;
        }
        return false;
    }

    public static String getNetWorkType(Context object) {
        block14: {
            ConnectivityManager connectivityManager;
            block13: {
                block12: {
                    block11: {
                        Context context = object;
                        object = "";
                        connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                        if (connectivityManager == null) break block11;
                        connectivityManager = connectivityManager.getActiveNetworkInfo();
                        break block12;
                    }
                    connectivityManager = null;
                }
                if (connectivityManager == null) break block14;
                int n2 = connectivityManager.getType();
                if (n2 == 0) break block13;
                object = n2 != 1 ? (n2 != 7 ? (n2 != 9 ? "OTHER" : "ETHERNET") : "BLUETOOTH") : "WIFI";
            }
            try {
                switch (connectivityManager.getSubtype()) {
                    default: {
                        object = "MOBILE_XG";
                        break;
                    }
                    case 20: {
                        return "MOBILE_5G";
                    }
                    case 13: 
                    case 18: {
                        object = "MOBILE_4G";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        object = "MOBILE_3G";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        object = "MOBILE_2G";
                        break;
                    }
                }
            }
            catch (Exception exception) {
                DebugLogger.e(TAG, "Security exception checking connection: " + exception.getMessage());
            }
        }
        return object;
    }

    public static String getCurrentLanguage() {
        try {
            return Locale.getDefault().getLanguage();
        }
        catch (Exception exception) {
            DebugLogger.e(TAG, "getCurrentLanguage error " + exception.getMessage());
            return null;
        }
    }

    public static String getAppVersionName(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static int getAppVersionCode(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static boolean isPackageInstalled(Context context, String string) {
        try {
            context.getPackageManager().getPackageInfo(string, 0);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @SuppressLint(value={"QueryPermissionsNeeded"})
    public static boolean isExistReceiver(Context context, String object, String string) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)object)) {
            Intent intent;
            boolean bl = false;
            Intent intent2 = intent;
            intent2(string);
            intent.setPackage((String)object);
            object = context.getPackageManager().queryBroadcastReceivers(intent2, 0);
            if (object != null && object.size() > 0 && !TextUtils.isEmpty((CharSequence)((ResolveInfo)object.get((int)0)).activityInfo.name)) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isInteractive(Context context) {
        boolean bl;
        block6: {
            if ((context = (PowerManager)context.getSystemService("power")) == null) {
                return true;
            }
            try {
                if (Build.VERSION.SDK_INT < 20) break block6;
            }
            catch (Exception exception) {
                DebugLogger.e(TAG, "isScreenOn error " + exception.getMessage());
                return true;
            }
            bl = context.isInteractive();
            return bl;
        }
        bl = context.isScreenOn();
        return bl;
    }

    public static String getDocumentsPath(Context context) {
        Object object = Build.VERSION.SDK_INT >= 19 ? Environment.DIRECTORY_DOCUMENTS : "Documents";
        if ((object = context.getExternalFilesDir((String)object)) != null) {
            return ((File)object).getPath();
        }
        return "/storage/emulated/0/Android/data/" + context.getPackageName() + "/files/Documents";
    }

    /*
     * Loose catch block
     */
    public static int getFlymeVersion() {
        int n2 = flymeVersion;
        if (n2 > 0) {
            return n2;
        }
        String string = i.a("ro.build.flyme.version");
        {
            catch (Exception exception) {
                DebugLogger.e(TAG, "getFlymeVersion error " + exception.getMessage());
                return -1;
            }
        }
        try {
            flymeVersion = Integer.parseInt(string);
            return flymeVersion;
        }
        catch (Exception exception) {
            String string2;
            block9: {
                string2 = i.a("ro.flyme.version.id");
                if (!TextUtils.isEmpty((CharSequence)string2)) break block9;
                string2 = i.a("ro.build.display.id");
            }
            flymeVersion = Integer.valueOf(string2.replace("Flyme", "").replace(" ", "").substring(0, 1));
            return flymeVersion;
        }
    }
}

