/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.platform.oppo.business;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.engagelab.privates.common.api.MTCommonPrivatesApi;
import com.engagelab.privates.common.global.MTGlobal;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.push.api.MTPushPrivatesApi;
import com.engagelab.privates.push.api.PlatformTokenMessage;
import com.engagelab.privates.push.platform.oppo.callback.MTOppoCallback;
import com.heytap.msp.push.HeytapPushManager;
import com.heytap.msp.push.callback.ICallBackResultService;

public class MTOppoBusiness {
    private static final String TAG = "MTOppoBusiness";
    private static final String OPPO_APPID = "OPPO_APPID";
    private static final String OPPO_APPKEY = "OPPO_APPKEY";
    private static final String OPPO_APPSECRET = "OPPO_APPSECRET";
    private boolean isSupport;
    private static volatile MTOppoBusiness instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MTOppoBusiness getInstance() {
        if (instance != null) return instance;
        Class<MTOppoBusiness> clazz = MTOppoBusiness.class;
        synchronized (MTOppoBusiness.class) {
            instance = new MTOppoBusiness();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Context context, Bundle bundle) {
        try {
            String appId = this.getAppId(context, bundle);
            if (TextUtils.isEmpty((CharSequence)appId)) {
                MTCommonLog.e((String)TAG, (String)"not support oppo push, oppo appId is empty");
                return;
            }
            String appKey = this.getAppKey(context, bundle);
            if (TextUtils.isEmpty((CharSequence)appKey)) {
                MTCommonLog.e((String)TAG, (String)"not support oppo push, oppo appKey is empty");
                return;
            }
            String appSecret = this.getAppSecret(context, bundle);
            if (TextUtils.isEmpty((CharSequence)appSecret)) {
                MTCommonLog.e((String)TAG, (String)"not support oppo push, oppo appSecret is empty");
                return;
            }
            HeytapPushManager.init((Context)context, (boolean)true);
            this.isSupport = HeytapPushManager.isSupportPush((Context)context);
            if (!this.isSupport) {
                MTCommonLog.d((String)TAG, (String)"not support oppo push");
                this.onNode(context, 3002, 0, 3900, 1);
                return;
            }
            MTCommonLog.d((String)TAG, (String)"support oppo push");
            HeytapPushManager.register((Context)context, (String)appKey, (String)appSecret, (ICallBackResultService)MTOppoCallback.getICallBackResultServiceRegister(context));
            String token = HeytapPushManager.getRegisterID();
            if (TextUtils.isEmpty((CharSequence)token)) {
                MTCommonLog.d((String)TAG, (String)"onTokenFailed:get token is empty");
                this.onNode(context, 3003, 0, 3900, 1);
                return;
            }
            MTCommonLog.d((String)TAG, (String)("onTokenSuccess:get token is " + token));
            this.onToken(context, token, 1);
        }
        catch (Throwable throwable) {
            this.isSupport = false;
            MTCommonLog.e((String)TAG, (String)("init failed " + throwable.getMessage()));
        }
    }

    private String getAppId(Context context, Bundle bundle) {
        String appId = null;
        try {
            String metaData;
            if (null != bundle && bundle.containsKey(OPPO_APPID)) {
                String bundleString = bundle.getString(OPPO_APPID);
                if (TextUtils.isEmpty((CharSequence)bundleString)) {
                    MTCommonLog.w((String)TAG, (String)"api config : OPPO_APPID - not empty !");
                } else {
                    appId = bundleString.substring(3);
                }
            }
            if (TextUtils.isEmpty(appId) && !TextUtils.isEmpty((CharSequence)(metaData = MTGlobal.getMetaData((Context)context, (String)OPPO_APPID)))) {
                appId = metaData.substring(3);
            }
        }
        catch (Throwable e) {
            MTCommonLog.e((String)TAG, (String)(" config info error: OPPO_APPID - " + e));
        }
        return appId;
    }

    private String getAppKey(Context context, Bundle bundle) {
        String appKey = null;
        try {
            String metaData;
            if (null != bundle && bundle.containsKey(OPPO_APPKEY)) {
                String bundleString = bundle.getString(OPPO_APPKEY);
                if (TextUtils.isEmpty((CharSequence)bundleString)) {
                    MTCommonLog.w((String)TAG, (String)"api config : OPPO_APPKEY - not empty !");
                } else {
                    appKey = bundleString.substring(3);
                }
            }
            if (TextUtils.isEmpty(appKey) && !TextUtils.isEmpty((CharSequence)(metaData = MTGlobal.getMetaData((Context)context, (String)OPPO_APPKEY)))) {
                appKey = metaData.substring(3);
            }
        }
        catch (Throwable e) {
            MTCommonLog.e((String)TAG, (String)(" config info error: OPPO_APPKEY - " + e));
        }
        return appKey;
    }

    private String getAppSecret(Context context, Bundle bundle) {
        String appSecret = null;
        try {
            String metaData;
            if (null != bundle && bundle.containsKey(OPPO_APPSECRET)) {
                String bundleString = bundle.getString(OPPO_APPSECRET);
                if (TextUtils.isEmpty((CharSequence)bundleString)) {
                    MTCommonLog.w((String)TAG, (String)"api config : OPPO_APPSECRET - not empty !");
                } else {
                    appSecret = bundleString.substring(3);
                }
            }
            if (TextUtils.isEmpty(appSecret) && !TextUtils.isEmpty((CharSequence)(metaData = MTGlobal.getMetaData((Context)context, (String)OPPO_APPSECRET)))) {
                appSecret = metaData.substring(3);
            }
        }
        catch (Throwable e) {
            MTCommonLog.e((String)TAG, (String)(" config info error: OPPO_APPSECRET - " + e));
        }
        return appSecret;
    }

    public void onToken(Context context, String token, int from) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            MTCommonLog.d((String)TAG, (String)"onToken:token is empty");
            return;
        }
        String region = this.getRegion(token);
        PlatformTokenMessage platformTokenMessage = new PlatformTokenMessage().setPlatform((byte)4).setRegion(region).setToken(token);
        Bundle bundle = new Bundle();
        bundle.putParcelable("message", (Parcelable)platformTokenMessage);
        MTPushPrivatesApi.init((Context)context);
        MTCommonPrivatesApi.sendMessageToMainProcess((Context)context.getApplicationContext(), (int)3021, (Bundle)bundle);
        this.onNode(context, 3008, 0, 3901, from);
    }

    private String getRegion(String token) {
        String region = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)token)) {
                region = token.contains("CN_") ? "CN" : "GLOBAL";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return region;
    }

    public void onNode(Context context, int code, int mCode, int type, int from) {
        Bundle bundle = new Bundle();
        bundle.putByte("platform", (byte)4);
        bundle.putInt("code", code);
        bundle.putInt("mCode", mCode);
        bundle.putInt("type", type);
        bundle.putInt("from", from);
        MTCommonPrivatesApi.sendMessageToMainProcess((Context)context, (int)3022, (Bundle)bundle);
    }

    public void turnOnPush(Context context) {
        try {
            if (!this.isSupport) {
                return;
            }
            HeytapPushManager.resumePush();
            this.onNode(context, 3101, 0, 3902, 0);
        }
        catch (Throwable throwable) {
            MTCommonLog.w((String)TAG, (String)("turnOnPush failed " + throwable.getMessage()));
        }
    }

    public void turnOffPush(Context context) {
        try {
            if (!this.isSupport) {
                return;
            }
            HeytapPushManager.pausePush();
            this.onNode(context, 3102, 0, 3903, 0);
        }
        catch (Throwable throwable) {
            MTCommonLog.w((String)TAG, (String)("turnOffPush failed " + throwable.getMessage()));
        }
    }

    public void requestNotificationPermission(Context context) {
        if (!this.isSupport) {
            return;
        }
        HeytapPushManager.requestNotificationPermission();
    }
}

