/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.oth.sound.business;

import android.content.Context;
import android.os.Bundle;
import android.util.Base64;
import android.util.Pair;
import com.engagelab.privates.common.api.MTCommonPrivatesApi;
import com.engagelab.privates.common.constants.MTCommonConstants;
import com.engagelab.privates.common.global.MTGlobal;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.common.utils.AESUtil;
import com.engagelab.privates.common.utils.SM4Util;
import com.engagelab.privates.common.utils.StringUtil;
import com.engagelab.privates.common.utils.SystemUtil;
import com.engagelab.privates.core.global.MTCoreGlobal;
import com.engagelab.privates.push.api.MTPushPrivatesApi;
import com.engagelab.privates.push.global.MTJpushGlobal;
import com.engagelab.privates.push.oth.sound.OTHSound;
import com.engagelab.privates.push.oth.sound.business.SoundJson;
import com.engagelab.privates.push.oth.sound.cache.OTHSoundConfig;
import com.engagelab.privates.push.oth.sound.util.FileUtil;
import com.engagelab.privates.push.oth.sound.util.HttpUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class OTHDownloadBusiness {
    private static final String TAG = "OTHDownloadBusiness";
    private static final long INTERVAL_TIME = 86400000L;
    private static final String API_SOUND = "/api/dl_audio_res";
    private static List<String> httpAddress = null;

    public static synchronized void start(Context context, Bundle bundle) {
        try {
            byte[] reportBytes;
            long uid;
            boolean enableSound;
            ArrayList get_http_address = bundle.getStringArrayList("get_http_address");
            if (null != get_http_address) {
                httpAddress = get_http_address;
            }
            if (!(enableSound = OTHSoundConfig.getEnablePushTextToSpeech(context))) {
                MTCommonLog.d((String)TAG, (String)("enableSound:" + enableSound));
                return;
            }
            long lastTime = OTHSoundConfig.getLastTime(context, MTJpushGlobal.getUserLanguage((Context)context));
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis - lastTime < 86400000L) {
                MTCommonLog.d((String)TAG, (String)("last time currentTimeMillis:" + currentTimeMillis));
                MTCommonLog.d((String)TAG, (String)("last time lastTime:" + lastTime));
                MTCommonLog.d((String)TAG, (String)"last time no interval:86400000");
                return;
            }
            List httpAddressSet = httpAddress;
            if (null == httpAddressSet || httpAddressSet.isEmpty()) {
                MTCommonLog.d((String)TAG, (String)"is empty");
                httpAddressSet = MTCoreGlobal.getHttpAddress((Context)context);
                if (httpAddressSet.isEmpty()) {
                    MTCommonLog.d((String)TAG, (String)"there are no report url");
                    return;
                }
            }
            if ((uid = MTCoreGlobal.getUserId((Context)context)) == 0L) {
                MTCommonLog.d((String)TAG, (String)"uid is 0");
                return;
            }
            String requestBody = OTHDownloadBusiness.getRequestBody(context);
            MTCommonLog.d((String)TAG, (String)("requestBody:" + requestBody));
            String reportString = requestBody;
            byte[] zipBytes = reportBytes = reportString.getBytes(MTCommonConstants.UTF_8);
            int seed = AESUtil.generateSeed();
            String key = AESUtil.getMd5AesKey((long)seed);
            byte[] ivBytes = new byte[]{11, 13, 18, 80, 82, 81, 82, 86, 82, 87, 82, 84, 3, 50, 9, 67};
            String iv = AESUtil.getIv((String)new String(ivBytes, Charset.forName("UTF-8")), (char)'b');
            byte[] body = SM4Util.encryptBytes((byte[])zipBytes, (String)key, (String)iv);
            String password = MTCoreGlobal.getPassword((Context)context);
            String passwordMd5 = StringUtil.getMD5Utf8((String)password);
            String bodyMd5 = StringUtil.getBytesSHA1((byte[])body);
            String token = StringUtil.getBytesSHA1((String)(uid + passwordMd5 + bodyMd5));
            String authorization = uid + ":" + token + ":" + key;
            String authorizationBasic = "Basic " + Base64.encodeToString((byte[])authorization.getBytes(), (int)10);
            MTCommonLog.d((String)TAG, (String)("authorizationBasic:" + authorizationBasic));
            ArrayList connectAddress = new ArrayList();
            for (int i = 0; i < 3; ++i) {
                connectAddress.addAll(httpAddressSet);
            }
            for (String address : connectAddress) {
                if (!address.contains(API_SOUND)) {
                    address = address + API_SOUND;
                }
                String requestUrl = address;
                MTCommonLog.d((String)TAG, (String)("requestUrl:" + requestUrl));
                Pair<Integer, String> post = HttpUtil.post(context, requestUrl, authorizationBasic, body);
                if (200 == (Integer)post.first) {
                    MTCommonLog.d((String)TAG, (String)("requestUrl responseBody:" + (String)post.second));
                    SoundJson soundJson = SoundJson.fromJson((String)post.second);
                    MTCommonLog.d((String)TAG, (String)("responseBody soundJson:" + soundJson));
                    if (2000 == soundJson.getCode()) {
                        if (soundJson.valid()) {
                            if (OTHSoundConfig.getLastSignSound(context).equals(soundJson.getContent().getMd5())) {
                                MTCommonLog.w((String)TAG, (String)"responseBody succeed not has up data");
                                OTHSoundConfig.setLastTime(context, MTJpushGlobal.getUserLanguage((Context)context), System.currentTimeMillis());
                                return;
                            }
                            boolean download = OTHDownloadBusiness.download(context, soundJson);
                            if (download) {
                                MTCommonLog.d((String)TAG, (String)"responseBody succeed");
                                OTHSoundConfig.setResponseBody(context, soundJson.getContent().getLan(), soundJson.getBody());
                                OTHSoundConfig.setLastTime(context, MTJpushGlobal.getUserLanguage((Context)context), System.currentTimeMillis());
                                OTHSoundConfig.setLastSignSound(context, soundJson.getContent().getMd5());
                                return;
                            }
                            MTCommonLog.e((String)TAG, (String)"responseBody fail");
                        } else {
                            MTCommonLog.e((String)TAG, (String)("responseBody soundJson valid fail:" + soundJson));
                        }
                        if (SystemUtil.isNetworkConnecting((Context)context)) {
                            MTCommonPrivatesApi.sendMessageDelayed((Context)context, (String)OTHSound.THREAD_OTH, (int)3400, null, (long)5000L);
                        }
                        return;
                    }
                    if (2002 == soundJson.getCode()) {
                        MTCommonLog.d((String)TAG, (String)("not has up data :" + soundJson.getCode()));
                    } else if (2001 == soundJson.getCode()) {
                        MTCommonLog.d((String)TAG, (String)("not has opened :" + soundJson.getCode()));
                        OTHSoundConfig.setResponseBody(context, soundJson.getContent().getLan(), "");
                        OTHSoundConfig.setLastTime(context, MTJpushGlobal.getUserLanguage((Context)context), System.currentTimeMillis());
                        OTHSoundConfig.setLastSignSound(context, "");
                    } else {
                        MTCommonLog.w((String)TAG, (String)("responseBody code:" + soundJson.getCode()));
                    }
                    OTHSoundConfig.setLastTime(context, MTJpushGlobal.getUserLanguage((Context)context), System.currentTimeMillis());
                    return;
                }
                MTCommonLog.e((String)TAG, (String)("start fail code:" + post.first + ", msg:" + (String)post.second));
            }
            if (SystemUtil.isNetworkConnecting((Context)context)) {
                MTCommonPrivatesApi.sendMessageDelayed((Context)context, (String)OTHSound.THREAD_OTH, (int)3400, null, (long)5000L);
            }
            return;
        }
        catch (Throwable e) {
            MTCommonLog.e((String)TAG, (String)("start fail:" + e));
            return;
        }
    }

    public static String getRequestBody(Context context) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("ak", (Object)MTGlobal.getAppKey((Context)context));
            jsonObject.put("uid", (Object)(MTCoreGlobal.getUserId((Context)context) + ""));
            jsonObject.put("p", (Object)"a");
            jsonObject.put("av", (Object)"1");
            jsonObject.put("lan", (Object)MTJpushGlobal.getUserLanguage((Context)context));
            jsonObject.put("sign", (Object)OTHSoundConfig.getLastSignSound(context));
            jsonObject.put("push_ver", (Object)MTPushPrivatesApi.SDK_VERSION_NAME);
        }
        catch (JSONException e) {
            MTCommonLog.w((String)TAG, (String)("getRequestBody JSONException:" + (Object)((Object)e)));
        }
        return jsonObject.toString();
    }

    public static boolean responseBody(Context context, SoundJson soundJson) {
        if (2000 == soundJson.getCode()) {
            if (soundJson.valid()) {
                OTHSoundConfig.setResponseBody(context, soundJson.getContent().getLan(), soundJson.getBody());
                boolean download = OTHDownloadBusiness.download(context, soundJson);
                return download;
            }
            MTCommonLog.e((String)TAG, (String)("responseBody soundJson valid fail:" + soundJson));
        } else {
            MTCommonLog.w((String)TAG, (String)("responseBody code:" + soundJson.getCode()));
            MTCommonLog.d((String)TAG, (String)("responseBody soundJson:" + soundJson));
        }
        return false;
    }

    public static boolean download(Context context, SoundJson soundJson) {
        if (!soundJson.valid()) {
            MTCommonLog.e((String)TAG, (String)("download invalid soundJson:" + soundJson));
            return false;
        }
        SoundJson.Content content = soundJson.getContent();
        String path = content.getPath(context);
        File downloadFile = HttpUtil.download(content.getAr(), 10000, path);
        if (null == downloadFile) {
            MTCommonLog.e((String)TAG, (String)"download fail");
            return false;
        }
        MTCommonLog.d((String)TAG, (String)("download ef:" + downloadFile.getAbsolutePath()));
        try {
            File tmpFile = new File(content.getPathDecrypt(context));
            File zipFile = FileUtil.aesDecrypt(downloadFile, tmpFile, content.getMd5());
            MTCommonLog.d((String)TAG, (String)("download df:" + zipFile.getAbsolutePath()));
            String pathUnZip = content.getPathUnZip(context);
            File outputFolder = new File(pathUnZip);
            FileUtil.unzip(zipFile, outputFolder);
            MTCommonLog.d((String)TAG, (String)("download ff:" + outputFolder.getAbsolutePath()));
            return true;
        }
        catch (Throwable e) {
            MTCommonLog.e((String)TAG, (String)("download fail:" + e));
            return false;
        }
    }
}

