/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.database.Cursor;
import com.huawei.hms.framework.common.ContextHolder;
import com.huawei.hms.framework.common.Logger;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class IoUtils {
    private static final int BUFF_SIZE = 4096;
    private static final int MAX_SIZE = 0x1000000;

    private IoUtils() {
    }

    public static void close(Cursor cursor) {
        if (cursor != null) {
            cursor.close();
        }
    }

    public static void closeSecure(Reader reader) {
        IoUtils.closeSecure((Closeable)reader);
    }

    public static void closeSecure(Writer writer) {
        IoUtils.closeSecure((Closeable)writer);
    }

    public static void closeSecure(InputStream input) {
        IoUtils.closeSecure((Closeable)input);
    }

    public static void closeSecure(OutputStream output) {
        IoUtils.closeSecure((Closeable)output);
    }

    public static void closeSecure(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException var2) {
                Logger.w("IOUtil", "closeSecure IOException", var2);
            }
        } else {
            Logger.w("IOUtil", "closeable is null");
        }
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        int n;
        String packageName = "";
        if (ContextHolder.getAppContext() != null) {
            packageName = ContextHolder.getAppContext().getPackageName();
        }
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            if (count > 0x1000000L && !"com.huawei.health".equals(packageName)) {
                throw new IOException("input data too large for byte.");
            }
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IoUtils.copy(input, output);
        return output.toByteArray();
    }
}

