/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import com.huawei.hms.framework.common.Logger;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LimitQueue<E>
extends ConcurrentLinkedQueue<E> {
    private static final String TAG = "LimitQueue";
    private static final long serialVersionUID = -4636313759149307798L;
    private int limit;
    private boolean deduplication = false;

    public LimitQueue(int limit) {
        this.limit = limit;
    }

    public LimitQueue(int limit, boolean deduplication) {
        this.limit = limit;
        this.deduplication = deduplication;
    }

    public LimitQueue(Collection<? extends E> c, boolean deduplication) {
        this(c.size(), deduplication);
        this.addAll(c);
    }

    @Override
    public boolean offer(E e) {
        if (this.deduplication) {
            super.remove(e);
        }
        if (super.size() >= this.limit) {
            super.poll();
        }
        return super.offer(e);
    }

    @Override
    public boolean add(E e) {
        if (this.deduplication) {
            super.remove(e);
        }
        if (super.size() >= this.limit) {
            super.poll();
        }
        return super.add(e);
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public E poll() {
        return super.poll();
    }

    @Override
    public E remove() {
        try {
            return super.remove();
        }
        catch (NoSuchElementException e) {
            Logger.w(TAG, "remove failed, limitQueue is empty");
            return null;
        }
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c.size() > this.limit) {
            return false;
        }
        if (this.deduplication) {
            super.removeAll(c);
        }
        for (int removeSum = c.size() + super.size() - this.limit; removeSum > 0; --removeSum) {
            super.poll();
        }
        return super.addAll(c);
    }

    public E get(int index) {
        Iterator iterator = this.iterator();
        E e = null;
        for (int i = 0; i <= index && iterator.hasNext(); ++i) {
            e = iterator.next();
        }
        return e;
    }

    public E peekLast() {
        E i = null;
        for (Object e : this) {
            i = e;
        }
        return i;
    }
}

