/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.util.Base64;
import com.huawei.secure.android.common.util.SafeBase64;

public class SecurityBase64Utils {
    private static final String SAFE_BASE64_PATH = "com.huawei.secure.android.common.util.SafeBase64";
    private static volatile boolean IS_AEGIS_BASE64_LIBRARY_LOADED = false;

    public static String encodeToString(byte[] bytes, int flags) {
        if (IS_AEGIS_BASE64_LIBRARY_LOADED || SecurityBase64Utils.checkCompatible(SAFE_BASE64_PATH)) {
            return SafeBase64.encodeToString((byte[])bytes, (int)flags);
        }
        try {
            return Base64.encodeToString((byte[])bytes, (int)flags);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static byte[] decode(String content, int flags) {
        if (IS_AEGIS_BASE64_LIBRARY_LOADED || SecurityBase64Utils.checkCompatible(SAFE_BASE64_PATH)) {
            return SafeBase64.decode((String)content, (int)flags);
        }
        try {
            return Base64.decode((String)content, (int)flags);
        }
        catch (Exception ex) {
            return new byte[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkCompatible(String className) {
        ClassLoader classLoader = SecurityBase64Utils.class.getClassLoader();
        if (null == classLoader) {
            return false;
        }
        try {
            classLoader.loadClass(className);
            Class<SecurityBase64Utils> clazz = SecurityBase64Utils.class;
            synchronized (SecurityBase64Utils.class) {
                IS_AEGIS_BASE64_LIBRARY_LOADED = true;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

