/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Process;
import com.huawei.hms.framework.common.Logger;

public class ContextCompat {
    private static final String TAG = "ContextCompat";

    public static boolean checkSelfPermission(Context context, String permission) {
        if (context == null || permission == null) {
            Logger.w((String)TAG, (Object)"param is null");
            return false;
        }
        boolean hasPermission = false;
        try {
            hasPermission = context.checkPermission(permission, Process.myPid(), Process.myUid()) == 0;
        }
        catch (RuntimeException e) {
            Logger.e((String)TAG, (String)"dealType rethrowFromSystemServer:", (Throwable)e);
        }
        return hasPermission;
    }

    public static Context getProtectedStorageContext(Context context) {
        if (context == null) {
            Logger.w((String)TAG, (Object)"context is null");
            return null;
        }
        if (Build.VERSION.SDK_INT < 24) {
            return context;
        }
        return context.createDeviceProtectedStorageContext();
    }

    public static Intent registerReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter) {
        if (context == null) {
            Logger.w((String)TAG, (Object)"context is null");
            return null;
        }
        Intent intent = null;
        try {
            intent = context.registerReceiver(receiver, filter);
        }
        catch (RuntimeException e) {
            Logger.e((String)TAG, (String)"dealType rethrowFromSystemServer:", (Throwable)e);
        }
        return intent;
    }

    public static Intent registerReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        if (context == null) {
            Logger.w((String)TAG, (Object)"context is null");
            return null;
        }
        Intent intent = null;
        try {
            intent = context.registerReceiver(receiver, filter, broadcastPermission, scheduler);
        }
        catch (RuntimeException e) {
            Logger.e((String)TAG, (String)"dealType rethrowFromSystemServer:", (Throwable)e);
        }
        return intent;
    }

    public static void unregisterReceiver(Context context, BroadcastReceiver receiver) {
        if (context == null) {
            Logger.w((String)TAG, (Object)"context is null");
            return;
        }
        try {
            context.unregisterReceiver(receiver);
        }
        catch (RuntimeException e) {
            Logger.e((String)TAG, (String)"SystemServer error:", (Throwable)e);
        }
    }

    public static ComponentName startService(Context context, Intent intent) {
        if (context == null) {
            Logger.w((String)TAG, (Object)"context is null");
            return null;
        }
        ComponentName componentName = null;
        try {
            componentName = context.startService(intent);
        }
        catch (RuntimeException e) {
            Logger.e((String)TAG, (String)"SystemServer error:", (Throwable)e);
        }
        return componentName;
    }

    public static Object getSystemService(Context context, String name) {
        if (context == null) {
            Logger.w((String)TAG, (Object)"context is null");
            return null;
        }
        Object object = null;
        try {
            object = context.getSystemService(name);
        }
        catch (RuntimeException e) {
            Logger.e((String)TAG, (String)"SystemServer error:", (Throwable)e);
        }
        return object;
    }
}

