/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.content.Context;
import android.text.TextUtils;
import com.huawei.hms.framework.common.ContextCompat;
import com.huawei.hms.framework.common.EmuiUtil;
import com.huawei.hms.framework.common.Logger;
import com.huawei.hms.framework.common.ReflectionUtils;
import com.huawei.libcore.io.ExternalStorageFile;
import com.huawei.libcore.io.ExternalStorageFileInputStream;
import com.huawei.libcore.io.ExternalStorageFileOutputStream;
import com.huawei.libcore.io.ExternalStorageRandomAccessFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class CreateFileUtil {
    private static final String TAG = "CreateFileUtil";
    private static final String EXTERNAL_FILE_NAME = "com.huawei.libcore.io.ExternalStorageFile";
    private static final String EXTERNAL_INPUTSTREAM_NAME = "com.huawei.libcore.io.ExternalStorageFileInputStream";
    private static final String EXTERNAL_OUTPUTSTREAM_NAME = "com.huawei.libcore.io.ExternalStorageFileOutputStream";
    private static final String RANDOM_ACCESS_FILE_NAME = "com.huawei.libcore.io.ExternalStorageRandomAccessFile";

    public static String getCacheDirPath(Context context) {
        if (context == null) {
            return "";
        }
        return ContextCompat.getProtectedStorageContext(context).getCacheDir().getPath();
    }

    public static File newFile(String path) {
        if (path == null) {
            return null;
        }
        if (EmuiUtil.isUpPVersion() && ReflectionUtils.checkCompatible((String)EXTERNAL_FILE_NAME)) {
            return new ExternalStorageFile(path);
        }
        return new File(path);
    }

    public static String getCanonicalPath(String path) {
        String canonicalPath = path;
        try {
            canonicalPath = CreateFileUtil.newFile(path).getCanonicalPath();
        }
        catch (IOException ex) {
            Logger.w((String)TAG, (String)"the canonicalPath has IOException", (Throwable)ex);
        }
        catch (SecurityException ex) {
            Logger.w((String)TAG, (String)"the canonicalPath has securityException", (Throwable)ex);
        }
        catch (Exception ex) {
            Logger.w((String)TAG, (String)"the canonicalPath has other Exception", (Throwable)ex);
        }
        return canonicalPath;
    }

    public static FileInputStream newFileInputStream(String path) throws FileNotFoundException {
        if (path == null) {
            Logger.w((String)TAG, (Object)"newFileInputStream  file is null");
            throw new FileNotFoundException("file is null");
        }
        if (EmuiUtil.isUpPVersion() && ReflectionUtils.checkCompatible((String)EXTERNAL_INPUTSTREAM_NAME)) {
            return new ExternalStorageFileInputStream(path);
        }
        return new FileInputStream(path);
    }

    public static FileOutputStream newFileOutputStream(File file) throws FileNotFoundException {
        if (file == null) {
            Logger.e((String)TAG, (Object)"newFileOutputStream  file is null");
            throw new FileNotFoundException("file is null");
        }
        if (EmuiUtil.isUpPVersion() && ReflectionUtils.checkCompatible((String)EXTERNAL_OUTPUTSTREAM_NAME)) {
            return new ExternalStorageFileOutputStream(file);
        }
        return new FileOutputStream(file);
    }

    public static RandomAccessFile newRandomAccessFile(String filePath, String mode) throws FileNotFoundException {
        if (filePath == null) {
            Logger.w((String)TAG, (Object)"newFileOutputStream  file is null");
            throw new FileNotFoundException("file is null");
        }
        if (EmuiUtil.isUpPVersion() && ReflectionUtils.checkCompatible((String)RANDOM_ACCESS_FILE_NAME)) {
            return new ExternalStorageRandomAccessFile(filePath, mode);
        }
        return new RandomAccessFile(filePath, mode);
    }

    public static void deleteSecure(File file) {
        if (file != null && file.exists() && !file.delete()) {
            Logger.w((String)TAG, (Object)"deleteSecure exception");
        }
    }

    public static void deleteSecure(String filePath) {
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            CreateFileUtil.deleteSecure(CreateFileUtil.newFile(filePath));
        }
    }

    @Deprecated
    public static boolean isPVersion() {
        return EmuiUtil.isUpPVersion();
    }
}

