/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.stats;

import android.content.Context;
import android.os.PowerManager;
import android.os.WorkSource;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.WorkSourceUtil;
import com.google.android.gms.internal.stats.zzh;
import com.google.android.gms.internal.stats.zzi;
import com.google.android.gms.stats.zza;
import com.google.android.gms.stats.zzb;
import com.google.android.gms.stats.zzc;
import com.google.android.gms.stats.zzd;
import com.google.android.gms.stats.zze;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.ThreadSafe;

@ShowFirstParty
@ThreadSafe
@KeepForSdk
public class WakeLock {
    private static final long zzb;
    private static volatile ScheduledExecutorService zzc;
    private static final Object zzd;
    private static volatile zzd zze;
    private final Object zzf;
    @GuardedBy(value="acquireReleaseLock")
    private final PowerManager.WakeLock zzg;
    @GuardedBy(value="acquireReleaseLock")
    private int zzh;
    @GuardedBy(value="acquireReleaseLock")
    private Future<?> zzi;
    @GuardedBy(value="acquireReleaseLock")
    private long zzj;
    @GuardedBy(value="acquireReleaseLock")
    private final Set<zze> zzk;
    @GuardedBy(value="acquireReleaseLock")
    private boolean zzl;
    @GuardedBy(value="acquireReleaseLock")
    private int zzm;
    @GuardedBy(value="acquireReleaseLock")
    com.google.android.gms.internal.stats.zzb zza;
    private Clock zzn;
    private WorkSource zzo;
    private final String zzp;
    private final String zzq;
    private final Context zzr;
    @GuardedBy(value="acquireReleaseLock")
    private final Map<String, zzc> zzs;
    private AtomicInteger zzt;
    private final ScheduledExecutorService zzu;

    static {
        Object object;
        zzb = TimeUnit.DAYS.toMillis(366L);
        zzc = null;
        zzd = object = new Object();
        zze = object = new zzb();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public WakeLock(@NonNull Context context, int levelAndFlags, @NonNull String wakeLockName) {
        Object[] objectArray;
        String string;
        Object object;
        Object object2;
        String string2 = context.getPackageName();
        this.zzf = object2 = new Object();
        this.zzh = 0;
        object2 = new HashSet();
        this.zzk = object2;
        this.zzl = true;
        this.zzn = DefaultClock.getInstance();
        this.zzs = object2;
        super(0);
        this.zzt = object2;
        Preconditions.checkNotNull((Object)object, (Object)"WakeLock: context must not be null");
        Preconditions.checkNotEmpty((String)string, (Object)"WakeLock: wakeLockName must not be empty");
        this.zzr = object.getApplicationContext();
        this.zzq = string;
        this.zza = null;
        if (!"com.google.android.gms".equals(object.getPackageName())) {
            object2 = String.valueOf(string);
            objectArray = "*gcore*:";
            object2 = ((String)object2).length() != 0 ? objectArray.concat((String)object2) : new String((String)objectArray);
            this.zzp = object2;
        } else {
            this.zzp = string;
        }
        object2 = (PowerManager)object.getSystemService("power");
        objectArray = new Object[]{};
        if (object2 != null) {
            void var2_4;
            this.zzg = object2.newWakeLock((int)var2_4, string);
            if (WorkSourceUtil.hasWorkSourcePermission((Context)object)) {
                String string3 = Strings.isEmptyOrWhitespace((String)string2) ? object.getPackageName() : string2;
                this.zzo = WorkSourceUtil.fromPackage((Context)object, (String)string3);
                object = this.zzo;
                if (object != null) {
                    WakeLock.zze(this.zzg, (WorkSource)object);
                }
            }
            if ((object = zzc) == null) {
                Object object3 = zzd;
                synchronized (object3) {
                    object = zzc;
                    if (object == null) {
                        com.google.android.gms.internal.stats.zzh.zza();
                        zzc = object = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(1));
                    }
                }
            }
            this.zzu = object;
            return;
        }
        int n = 0;
        while (true) {
            if (n >= 0) {
                StringBuilder stringBuilder = new StringBuilder(29);
                stringBuilder.append("expected a non-null reference", 0, 29);
                zzi zzi2 = new zzi(stringBuilder.toString());
                throw zzi2;
            }
            object = objectArray[n];
            if (object == null) {
                object = "null";
            } else {
                try {
                    string = object.toString();
                    object = string;
                }
                catch (Exception exception) {
                    object2 = object.getClass().getName();
                    object = Integer.toHexString(System.identityHashCode(object));
                    string2 = String.valueOf(object2);
                    int n2 = string2.length();
                    Object object4 = String.valueOf(object);
                    int n3 = ((String)object4).length();
                    CharSequence charSequence = new StringBuilder(n2 + 1 + n3);
                    ((StringBuilder)charSequence).append((String)object2);
                    ((StringBuilder)charSequence).append('@');
                    ((StringBuilder)charSequence).append((String)object);
                    object2 = ((StringBuilder)charSequence).toString();
                    Object object5 = Logger.getLogger("com.google.common.base.Strings");
                    object4 = Level.WARNING;
                    object = String.valueOf(object2);
                    charSequence = "Exception during lenientFormat for ";
                    object = ((String)object).length() != 0 ? ((String)charSequence).concat((String)object) : new String((String)charSequence);
                    ((Logger)object5).logp((Level)object4, "com.google.common.base.Strings", "lenientToString", (String)object, exception);
                    object = exception.getClass().getName();
                    String string4 = String.valueOf(object2);
                    int n4 = string4.length();
                    object5 = String.valueOf(object);
                    int n5 = ((String)object5).length();
                    object4 = new StringBuilder(n4 + 9 + n5);
                    ((StringBuilder)object4).append("<");
                    ((StringBuilder)object4).append((String)object2);
                    ((StringBuilder)object4).append(" threw ");
                    ((StringBuilder)object4).append((String)object);
                    ((StringBuilder)object4).append(">");
                    object = ((StringBuilder)object4).toString();
                }
            }
            objectArray[n] = object;
            ++n;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public void acquire(long timeout) {
        void var1_2;
        this.zzt.incrementAndGet();
        long l = Math.max(Math.min(Long.MAX_VALUE, zzb), 1L);
        if (var1_2 > 0L) {
            l = Math.min((long)var1_2, l);
        }
        Object object = this.zzf;
        synchronized (object) {
            boolean bl = this.isHeld();
            if (!bl) {
                this.zza = com.google.android.gms.internal.stats.zzb.zza(false, null);
                this.zzg.acquire();
                this.zzn.elapsedRealtime();
            }
            ++this.zzh;
            ++this.zzm;
            this.zzb(null);
            Future future = this.zzs.get(null);
            if (future == null) {
                future = new zzc(null);
                this.zzs.put(null, (zzc)((Object)future));
            }
            ++((zzc)((Object)future)).zza;
            long l2 = this.zzn.elapsedRealtime();
            long l3 = Long.MAX_VALUE - l2 > l ? l2 + l : Long.MAX_VALUE;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
            {
                long l4 = this.zzj;
                if (l3 <= l4) return;
                this.zzj = l3;
                future = this.zzi;
                if (future != null) {
                    future.cancel(false);
                }
                future = this.zzu;
                zza zza2 = new zza(this);
                this.zzi = future.schedule(zza2, l, TimeUnit.MILLISECONDS);
                return;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public void release() {
        if (this.zzt.decrementAndGet() < 0) {
            Log.e((String)"WakeLock", (String)String.valueOf(this.zzp).concat(" release without a matched acquire!"));
        }
        Object object = this.zzf;
        synchronized (object) {
            block9: {
                block8: {
                    this.zzb(null);
                    boolean bl = this.zzs.containsKey(null);
                    if (!bl) break block8;
                    zzc zzc2 = this.zzs.get(null);
                    if (zzc2 != null) {
                        int n = zzc2.zza;
                        zzc2.zza = --n;
                        if (n == 0) {
                            this.zzs.remove(null);
                        }
                    }
                    break block9;
                }
                Log.w((String)"WakeLock", (String)String.valueOf(this.zzp).concat(" counter does not exist"));
            }
            this.zzd(0);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public void setReferenceCounted(boolean value) {
        Object object = this.zzf;
        synchronized (object) {
            void var1_2;
            this.zzl = var1_2;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public boolean isHeld() {
        Object object = this.zzf;
        synchronized (object) {
            boolean bl = this.zzh;
            if (bl <= false) return false;
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @GuardedBy(value="acquireReleaseLock")
    private final String zzb(String string) {
        if (this.zzl && !TextUtils.isEmpty(null)) {
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static /* synthetic */ void zza(@NonNull WakeLock wakeLock) {
        Object object = wakeLock.zzf;
        synchronized (object) {
            boolean bl = wakeLock.isHeld();
            if (!bl) {
                return;
            }
            Log.e((String)"WakeLock", (String)String.valueOf(wakeLock.zzp).concat(" ** IS FORCE-RELEASED ON TIMEOUT **"));
            wakeLock.zzc();
            bl = wakeLock.isHeld();
            if (!bl) {
                return;
            }
            wakeLock.zzh = 1;
            wakeLock.zzd(0);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @GuardedBy(value="acquireReleaseLock")
    private final void zzc() {
        if (this.zzk.isEmpty()) {
            return;
        }
        ArrayList<zze> arrayList = new ArrayList<zze>(this.zzk);
        this.zzk.clear();
        if (arrayList.size() > 0) {
            zze cfr_ignored_0 = (zze)arrayList.get(0);
            throw null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void zzd(int n) {
        Throwable throwable2;
        boolean bl;
        Object object = this.zzf;
        // MONITORENTER : object
        int n2 = this.isHeld();
        if (n2 == 0) {
            // MONITOREXIT : object
            return;
        }
        n2 = this.zzl;
        if (n2 != 0) {
            n2 = this.zzh;
            this.zzh = --n2;
            if (n2 > 0) {
                // MONITOREXIT : object
                return;
            }
        } else {
            this.zzh = 0;
        }
        this.zzc();
        Object object2 = this.zzs.values().iterator();
        while (bl = object2.hasNext()) {
            object2.next().zza = 0;
        }
        this.zzs.clear();
        object2 = this.zzi;
        if (object2 != null) {
            object2.cancel(false);
            this.zzi = null;
            this.zzj = 0L;
        }
        this.zzm = 0;
        boolean bl2 = this.zzg.isHeld();
        if (!bl2) {
            Log.e((String)"WakeLock", (String)String.valueOf(this.zzp).concat(" should be held!"));
            return;
        }
        try {
            this.zzg.release();
            com.google.android.gms.internal.stats.zzb zzb2 = this.zza;
            if (zzb2 == null) return;
            this.zza = null;
            return;
        }
        catch (RuntimeException runtimeException) {
            block19: {
                block20: {
                    bl = runtimeException.getClass().equals(RuntimeException.class);
                    if (!bl) break block19;
                    Log.e((String)"WakeLock", (String)String.valueOf(this.zzp).concat(" failed to release!"), (Throwable)runtimeException);
                    com.google.android.gms.internal.stats.zzb zzb3 = this.zza;
                    if (zzb3 == null) break block20;
                    this.zza = null;
                    return;
                }
                // MONITOREXIT : object
                return;
            }
            try {
                throw runtimeException;
            }
            catch (Throwable throwable2) {
                com.google.android.gms.internal.stats.zzb zzb4 = this.zza;
                if (zzb4 == null) throw throwable2;
            }
        }
        this.zza = null;
        throw throwable2;
    }

    private static void zze(PowerManager.WakeLock wakeLock, WorkSource workSource) {
        try {
            wakeLock.setWorkSource(workSource);
            return;
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException runtimeException) {
            Log.wtf((String)"WakeLock", (String)runtimeException.toString());
            return;
        }
    }
}

