/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk.notification;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.service.notification.StatusBarNotification;
import android.text.TextUtils;
import com.heytap.mcssdk.PushService;
import com.heytap.mcssdk.notification.NotificationHelper;
import com.heytap.mcssdk.statis.McsStatisticUtils;
import com.heytap.msp.push.HeytapPushManager;
import com.heytap.msp.push.mode.DataMessage;
import com.heytap.msp.push.mode.NotificationSortMessage;
import com.heytap.msp.push.notification.ISortListener;
import com.heytap.msp.push.notification.PushNotification;
import com.heytap.msp.push.statis.StatisticUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PushNotificationSortManager {
    private int keepNumber = 3;
    private List<NotificationSortMessage> canDeleteList = new ArrayList<NotificationSortMessage>();
    private int highSize;
    private int normalSize;
    private List<String> deleteList = new ArrayList<String>();
    private int canDelete;
    private int notDelete;

    public void startBuild(PushNotification.Builder builder, ISortListener listener) {
        if (builder == null) {
            return;
        }
        boolean needPost = this.doTask(builder, builder.getAutoDelete(), builder.getImportantLevel(), builder.getMessageId(), builder.getStatisticData());
        this.callbackListener(listener, needPost, builder);
    }

    private boolean doTask(PushNotification.Builder builder, int autoDelete, int importantLevel, String messageId, String statisticData) {
        NotificationSortMessage currentMessage;
        Context context = PushService.getInstance().getContext();
        if (builder == null || context == null) {
            return false;
        }
        NotificationManager nm = NotificationHelper.getNotificationManager(context);
        if (!this.judgeMessageNeedDoAntiDeleteAndAntiFolderLogic(context, nm, currentMessage = new NotificationSortMessage(messageId, importantLevel, autoDelete, false, System.currentTimeMillis(), statisticData), builder)) {
            return true;
        }
        this.dealShowedNotificationList(nm, context);
        return this.dealCurrentMessage(nm, context, builder, currentMessage);
    }

    private void callbackListener(ISortListener listener, boolean needPost, PushNotification.Builder builder) {
        if (listener != null) {
            listener.buildCompleted(needPost, builder, this.deleteList);
        }
    }

    private boolean dealCurrentMessage(NotificationManager nm, Context context, PushNotification.Builder builder, NotificationSortMessage currentMessage) {
        boolean needPost;
        if (this.canDelete + this.notDelete < this.keepNumber) {
            if (currentMessage.getAutoDelete() == -1) {
                currentMessage.setGroup("mcs." + context.getPackageName());
            } else {
                currentMessage.setGroup("mcs.enable." + context.getPackageName());
            }
            needPost = true;
        } else if (currentMessage.getAutoDelete() == -1) {
            currentMessage.setGroup("mcs." + context.getPackageName());
            int allowDelete = this.keepNumber - this.notDelete;
            if (allowDelete > 0) {
                this.deleteLowestMessage(context, nm, allowDelete - 1);
            } else {
                Notification group = NotificationHelper.createDefaultGroupNotification(context, currentMessage.getGroup(), builder);
                if (group != null) {
                    nm.notify(4096, group);
                }
            }
            needPost = true;
        } else {
            needPost = this.judgeShowCurrentMessage(context, nm, currentMessage);
        }
        if (needPost) {
            this.doMessageConfig(builder, currentMessage);
        } else {
            DataMessage dataMessage = this.createDataMessage(context, currentMessage);
            McsStatisticUtils.statisticEvent(context, "push_no_show_by_fold", dataMessage);
        }
        return needPost;
    }

    private boolean judgeShowCurrentMessage(Context context, NotificationManager nm, NotificationSortMessage currentMessage) {
        boolean needPosted;
        if (this.notDelete >= this.keepNumber) {
            return false;
        }
        int allowDelete = this.keepNumber - this.notDelete;
        if (currentMessage.getImportantLevel() == 7) {
            needPosted = true;
        } else if (currentMessage.getImportantLevel() == 5) {
            needPosted = this.highSize < allowDelete;
        } else {
            boolean bl = needPosted = this.highSize + this.normalSize < allowDelete;
        }
        if (needPosted) {
            this.deleteLowestMessage(context, nm, allowDelete - 1);
        }
        return needPosted;
    }

    private void deleteLowestMessage(Context context, NotificationManager nm, int allowDelete) {
        this.keepMessage(this.canDeleteList, allowDelete);
        this.sendCommandOrStatic(context, nm, this.canDeleteList);
    }

    private void sendCommandOrStatic(Context context, NotificationManager nm, List<NotificationSortMessage> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        JSONObject root = new JSONObject();
        JSONArray array = new JSONArray();
        ArrayList<DataMessage> staticList = new ArrayList<DataMessage>();
        this.deleteNotification(context, nm, array, list, staticList);
        if (array.length() != 0) {
            try {
                root.put("SORT_ARRAY", (Object)array);
                HeytapPushManager.cancelNotification(root);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (staticList.size() != 0) {
            HashMap<String, List<DataMessage>> map = new HashMap<String, List<DataMessage>>();
            map.put("push_delete_by_fold", staticList);
            StatisticUtils.statisticEvent(context, map);
        }
    }

    private void deleteNotification(Context context, NotificationManager nm, JSONArray array, List<NotificationSortMessage> dataList, List<DataMessage> staticList) {
        for (NotificationSortMessage message : dataList) {
            if (message.isMcs()) {
                try {
                    JSONObject object = new JSONObject();
                    object.put("EXTRA_MESSAGE_ID", (Object)message.getMessageId());
                    object.put("EXTRA_NOTIFY_ID", message.getNotifyId());
                    array.put((Object)object);
                }
                catch (JSONException object) {}
            } else {
                DataMessage dataMessage = this.createDataMessage(context, message);
                staticList.add(dataMessage);
                this.deleteList.add(message.getMessageId());
            }
            nm.cancel(message.getNotifyId());
        }
    }

    private DataMessage createDataMessage(Context context, NotificationSortMessage message) {
        DataMessage dataMessage = new DataMessage(context.getPackageName(), message.getMessageId());
        try {
            JSONObject root = new JSONObject();
            root.put("isMcs", (Object)"false");
            String statisticData = message.getStatisticData();
            if (!TextUtils.isEmpty((CharSequence)statisticData)) {
                root.put("clientStatisticData", (Object)statisticData);
            }
            dataMessage.setStatisticsExtra(root.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return dataMessage;
    }

    private int keepMessage(List<NotificationSortMessage> list, int keepNumber) {
        int listSize;
        int n = listSize = list == null ? 0 : list.size();
        if (keepNumber <= 0 || listSize == 0) {
            return keepNumber;
        }
        if (listSize < keepNumber) {
            list.clear();
            return keepNumber -= listSize;
        }
        for (int i = 0; i < keepNumber; ++i) {
            list.remove(listSize - 1 - i);
        }
        return 0;
    }

    private void dealShowedNotificationList(NotificationManager nm, Context context) {
        StatusBarNotification[] statusBarNotifications = NotificationHelper.getActiveNotifications(nm, context.getPackageName());
        this.initParams(statusBarNotifications);
    }

    private void initParams(StatusBarNotification[] statusBarNotifications) {
        this.resetParams();
        if (statusBarNotifications != null && statusBarNotifications.length != 0) {
            for (StatusBarNotification statusBarNotification : statusBarNotifications) {
                Bundle extras = statusBarNotification.getNotification().extras;
                boolean isMcs = extras.getBoolean("EXTRA_IS_MCS", true);
                long postTime = extras.getLong("EXTRA_POST_TIME", statusBarNotification.getPostTime());
                String messageId = extras.getString("EXTRA_MESSAGE_ID", "");
                int autoDelete = extras.getInt("EXTRA_AUTO_DELETE", 1);
                int importantLevel = extras.getInt("EXTRA_IMPORTANT_LEVEL", 7);
                String statisticData = extras.getString("EXTRA_STATISTIC_DATA");
                int notifyId = statusBarNotification.getId();
                NotificationSortMessage message = new NotificationSortMessage(messageId, importantLevel, autoDelete, isMcs, postTime, notifyId, statisticData);
                this.initCanDeleteAndNotDelete(autoDelete);
                this.initHighAndNormalSize(importantLevel);
                this.initList(message);
            }
        }
    }

    private void initHighAndNormalSize(int importantLevel) {
        if (importantLevel == 7) {
            ++this.highSize;
        } else if (importantLevel == 5) {
            ++this.normalSize;
        }
    }

    private void initList(NotificationSortMessage message) {
        int autoDelete = message.getAutoDelete();
        if (autoDelete != 1) {
            return;
        }
        if (this.canDeleteList.size() != 0) {
            for (int i = this.canDeleteList.size() - 1; i >= 0; --i) {
                NotificationSortMessage sortMessage = this.canDeleteList.get(i);
                if (message.getImportantLevel() < sortMessage.getImportantLevel() || message.getPostTime() < sortMessage.getPostTime()) continue;
                this.canDeleteList.add(i + 1, sortMessage);
                return;
            }
        }
        this.canDeleteList.add(0, message);
    }

    private void resetParams() {
        this.canDelete = 0;
        this.notDelete = 0;
        this.highSize = 0;
        this.normalSize = 0;
        this.canDeleteList.clear();
        this.deleteList.clear();
    }

    private void initCanDeleteAndNotDelete(int autoDelete) {
        if (autoDelete == -1) {
            ++this.notDelete;
        } else if (autoDelete == 1) {
            ++this.canDelete;
        }
    }

    public boolean judgeMessageNeedDoAntiDeleteAndAntiFolderLogic(Context context, NotificationManager nm, NotificationSortMessage currentMessage, PushNotification.Builder builder) {
        if (currentMessage.getAutoDelete() == 0) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 24 || Build.VERSION.SDK_INT >= 30) {
            return false;
        }
        if (NotificationHelper.isExistNotificationsByPkgAndId(nm, context.getPackageName(), 4096)) {
            currentMessage.setGroup("mcs." + context.getPackageName());
            this.doMessageConfig(builder, currentMessage);
            return false;
        }
        return true;
    }

    private void doMessageConfig(PushNotification.Builder builder, NotificationSortMessage currentMessage) {
        Bundle extras = new Bundle();
        extras.putInt("EXTRA_AUTO_DELETE", currentMessage.getAutoDelete());
        extras.putInt("EXTRA_IMPORTANT_LEVEL", currentMessage.getImportantLevel());
        extras.putString("EXTRA_MESSAGE_ID", currentMessage.getMessageId());
        extras.putLong("EXTRA_POST_TIME", System.currentTimeMillis());
        extras.putBoolean("EXTRA_IS_MCS", false);
        extras.putString("EXTRA_STATISTIC_DATA", currentMessage.getStatisticData());
        if (Build.VERSION.SDK_INT >= 20) {
            builder.addExtras(extras);
            builder.setGroup(currentMessage.getGroup());
        }
    }

    public static PushNotificationSortManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        private static final PushNotificationSortManager INSTANCE = new PushNotificationSortManager();

        private SingletonHolder() {
        }
    }
}

