/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.firebase.transport;

import com.google.android.datatransport.runtime.ProtoEncoderDoNotUse;
import com.google.android.datatransport.runtime.firebase.transport.GlobalMetrics;
import com.google.android.datatransport.runtime.firebase.transport.LogSourceMetrics;
import com.google.android.datatransport.runtime.firebase.transport.TimeWindow;
import com.google.firebase.encoders.annotations.Encodable;
import com.google.firebase.encoders.proto.Protobuf;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ClientMetrics {
    private static final ClientMetrics DEFAULT_INSTANCE = new Builder().build();
    private final TimeWindow window_;
    private final List<LogSourceMetrics> log_source_metrics_;
    private final GlobalMetrics global_metrics_;
    private final String app_namespace_;

    ClientMetrics(TimeWindow window_, List<LogSourceMetrics> log_source_metrics_, GlobalMetrics global_metrics_, String app_namespace_) {
        this.window_ = window_;
        this.log_source_metrics_ = log_source_metrics_;
        this.global_metrics_ = global_metrics_;
        this.app_namespace_ = app_namespace_;
    }

    public byte[] toByteArray() {
        return ProtoEncoderDoNotUse.encode(this);
    }

    public void writeTo(OutputStream output) throws IOException {
        ProtoEncoderDoNotUse.encode(this, output);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Encodable.Ignore
    public TimeWindow getWindow() {
        return this.window_ == null ? TimeWindow.getDefaultInstance() : this.window_;
    }

    @Encodable.Field(name="window")
    @Protobuf(tag=1)
    public TimeWindow getWindowInternal() {
        return this.window_;
    }

    @Encodable.Field(name="logSourceMetrics")
    @Protobuf(tag=2)
    public List<LogSourceMetrics> getLogSourceMetricsList() {
        return this.log_source_metrics_;
    }

    @Encodable.Ignore
    public GlobalMetrics getGlobalMetrics() {
        return this.global_metrics_ == null ? GlobalMetrics.getDefaultInstance() : this.global_metrics_;
    }

    @Encodable.Field(name="globalMetrics")
    @Protobuf(tag=3)
    public GlobalMetrics getGlobalMetricsInternal() {
        return this.global_metrics_;
    }

    @Protobuf(tag=4)
    public String getAppNamespace() {
        return this.app_namespace_;
    }

    public static ClientMetrics getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder {
        private TimeWindow window_ = null;
        private List<LogSourceMetrics> log_source_metrics_ = new ArrayList<LogSourceMetrics>();
        private GlobalMetrics global_metrics_ = null;
        private String app_namespace_ = "";

        Builder() {
        }

        public ClientMetrics build() {
            return new ClientMetrics(this.window_, Collections.unmodifiableList(this.log_source_metrics_), this.global_metrics_, this.app_namespace_);
        }

        public Builder setWindow(TimeWindow window_) {
            this.window_ = window_;
            return this;
        }

        public Builder addLogSourceMetrics(LogSourceMetrics log_source_metrics_) {
            this.log_source_metrics_.add(log_source_metrics_);
            return this;
        }

        public Builder setLogSourceMetricsList(List<LogSourceMetrics> log_source_metrics_) {
            this.log_source_metrics_ = log_source_metrics_;
            return this;
        }

        public Builder setGlobalMetrics(GlobalMetrics global_metrics_) {
            this.global_metrics_ = global_metrics_;
            return this;
        }

        public Builder setAppNamespace(String app_namespace_) {
            this.app_namespace_ = app_namespace_;
            return this;
        }
    }
}

