/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.logging;

import android.os.Build;
import android.util.Log;

public final class Logging {
    private static final String LOG_PREFIX = "TRuntime.";
    private static final int MAX_LOG_TAG_SIZE_IN_SDK_N = 23;

    private Logging() {
    }

    private static String getTag(String tag) {
        if (Build.VERSION.SDK_INT < 24) {
            return Logging.concatTag(LOG_PREFIX, tag);
        }
        return LOG_PREFIX + tag;
    }

    private static String concatTag(String prefix, String tag) {
        String concatText = prefix + tag;
        if (concatText.length() > 23) {
            concatText = concatText.substring(0, 23);
        }
        return concatText;
    }

    public static void d(String tag, String message) {
        if (Log.isLoggable((String)(tag = Logging.getTag(tag)), (int)3)) {
            Log.d((String)tag, (String)message);
        }
    }

    public static void d(String tag, String message, Object arg1) {
        if (Log.isLoggable((String)(tag = Logging.getTag(tag)), (int)3)) {
            Log.d((String)tag, (String)String.format(message, arg1));
        }
    }

    public static void d(String tag, String message, Object arg1, Object arg2) {
        if (Log.isLoggable((String)(tag = Logging.getTag(tag)), (int)3)) {
            Log.d((String)tag, (String)String.format(message, arg1, arg2));
        }
    }

    public static void d(String tag, String message, Object ... args) {
        if (Log.isLoggable((String)(tag = Logging.getTag(tag)), (int)3)) {
            Log.d((String)tag, (String)String.format(message, args));
        }
    }

    public static void i(String tag, String message, Object arg1) {
        if (Log.isLoggable((String)(tag = Logging.getTag(tag)), (int)4)) {
            Log.i((String)tag, (String)String.format(message, arg1));
        }
    }

    public static void e(String tag, String message, Throwable e) {
        if (Log.isLoggable((String)(tag = Logging.getTag(tag)), (int)6)) {
            Log.e((String)tag, (String)message, (Throwable)e);
        }
    }

    public static void w(String tag, String message, Object arg1) {
        if (Log.isLoggable((String)(tag = Logging.getTag(tag)), (int)5)) {
            Log.w((String)tag, (String)String.format(message, arg1));
        }
    }
}

