/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common.internal;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.huawei.hms.common.HuaweiApi;
import com.huawei.hms.common.internal.AnyClient;
import com.huawei.hms.common.internal.BaseHmsClient;
import com.huawei.hms.core.aidl.IAIDLInvoke;
import com.huawei.hms.support.log.HMSLog;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class RequestManager
implements Handler.Callback {
    private static final String TAG = "RequestManager";
    public static final int NOTIFY_CONNECT_SUCCESS = 10011;
    public static final int NOTIFY_CONNECT_FAILED = 10012;
    public static final int NOTIFY_CONNECT_SUSPENDED = 10013;
    private static final Object LOCK_OBJECT = new Object();
    private static volatile RequestManager mInstance;
    private static Handler mHandler;
    private static Queue<HuaweiApi.RequestHandler> requestQueue;
    private static Map<String, HuaweiApi.RequestHandler> connectedReqMap;

    private RequestManager(Looper looper) {
        mHandler = new Handler(looper, (Handler.Callback)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static RequestManager getInstance() {
        HandlerThread handlerThread;
        Object object = LOCK_OBJECT;
        // MONITORENTER : object
        if (mInstance != null) return mInstance;
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread(TAG).start();
        mInstance = new RequestManager(handlerThread2.getLooper());
        // MONITOREXIT : object
        return mInstance;
    }

    public static void addRequestToQueue(HuaweiApi.RequestHandler requestHandler) {
        requestQueue.add(requestHandler);
    }

    public static void addToConnectedReqMap(final String string, final HuaweiApi.RequestHandler requestHandler) {
        if (mHandler == null) {
            return;
        }
        HMSLog.i((String)TAG, (String)"addToConnectedReqMap");
        mHandler.post(new Runnable(){

            @Override
            public void run() {
                connectedReqMap.put(string, requestHandler);
            }
        });
    }

    public static void removeReqByTransId(final String string) {
        if (mHandler == null) {
            return;
        }
        HMSLog.i((String)TAG, (String)"removeReqByTransId");
        mHandler.post(new Runnable(){

            @Override
            public void run() {
                connectedReqMap.remove(string);
            }
        });
    }

    public static Handler getHandler() {
        return mHandler;
    }

    private void handleConnectSuspend() {
        HMSLog.i((String)TAG, (String)"NOTIFY_CONNECT_SUSPENDED.");
        while (!requestQueue.isEmpty()) {
            requestQueue.poll().onConnectionSuspended(1);
        }
        this.notifyRunningRequestConnectSuspend();
    }

    private void handleConnectFailed(Message object) {
        HMSLog.i((String)TAG, (String)"NOTIFY_CONNECT_FAILED.");
        BaseHmsClient.ConnectionResultWrapper connectionResultWrapper = (BaseHmsClient.ConnectionResultWrapper)object.obj;
        object = connectionResultWrapper.getRequest();
        BaseHmsClient.ConnectionResultWrapper connectionResultWrapper2 = connectionResultWrapper;
        requestQueue.remove(object);
        try {
            object.onConnectionFailed(connectionResultWrapper2.getConnectionResult());
        }
        catch (RuntimeException runtimeException) {
            HMSLog.e((String)TAG, (String)("<handleConnectFailed> handle Failed" + runtimeException.getMessage()));
        }
    }

    private void handleConnectSuccess() {
        while (!requestQueue.isEmpty()) {
            AnyClient anyClient;
            HuaweiApi.RequestHandler requestHandler = requestQueue.poll();
            if (requestHandler == null || !((anyClient = requestHandler.getClient()) instanceof BaseHmsClient)) continue;
            BaseHmsClient baseHmsClient = (BaseHmsClient)((Object)anyClient);
            baseHmsClient.setService(IAIDLInvoke.Stub.asInterface(baseHmsClient.getAdapter().getServiceBinder()));
            requestHandler.onConnected();
        }
    }

    private void notifyRunningRequestConnectSuspend() {
        HMSLog.i((String)TAG, (String)("notifyRunningRequestConnectSuspend, connectedReqMap.size(): " + connectedReqMap.size()));
        Iterator<Map.Entry<String, HuaweiApi.RequestHandler>> iterator = connectedReqMap.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                ((HuaweiApi.RequestHandler)((Map.Entry)iterator.next()).getValue()).onConnectionSuspended(1);
            }
            catch (RuntimeException runtimeException) {
                HMSLog.e((String)TAG, (String)("NOTIFY_CONNECT_SUSPENDED Exception: " + runtimeException.getMessage()));
            }
            iterator.remove();
        }
    }

    static {
        requestQueue = new ConcurrentLinkedQueue<HuaweiApi.RequestHandler>();
        connectedReqMap = new LinkedHashMap<String, HuaweiApi.RequestHandler>();
    }

    public boolean handleMessage(Message message) {
        if (message == null) {
            return false;
        }
        HMSLog.i((String)TAG, (String)"RequestManager handleMessage.");
        switch (message.what) {
            default: {
                HMSLog.i((String)TAG, (String)("handleMessage unknown msg:" + message.what));
                return false;
            }
            case 10013: {
                this.handleConnectSuspend();
                return true;
            }
            case 10012: {
                this.handleConnectFailed(message);
                return true;
            }
            case 10011: 
        }
        this.handleConnectSuccess();
        return true;
    }
}

