/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.common.utils;

import com.engagelab.privates.common.log.MTCommonLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipUtil {
    private static final String TAG = "GZipUtil";

    public static byte[] zip(byte[] src) throws IOException {
        byte[] byArray;
        if (src != null && byArray.length != 0) {
            byte[] byArray2;
            GZIPOutputStream gZIPOutputStream;
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream2 = gZIPOutputStream;
            gZIPOutputStream2(byteArrayOutputStream2);
            try {
                ((OutputStream)gZIPOutputStream).write(byArray);
                ((OutputStream)gZIPOutputStream).close();
                byArray2 = byteArrayOutputStream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    MTCommonLog.w(TAG, "zip failed " + throwable.getMessage());
                }
                catch (Throwable throwable2) {
                    GZipUtil.closeQuietly(byteArrayOutputStream2);
                    GZipUtil.closeQuietly(gZIPOutputStream2);
                    throw throwable2;
                }
                GZipUtil.closeQuietly(byteArrayOutputStream2);
                GZipUtil.closeQuietly(gZIPOutputStream2);
                return null;
            }
            GZipUtil.closeQuietly(byteArrayOutputStream2);
            GZipUtil.closeQuietly(gZIPOutputStream2);
            return byArray2;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzip(byte[] src) throws IOException {
        byte[] byArray;
        GZIPInputStream gZIPInputStream;
        ByteArrayInputStream byteArrayInputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        Object object;
        if (src == null) return object;
        if (((byte[])object).length == 0) {
            return object;
        }
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        object = gZIPInputStream;
        gZIPInputStream = new GZIPInputStream(byteArrayInputStream2);
        try {
            int n2;
            byte[] byArray2 = new byte[256];
            while ((n2 = ((FilterInputStream)object).read(byArray2)) >= 0) {
                byteArrayOutputStream2.write(byArray2, 0, n2);
            }
            byArray = byteArrayOutputStream2.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                MTCommonLog.w(TAG, "unzip failed " + throwable.getMessage());
            }
            catch (Throwable throwable2) {
                GZipUtil.closeQuietly(byteArrayOutputStream2);
                GZipUtil.closeQuietly(byteArrayInputStream2);
                GZipUtil.closeQuietly((Closeable)object);
                throw throwable2;
            }
            GZipUtil.closeQuietly(byteArrayOutputStream2);
            GZipUtil.closeQuietly(byteArrayInputStream2);
            GZipUtil.closeQuietly((Closeable)object);
            return null;
        }
        GZipUtil.closeQuietly(byteArrayOutputStream2);
        GZipUtil.closeQuietly(byteArrayInputStream2);
        GZipUtil.closeQuietly((Closeable)object);
        return byArray;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                Closeable closeable2;
                closeable2.close();
            }
            catch (Throwable throwable) {
                MTCommonLog.w(TAG, "closeQuietly failed " + throwable.getMessage());
            }
        }
    }
}

