/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import com.huawei.hms.api.HuaweiApiAvailability;
import com.huawei.hms.common.internal.Objects;

public final class ConnectionResult
implements Parcelable {
    public static final int SUCCESS = 0;
    public static final int SERVICE_MISSING = 1;
    public static final int SERVICE_VERSION_UPDATE_REQUIRED = 2;
    public static final int SERVICE_DISABLED = 3;
    public static final int SIGN_IN_REQUIRED = 4;
    public static final int INVALID_ACCOUNT = 5;
    public static final int BINDFAIL_RESOLUTION_REQUIRED = 6;
    public static final int BINDFAIL_RESOLUTION_BACKGROUND = 7;
    public static final int INTERNAL_ERROR = 8;
    public static final int SERVICE_INVALID = 9;
    public static final int DEVELOPER_ERROR = 10;
    public static final int LICENSE_CHECK_FAILED = 11;
    public static final int CANCELED = 13;
    public static final int TIMEOUT = 14;
    public static final int SERVICE_MISSING_PERMISSION = 19;
    public static final int SERVICE_UNSUPPORTED = 21;
    public static final int API_UNAVAILABLE = 1000;
    public static final int DRIVE_EXTERNAL_STORAGE_REQUIRED = 9002;
    public static final int INTERRUPTED = 15;
    public static final int NETWORK_ERROR = 9000;
    public static final int RESOLUTION_REQUIRED = 9001;
    public static final int RESTRICTED_PROFILE = 9003;
    public static final int SERVICE_UPDATING = 9004;
    public static final int SIGN_IN_FAILED = 9005;
    public static final Parcelable.Creator<ConnectionResult> CREATOR = new Parcelable.Creator<ConnectionResult>(){

        public ConnectionResult createFromParcel(Parcel parcel) {
            return new ConnectionResult(parcel);
        }

        public ConnectionResult[] newArray(int n) {
            return new ConnectionResult[n];
        }
    };
    private int apiVersion = 1;
    private PendingIntent pendingIntent = null;
    private String connectionErrorMessage = null;
    private int connectionErrorCode;

    ConnectionResult(int n, int n2, PendingIntent pendingIntent, String string) {
        this.apiVersion = n;
        this.connectionErrorCode = n2;
        this.pendingIntent = pendingIntent;
        this.connectionErrorMessage = string;
    }

    public ConnectionResult(int n) {
        this(n, null);
    }

    public ConnectionResult(int n, PendingIntent pendingIntent) {
        this(n, pendingIntent, null);
    }

    public ConnectionResult(int n, PendingIntent pendingIntent, String string) {
        this(1, n, pendingIntent, string);
    }

    private ConnectionResult(Parcel parcel) {
        this.apiVersion = parcel.readInt();
        this.connectionErrorCode = parcel.readInt();
        this.connectionErrorMessage = parcel.readString();
        parcel = (Parcelable)PendingIntent.CREATOR.createFromParcel(parcel);
        if (parcel != null) {
            this.pendingIntent = (PendingIntent)parcel;
        }
    }

    static String getErrorString(int n) {
        switch (n) {
            default: {
                return "UNKNOWN_ERROR_CODE(" + n + ")";
            }
            case 21: {
                return "API_VERSION_UPDATE_REQUIRED";
            }
            case 19: {
                return "SERVICE_MISSING_PERMISSION";
            }
            case 14: {
                return "TIMEOUT";
            }
            case 13: {
                return "CANCELED";
            }
            case 11: {
                return "LICENSE_CHECK_FAILED";
            }
            case 10: {
                return "DEVELOPER_ERROR";
            }
            case 9: {
                return "SERVICE_INVALID";
            }
            case 8: {
                return "INTERNAL_ERROR";
            }
            case 7: {
                return "NETWORK_ERROR";
            }
            case 6: {
                return "RESOLUTION_REQUIRED";
            }
            case 3: {
                return "SERVICE_DISABLED";
            }
            case 2: {
                return "SERVICE_VERSION_UPDATE_REQUIRED";
            }
            case 1: {
                return "SERVICE_MISSING";
            }
            case 0: {
                return "SUCCESS";
            }
            case -1: 
        }
        return "UNKNOWN";
    }

    public int getErrorCode() {
        return this.connectionErrorCode;
    }

    public final String getErrorMessage() {
        return this.connectionErrorMessage;
    }

    public final boolean hasResolution() {
        return HuaweiApiAvailability.getInstance().isUserResolvableError(this.connectionErrorCode, this.pendingIntent);
    }

    public final PendingIntent getResolution() {
        return this.pendingIntent;
    }

    public final void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (this.hasResolution()) {
            HuaweiApiAvailability.getInstance().resolveError(activity, this.connectionErrorCode, n, this.pendingIntent);
        }
    }

    public final boolean isSuccess() {
        return this.connectionErrorCode == 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.apiVersion);
        parcel.writeInt(this.connectionErrorCode);
        parcel.writeString(this.connectionErrorMessage);
        this.pendingIntent.writeToParcel(parcel, n);
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl;
        block8: {
            block7: {
                if (this == object) {
                    return true;
                }
                try {
                    if (!(object instanceof ConnectionResult)) break block7;
                }
                catch (Exception exception) {
                    return false;
                }
                if (this.apiVersion != ((ConnectionResult)object).apiVersion) break block7;
                if (this.connectionErrorCode != ((ConnectionResult)object).connectionErrorCode) break block7;
                if (!this.connectionErrorMessage.equals(((ConnectionResult)object).connectionErrorMessage)) break block7;
                if (!this.pendingIntent.equals((Object)((ConnectionResult)object).pendingIntent)) break block7;
                bl = true;
                break block8;
            }
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = (long)this.apiVersion;
        objectArray2[1] = (long)this.getErrorCode();
        objectArray2[2] = this.getErrorMessage();
        objectArray[3] = this.pendingIntent;
        return Objects.hashCode((Object[])objectArray);
    }
}

