/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.oth.sound.util;

import android.content.Context;
import android.text.TextUtils;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.common.utils.Guard;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class FileUtil {
    private static final String TAG = "FiUt";
    private static String TRANSFORMATION = Guard.string((byte[])new byte[]{73, 83, 66, 31, 99, 91, 75, 57, 65, 123, 99, 74, 61, 70, 112, 84, 68, 112, 102, 113});
    private static String IV = Guard.string((byte[])new byte[]{33, 1, 16, 43, 56, 37, 33, 4, 16, 44, 56, 32, 33, 7, 16, 33});
    private static String AES = Guard.string((byte[])new byte[]{87, 84, 99});
    private static final int BUFFER_LENGTH = 8192;
    private static final String PLUGIN_ANALYTIC_PATH = "p_an";
    public static final String MD5 = Guard.string((byte[])new byte[]{91, 85, 5});
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String getInstance = Guard.string((byte[])new byte[]{87, 69, 109, 65, 120, 98, 68, 65, 119, 107, 115});
    public static final String MESSAGEDIGEST = Guard.string((byte[])new byte[]{124, 112, 70, 65, 55, 123, 115, 114, 69, 82, 112, 124, 111, 63, 125, 69, 106, 123, 119, 118, 85, 100, 112, 111, 115, 98, 68});
    private static HashMap<String, MessageDigest> digests = new HashMap();

    public static MessageDigest getMessageDigest(String type) {
        try {
            MessageDigest messageDigest;
            if (digests.containsKey(type) && (messageDigest = digests.get(type)) != null) {
                return messageDigest;
            }
            Class<?> messageDigestClass = Class.forName(MESSAGEDIGEST);
            Method getInstanceMethod = messageDigestClass.getMethod(getInstance, String.class);
            getInstanceMethod.setAccessible(true);
            Object mdInstance = getInstanceMethod.invoke(null, type);
            if (mdInstance instanceof MessageDigest) {
                MessageDigest md = (MessageDigest)mdInstance;
                digests.put(type, md);
                return md;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(HEX_DIGITS[(b[i] & 0xF0) >>> 4]);
            sb.append(HEX_DIGITS[b[i] & 0xF]);
        }
        return sb.toString();
    }

    public static String getFileHash(String filePath) {
        String sMD5 = "";
        InputStream inputStream = null;
        try {
            File file = new File(filePath);
            if (file != null) {
                MTCommonLog.d((String)TAG, (String)(filePath + "---- f ex = " + file.exists() + "  , l = " + file.length()));
            }
            inputStream = new FileInputStream(filePath);
            MessageDigest res = FileUtil.getMessageDigest(MD5);
            int len = 0;
            byte[] buffer = new byte[8192];
            while ((len = inputStream.read(buffer)) != -1) {
                res.update(buffer, 0, len);
            }
            inputStream.close();
            sMD5 = FileUtil.toHexString(res.digest());
        }
        catch (Exception e) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
        }
        MTCommonLog.d((String)TAG, (String)(filePath + "---- m = " + sMD5));
        return sMD5;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void saveToFileDir(Context context, String fileName, String content) {
        if (context == null) {
            return;
        }
        try {
            String filePath = context.getFilesDir() + File.separator + PLUGIN_ANALYTIC_PATH + File.separator + fileName;
            File file = new File(filePath);
            FileUtil.saveToFile(file, content);
        }
        catch (Throwable e) {
            MTCommonLog.e((String)TAG, (String)("saveToFileDir error:" + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToFile(File file, String content) {
        block9: {
            BufferedWriter writer;
            block8: {
                writer = null;
                if (!file.exists() || !TextUtils.isEmpty((CharSequence)content)) break block8;
                file.delete();
                FileUtil.closeQuietly(writer);
                return;
            }
            try {
                File parentFile = file.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                if (!file.exists()) {
                    file.createNewFile();
                }
                writer = new BufferedWriter(new FileWriter(file));
                writer.write(content);
                writer.flush();
            }
            catch (Throwable e) {
                try {
                    MTCommonLog.e((String)TAG, (String)("[saveToFile] error:" + e.getMessage()));
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    FileUtil.closeQuietly(writer);
                }
            }
            FileUtil.closeQuietly(writer);
        }
    }

    public static String getPluginBasePath(Context context) {
        return context.getFilesDir() + File.separator + PLUGIN_ANALYTIC_PATH;
    }

    public static String readFromFileDir(Context context, String fileName) {
        if (context == null) {
            return null;
        }
        try {
            String filePath = context.getFilesDir() + File.separator + PLUGIN_ANALYTIC_PATH + File.separator + fileName;
            File file = new File(filePath);
            return FileUtil.readFile(file);
        }
        catch (Throwable e) {
            MTCommonLog.e((String)TAG, (String)("[readFromFileDir] error:" + e.getMessage()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readFile(File file) {
        String string;
        BufferedReader reader;
        block5: {
            reader = null;
            if (file.exists()) break block5;
            String string2 = null;
            FileUtil.closeQuietly(reader);
            return string2;
        }
        try {
            String s;
            reader = new BufferedReader(new FileReader(file));
            string = s = reader.readLine();
        }
        catch (Throwable e) {
            try {
                MTCommonLog.e((String)TAG, (String)("[readFile] error:" + e.getMessage()));
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietly(reader);
                throw throwable;
            }
            FileUtil.closeQuietly(reader);
            return null;
        }
        FileUtil.closeQuietly(reader);
        return string;
    }

    public static void unzip(File zipFile, File outputFolder) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
        byte[] buffer = new byte[8192];
        while ((zipEntry = zis.getNextEntry()) != null) {
            File entryFile = new File(outputFolder, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                entryFile.mkdirs();
            } else {
                int length;
                new File(entryFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(entryFile);
                while ((length = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, length);
                }
                fos.close();
            }
            zis.closeEntry();
        }
        zis.close();
    }

    public static File aesDecrypt(File encrptyAudioFile, File tmpFile, String md5) throws IOException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        tmpFile.getParentFile().mkdirs();
        tmpFile.createNewFile();
        FileOutputStream outputStream = new FileOutputStream(tmpFile);
        FileInputStream fileInputStream = new FileInputStream(encrptyAudioFile);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(2, (Key)new SecretKeySpec(md5.getBytes("utf-8"), AES), new IvParameterSpec(IV.getBytes("utf-8")));
        CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, cipher);
        int isread = 0;
        byte[] cache = new byte[8192];
        while ((isread = fileInputStream.read(cache, 0, cache.length)) != -1) {
            cipherOutputStream.write(cache, 0, isread);
        }
        cipherOutputStream.close();
        return tmpFile;
    }
}

