/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.text.TextUtils;
import com.huawei.hms.framework.common.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ReflectionUtils {
    private static final String TAG = "ReflectionUtils";

    private static Object invoke(Object receiver, Method method, Object ... args) throws UnsupportedOperationException {
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(receiver, args);
        }
        catch (RuntimeException e) {
            Logger.e(TAG, "RuntimeException in invoke:", e);
        }
        catch (Exception e) {
            Logger.e(TAG, "Exception in invoke:", e);
        }
        return null;
    }

    public static Method getMethod(Class<?> targetClass, String name, Class<?> ... parameterTypes) {
        if (targetClass == null || name == null) {
            Logger.w(TAG, "targetClass is  null pr name is null:");
            return null;
        }
        try {
            return targetClass.getDeclaredMethod(name, parameterTypes);
        }
        catch (SecurityException e) {
            Logger.e(TAG, "SecurityException:", e);
        }
        catch (NoSuchMethodException e) {
            Logger.e(TAG, "NoSuchMethodException:", e);
        }
        return null;
    }

    private static void setClassType(Class<?>[] parameterType, Object parameterArg, int index) {
        parameterType[index] = parameterArg instanceof Integer ? Integer.TYPE : (parameterArg instanceof Long ? Long.TYPE : (parameterArg instanceof Double ? Double.TYPE : (parameterArg instanceof Float ? Float.TYPE : (parameterArg instanceof Boolean ? Boolean.TYPE : (parameterArg instanceof Character ? Character.TYPE : (parameterArg instanceof Byte ? Byte.TYPE : (parameterArg instanceof Void ? Void.TYPE : (parameterArg instanceof Short ? Short.TYPE : parameterArg.getClass()))))))));
    }

    public static Object invokeStaticMethod(String methodClassName, String methodName, Object ... parameterArgs) {
        Method targetMethod;
        Class[] parameterTypes = null;
        if (methodClassName == null) {
            return null;
        }
        if (parameterArgs != null) {
            int argsLength = parameterArgs.length;
            parameterTypes = new Class[argsLength];
            for (int i = 0; i < argsLength; ++i) {
                ReflectionUtils.setClassType(parameterTypes, parameterArgs[i], i);
            }
        }
        if ((targetMethod = ReflectionUtils.getMethod(ReflectionUtils.getClass(methodClassName), methodName, parameterTypes)) == null) {
            return null;
        }
        return ReflectionUtils.invoke(null, targetMethod, parameterArgs);
    }

    public static Object invokeStaticMethod(String methodClassName, String methodName, Class<?>[] parameterTypes, Object ... parameterArgs) {
        Method tagetMethod = ReflectionUtils.getMethod(ReflectionUtils.getClass(methodClassName), methodName, parameterTypes);
        if (tagetMethod == null) {
            return null;
        }
        return ReflectionUtils.invoke(null, tagetMethod, parameterArgs);
    }

    public static Object getFieldObj(Object source, String fieldName) {
        if (source == null || TextUtils.isEmpty((CharSequence)fieldName)) {
            return null;
        }
        Object returnObj = null;
        Class<?> targetClass = source.getClass();
        try {
            final Field field = targetClass.getDeclaredField(fieldName);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
            returnObj = field.get(source);
        }
        catch (IllegalAccessException e) {
            Logger.e(TAG, "Exception in getFieldObj :: IllegalAccessException:", e);
        }
        catch (IllegalArgumentException e) {
            Logger.e(TAG, "Exception in getFieldObj :: IllegalArgumentException:", e);
        }
        catch (NoSuchFieldException e) {
            Logger.e(TAG, "Exception in getFieldObj :: NoSuchFieldException:", e);
        }
        catch (SecurityException e) {
            Logger.e(TAG, "not security int method getFieldObj,SecurityException:", e);
        }
        return returnObj;
    }

    public static Field getField(Object source, String fieldName) {
        if (source == null || TextUtils.isEmpty((CharSequence)fieldName)) {
            return null;
        }
        Class<?> targetClass = source.getClass();
        try {
            final Field field = targetClass.getDeclaredField(fieldName);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
            return field;
        }
        catch (IllegalArgumentException e) {
            Logger.e(TAG, "Exception in getField :: IllegalArgumentException:", e);
        }
        catch (NoSuchFieldException e) {
            Logger.e(TAG, "Exception in getField :: NoSuchFieldException:", e);
        }
        catch (SecurityException e) {
            Logger.e(TAG, "not security int method getField,SecurityException:", e);
        }
        return null;
    }

    public static Object getStaticFieldObj(String targetClassName, String fieldName) {
        Object returnObj = null;
        if (targetClassName == null) {
            return null;
        }
        Class<?> targetClass = ReflectionUtils.getClass(targetClassName);
        if (targetClass == null || TextUtils.isEmpty((CharSequence)fieldName)) {
            return null;
        }
        try {
            final Field field = targetClass.getDeclaredField(fieldName);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
            returnObj = field.get(targetClass);
        }
        catch (IllegalAccessException e) {
            Logger.e(TAG, "Exception in getFieldObj :: IllegalAccessException:", e);
        }
        catch (IllegalArgumentException e) {
            Logger.e(TAG, "Exception in getFieldObj :: IllegalArgumentException:", e);
        }
        catch (NoSuchFieldException e) {
            Logger.e(TAG, "Exception in getFieldObj :: NoSuchFieldException:", e);
        }
        catch (SecurityException e) {
            Logger.e(TAG, "not security int method getStaticFieldObj,SecurityException:", e);
        }
        return returnObj;
    }

    public static boolean checkCompatible(String className) {
        try {
            ReflectionUtils.tryLoadClass(className);
        }
        catch (Exception e) {
            Logger.w(TAG, className + "ClassNotFoundException");
            return false;
        }
        return true;
    }

    public static boolean checkCompatible(String className, String methodName, Class<?> ... parameterTypes) {
        try {
            if (className == null || methodName == null) {
                Logger.w(TAG, "targetClass is  null or name is null:");
                return false;
            }
            Class<?> targetClass = Class.forName(className);
            targetClass.getDeclaredMethod(methodName, parameterTypes);
            Logger.v(TAG, "has method : " + methodName);
            return true;
        }
        catch (RuntimeException e) {
            Logger.w(TAG, className + " RuntimeException");
        }
        catch (Exception e) {
            Logger.w(TAG, methodName + " NoSuchMethodException");
        }
        return false;
    }

    private static void tryLoadClass(String className) throws ClassNotFoundException {
        ClassLoader cl = ReflectionUtils.class.getClassLoader();
        if (cl == null) {
            throw new ClassNotFoundException("not found classloader");
        }
        cl.loadClass(className);
    }

    private static Class<?> getClass(String loadClassName) {
        if (loadClassName == null) {
            return null;
        }
        try {
            return Class.forName(loadClassName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

