/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common.hianalytics;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import com.huawei.hianalytics.process.HiAnalyticsInstance;
import com.huawei.hianalytics.process.HiAnalyticsManager;
import com.huawei.hms.framework.common.ContextHolder;
import com.huawei.hms.framework.common.ExecutorsUtils;
import com.huawei.hms.framework.common.Logger;
import com.huawei.hms.framework.common.StringUtils;
import com.huawei.hms.framework.common.hianalytics.CrashHianalyticsData;
import com.huawei.hms.framework.common.hianalytics.HianalyticsBaseData;
import com.huawei.hms.support.hianalytics.HiAnalyticsUtils;
import com.huawei.hms.utils.HMSBIInitializer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

public class HianalyticsHelper {
    private static final String TAG = "HianalyticsHelper";
    private static final String HWID_HA_SERVICE_TAG = "hms_hwid";
    private static final String DEAULT_HA_SERVICE_TAG = "_default_config_tag";
    private static final String USER_EXPERIENCE_INVOLVED = "user_experience_involved";
    private static final int USER_EXPERIENCE_ON = 1;
    private static final int TYPE_MAINTF = 1;
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile HianalyticsHelper instance;
    private boolean hasHianalytics;
    private boolean hasHMSBI;
    private String haTag = "hms_hwid";
    private HiAnalyticsInstance hInstance = null;
    private HiAnalyticsInstance defaultInstance = null;
    private boolean isEnablePrivacyPolicy = false;
    private ExecutorService reportExecutor = ExecutorsUtils.newSingleThreadExecutor("report_ha");

    private HianalyticsHelper() {
        try {
            HiAnalyticsManager.getInitFlag((String)DEAULT_HA_SERVICE_TAG);
            this.hasHianalytics = true;
        }
        catch (Throwable e) {
            Logger.i(TAG, "Hianalytics sdk not found");
            this.hasHianalytics = false;
        }
        if (!this.hasHianalytics) {
            this.tryHMSBIInit(ContextHolder.getAppContext());
        }
        Logger.v(TAG, "this time the ha %s, mini %s", this.hasHianalytics, this.hasHMSBI);
    }

    private void tryHMSBIInit(Context context) {
        if (context == null) {
            Logger.i(TAG, "the appContext hasn't init");
            return;
        }
        try {
            HMSBIInitializer.getInstance((Context)context).initBI();
            this.hasHMSBI = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Logger.w(TAG, "maybe you need add base sdk!");
        }
        catch (Throwable throwable) {
            Logger.w(TAG, "the hms base has other error!");
        }
    }

    public void setHaTag(String haTag) {
        this.haTag = haTag;
    }

    public void enablePrivacyPolicy(boolean isEnablePrivacyPolicy) {
        this.isEnablePrivacyPolicy = isEnablePrivacyPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HianalyticsHelper getInstance() {
        if (instance != null) return instance;
        Class<HianalyticsHelper> clazz = HianalyticsHelper.class;
        synchronized (HianalyticsHelper.class) {
            if (instance != null) return instance;
            instance = new HianalyticsHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isEnableReport(Context context) {
        if (this.hasHMSBI) {
            return true;
        }
        if (!this.hasHianalytics) {
            return false;
        }
        return this.isEnableReportNoSeed(context);
    }

    public boolean isEnableReportNoSeed(Context context) {
        if (this.hasHMSBI) {
            return true;
        }
        if (!this.hasHianalytics) {
            Logger.i(TAG, "Hianalytics sdk need to be initialized");
            return false;
        }
        if (context == null) {
            Logger.i(TAG, "HianalyticsHelper context can't be null");
            return false;
        }
        if (this.isEnablePrivacyPolicy) {
            return this.isHianalyticsOk();
        }
        ContentResolver contentResolver = context.getContentResolver();
        try {
            if (Settings.Secure.getInt((ContentResolver)contentResolver, (String)USER_EXPERIENCE_INVOLVED, (int)-1) == 1) {
                return this.isHianalyticsOk();
            }
        }
        catch (IllegalStateException illegalStateException) {
            Logger.w(TAG, "the setting has illegalStateException");
        }
        catch (Throwable throwable) {
            Logger.w(TAG, "the setting has other error");
        }
        Logger.i(TAG, "user experience involved needs to be opened");
        return false;
    }

    private boolean isHianalyticsOk() {
        if (HiAnalyticsManager.getInitFlag((String)DEAULT_HA_SERVICE_TAG)) {
            if (this.defaultInstance == null) {
                this.defaultInstance = HiAnalyticsManager.getInstanceByTag((String)DEAULT_HA_SERVICE_TAG);
            }
            return this.defaultInstance != null;
        }
        if (this.hInstance == null) {
            this.hInstance = HiAnalyticsManager.getInstanceByTag((String)this.haTag);
        }
        return this.hInstance != null;
    }

    public void onEvent(LinkedHashMap<String, String> data, String eventId) {
        this.onEvent(data, eventId, 1);
    }

    public void onEvent(LinkedHashMap<String, String> data, String eventId, int reportType) {
        if (this.hasHMSBI) {
            this.onNewEvent(ContextHolder.getAppContext(), eventId, data, reportType);
        } else if (reportType == 0) {
            Logger.v(TAG, "the base sdk isn't exsit, and reportType is %s", reportType);
            return;
        }
        if (!this.hasHianalytics) {
            return;
        }
        if (data == null) {
            return;
        }
        Logger.v(TAG, "data = %s", data);
        if (HiAnalyticsManager.getInitFlag((String)DEAULT_HA_SERVICE_TAG) && this.defaultInstance != null) {
            this.defaultInstance.onEvent(1, eventId, data);
        } else if (this.hInstance != null) {
            this.hInstance.onEvent(1, eventId, data);
        } else {
            Logger.e(TAG, "the ha has error,has init but is null!");
        }
    }

    private void onNewEvent(Context context, String eventId, Map data, int type) {
        if (context == null || data == null) {
            return;
        }
        Logger.v(TAG, "data = %s", data);
        try {
            HiAnalyticsUtils.getInstance().onNewEvent(context, eventId, data, type);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Logger.w(TAG, "may be you need upgrade stats sdk");
        }
        catch (Throwable throwable) {
            Logger.i(TAG, "the stats has other error,pls check it");
        }
    }

    public void onEvent(LinkedHashMap<String, String> data) {
        this.onEvent(data, "url_request");
    }

    public ExecutorService getReportExecutor() {
        return this.reportExecutor;
    }

    public void executeReportHa(HianalyticsBaseData data, String event) {
        this.getReportExecutor().execute(new HianalyticsRunnable(data, event));
    }

    public void reportException(final Throwable e, final String eventId) {
        if (!HianalyticsHelper.getInstance().isEnableReport(ContextHolder.getAppContext())) {
            return;
        }
        final String threadName = Thread.currentThread().getName();
        try {
            this.reportExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    CrashHianalyticsData data = new CrashHianalyticsData();
                    data.put("sdk_version", "5.0.10.302");
                    data.put("crash_type", "exception");
                    data.put("thread_name", threadName);
                    data.put("exception_name", e.getClass().getName());
                    data.put("message", StringUtils.anonymizeMessage(e.getMessage()));
                    data.put("stack_trace", StringUtils.getTraceInfo(e));
                    HianalyticsHelper.getInstance().onEvent(data.get(), eventId);
                }
            });
        }
        catch (RejectedExecutionException ex) {
            Logger.i(TAG, "reportException error RejectedExecutionException");
        }
        catch (Exception exception) {
            Logger.i(TAG, "reportException error!", e);
        }
    }

    public void reportData(Context context, LinkedHashMap<String, String> data, String eventId, int reportType) {
        if (!this.isEnableReportNoSeed(context)) {
            return;
        }
        this.onEvent(data, eventId, reportType);
    }

    private static class HianalyticsRunnable
    implements Runnable {
        private final HianalyticsBaseData data;
        private final String event;

        HianalyticsRunnable(HianalyticsBaseData data, String event) {
            this.data = data;
            this.event = event;
        }

        @Override
        public void run() {
            HianalyticsHelper.getInstance().onEvent(this.data.get(), this.event);
        }
    }
}

