/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common.hianalytics;

import com.huawei.hms.framework.common.Logger;
import com.huawei.hms.framework.common.hianalytics.HianalyticsHelper;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.RejectedExecutionException;

public class InitReport {
    private static final String TAG = "HaReport";
    private static boolean hasConnectNet = false;
    private static final int EVENT_LIMIT = 10;
    private static List<Runnable> eventsToReport = new CopyOnWriteArrayList<Runnable>();

    public static void reportWhenInit(Runnable event) {
        if (hasConnectNet) {
            try {
                HianalyticsHelper.getInstance().getReportExecutor().execute(event);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                Logger.e(TAG, "the thread submit has rejectedExecutionException!");
            }
            catch (Throwable throwable) {
                Logger.e(TAG, "the thread submit has fatal error!");
            }
            return;
        }
        if (eventsToReport.size() > 10) {
            Logger.e("TAG", "the event to be report when init exceed the limit!");
            return;
        }
        eventsToReport.add(event);
    }

    public static void enableConnectNet() {
        hasConnectNet = true;
        try {
            HianalyticsHelper.getInstance().getReportExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    InitReport.submitAllEvents();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Logger.e(TAG, "the thread submit has rejectedExecutionException!");
        }
        catch (Throwable throwable) {
            Logger.e(TAG, "the thread submit has fatal error!");
        }
    }

    private static void submitAllEvents() {
        try {
            for (Runnable event : eventsToReport) {
                HianalyticsHelper.getInstance().getReportExecutor().submit(event);
            }
            eventsToReport.clear();
        }
        catch (RejectedExecutionException e) {
            Logger.e(TAG, "submit failed of rejected execution exception");
        }
        catch (NullPointerException e) {
            Logger.e(TAG, "event is null occured");
        }
        catch (Exception e) {
            Logger.e(TAG, "submit failed because of some exception");
        }
    }
}

