/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.msp.push.notification;

import com.heytap.mcssdk.notification.PushNotificationSortManager;
import com.heytap.msp.push.notification.ISortListener;
import com.heytap.msp.push.notification.PushNotification;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class PushNotificationManager {
    private PushNotification.Builder builder;
    private Executor executor;

    public PushNotificationManager with(PushNotification.Builder builder) {
        this.builder = builder;
        return this;
    }

    public void execute(ISortListener listener) {
        PushNotificationSortManager.getInstance().startBuild(this.builder, listener);
    }

    public void enqueue(final ISortListener listener) {
        if (this.executor == null) {
            this.executor = new ThreadPoolExecutor(1, 0, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(16), new ThreadPoolExecutor.DiscardPolicy());
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                PushNotificationSortManager.getInstance().startBuild(PushNotificationManager.this.builder, listener);
            }
        });
    }

    public static PushNotificationManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        private static final PushNotificationManager INSTANCE = new PushNotificationManager();

        private SingletonHolder() {
        }
    }
}

