/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.utils;

import com.huawei.hms.support.log.HMSLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class IOUtils {
    public static void closeQuietly(Reader reader) {
        IOUtils.closeQuietly((Closeable)reader);
    }

    public static void closeQuietly(Writer writer) {
        IOUtils.closeQuietly((Closeable)writer);
    }

    public static void closeQuietly(InputStream inputStream) {
        IOUtils.closeQuietly((Closeable)inputStream);
    }

    public static void closeQuietly(OutputStream outputStream) {
        IOUtils.closeQuietly((Closeable)outputStream);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                HMSLog.e((String)"IOUtils", (String)"An exception occurred while closing the 'Closeable' object.");
            }
        }
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOUtils.copy(inputStream, outputStream, new byte[4096]);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        long l = 0L;
        while (-1 != (n = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static byte[] toByteArray(InputStream closeable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream = closeable;
        closeable = byteArrayOutputStream;
        IOUtils.copy(inputStream, new ByteArrayOutputStream());
        return ((ByteArrayOutputStream)closeable).toByteArray();
    }

    public static InputStream toInputStream(byte[] byArray) throws IOException {
        return new ByteArrayInputStream(byArray);
    }
}

