/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.adapter;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.huawei.hms.activity.BridgeActivity;
import com.huawei.hms.adapter.AvailableAdapter;
import com.huawei.hms.adapter.CoreBaseRequest;
import com.huawei.hms.adapter.CoreBaseResponse;
import com.huawei.hms.adapter.sysobs.SystemManager;
import com.huawei.hms.adapter.sysobs.SystemObserver;
import com.huawei.hms.adapter.ui.BaseResolutionAdapter;
import com.huawei.hms.common.internal.RequestHeader;
import com.huawei.hms.common.internal.ResponseHeader;
import com.huawei.hms.common.internal.ResponseWrap;
import com.huawei.hms.core.aidl.IMessageEntity;
import com.huawei.hms.support.api.PendingResultImpl;
import com.huawei.hms.support.api.ResolveResult;
import com.huawei.hms.support.api.client.ApiClient;
import com.huawei.hms.support.api.client.PendingResult;
import com.huawei.hms.support.api.client.ResultCallback;
import com.huawei.hms.support.api.client.Status;
import com.huawei.hms.support.hianalytics.HiAnalyticsUtil;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.utils.HMSPackageManager;
import com.huawei.hms.utils.JsonUtil;
import com.huawei.hms.utils.Util;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class BaseAdapter {
    private static final String TAG = "BaseAdapter";
    private static final String HMS_SESSION_INVALID = "com.huawei.hms.core.action.SESSION_INVALID";
    private WeakReference<ApiClient> api;
    private WeakReference<Activity> activityWeakReference;
    private BaseCallBack callback;
    private String jsonHeaderReplay;
    private String jsonObjectReplay;
    private Parcelable parcelableReplay;
    private BaseCallBack baseCallBackReplay;
    private String transactionId;
    private Context appContext;
    private RequestHeader requestHeader = new RequestHeader();
    private ResponseHeader responseHeader = new ResponseHeader();
    private SystemObserver observer;

    public BaseAdapter(ApiClient apiClient) {
        this.api = new WeakReference<ApiClient>(apiClient);
        this.appContext = apiClient.getContext().getApplicationContext();
        HMSLog.i((String)TAG, (String)("In constructor, WeakReference is " + this.api));
    }

    public BaseAdapter(ApiClient apiClient, Activity activity) {
        this.api = new WeakReference<ApiClient>(apiClient);
        this.activityWeakReference = new WeakReference<Activity>(activity);
        this.appContext = activity.getApplicationContext();
        HMSLog.i((String)TAG, (String)("In constructor, activityWeakReference is " + this.activityWeakReference + ", activity is " + this.activityWeakReference.get()));
    }

    private PendingResult<ResolveResult<CoreBaseResponse>> baseRequest(ApiClient apiClient, String string, CoreBaseRequest coreBaseRequest) {
        return new MPendingResultImpl(apiClient, string, coreBaseRequest);
    }

    private Activity getCpActivity() {
        if (this.activityWeakReference == null) {
            HMSLog.i((String)TAG, (String)("activityWeakReference is " + this.activityWeakReference));
            return null;
        }
        ApiClient apiClient = (ApiClient)this.api.get();
        if (apiClient == null) {
            HMSLog.i((String)TAG, (String)"tmpApi is null");
            return null;
        }
        HMSLog.i((String)TAG, (String)("activityWeakReference has " + this.activityWeakReference.get()));
        return Util.getActiveActivity((Activity)this.activityWeakReference.get(), apiClient.getContext());
    }

    private void startResolution(Activity activity, Parcelable parcelable) {
        HMSLog.i((String)TAG, (String)"startResolution");
        RequestHeader requestHeader = this.requestHeader;
        if (requestHeader != null) {
            BaseAdapter baseAdapter = this;
            baseAdapter.biReportRequestEntrySolution(baseAdapter.appContext, requestHeader);
        }
        if (this.observer == null) {
            this.initObserver();
        }
        Activity activity2 = activity;
        SystemManager.getSystemNotifier().registerObserver(this.observer);
        Intent intent = BridgeActivity.getIntentStartBridgeActivity((Activity)activity2, (String)BaseResolutionAdapter.class.getName());
        Bundle bundle = new Bundle();
        bundle.putParcelable("resolution", parcelable);
        intent.putExtras(bundle);
        intent.putExtra("transaction_id", this.transactionId);
        activity2.startActivity(intent);
    }

    private void sendBroadcastAfterResolutionHms() {
        Intent intent;
        if (this.appContext == null) {
            HMSLog.e((String)TAG, (String)"sendBroadcastAfterResolutionHms, context is null");
            return;
        }
        Intent intent2 = intent;
        intent2(HMS_SESSION_INVALID);
        intent.setPackage(this.appContext.getPackageName());
        this.appContext.sendBroadcast(intent2);
    }

    private BaseCallBack getCallBack() {
        BaseCallBack baseCallBack = ((BaseAdapter)((Object)baseCallBack)).callback;
        if (baseCallBack == null) {
            HMSLog.e((String)TAG, (String)"callback null");
            return null;
        }
        return baseCallBack;
    }

    private void biReportRequestEntryIpc(Context context, RequestHeader requestHeader) {
        Map<String, String> map = HiAnalyticsUtil.getInstance().getMapFromRequestHeader(requestHeader);
        map.put("direction", "req");
        map.put("version", HiAnalyticsUtil.versionCodeToName(String.valueOf(requestHeader.getKitSdkVersion())));
        map.put("phoneType", Util.getSystemProperties("ro.logsystem.usertype", ""));
        HiAnalyticsUtil.getInstance().onNewEvent(context, "HMS_SDK_BASE_CALL_AIDL", map);
    }

    private void biReportRequestEntrySolution(Context context, RequestHeader requestHeader) {
        Map<String, String> map = HiAnalyticsUtil.getInstance().getMapFromRequestHeader(requestHeader);
        map.put("direction", "req");
        map.put("version", HiAnalyticsUtil.versionCodeToName(String.valueOf(requestHeader.getKitSdkVersion())));
        map.put("phoneType", Util.getSystemProperties("ro.logsystem.usertype", ""));
        HiAnalyticsUtil.getInstance().onNewEvent(context, "HMS_SDK_BASE_START_RESOLUTION", map);
    }

    private void biReportRequestReturnIpc(Context context, ResponseHeader object) {
        HiAnalyticsUtil.getInstance();
        object = HiAnalyticsUtil.getMapFromRequestHeader((ResponseHeader)object);
        object.put("direction", "rsp");
        object.put((String)"version", (String)HiAnalyticsUtil.versionCodeToName(String.valueOf(this.requestHeader.getKitSdkVersion())));
        object.put((String)"phoneType", (String)Util.getSystemProperties("ro.logsystem.usertype", ""));
        HiAnalyticsUtil.getInstance().onNewEvent(context, "HMS_SDK_BASE_CALL_AIDL", (Map)object);
    }

    private void biReportRequestReturnSolution(Context context, ResponseHeader object, long l) {
        HiAnalyticsUtil.getInstance();
        object = HiAnalyticsUtil.getMapFromRequestHeader((ResponseHeader)object);
        object.put("direction", "rsp");
        object.put("waitTime", String.valueOf(l));
        object.put((String)"version", (String)HiAnalyticsUtil.versionCodeToName(String.valueOf(this.requestHeader.getKitSdkVersion())));
        object.put((String)"phoneType", (String)Util.getSystemProperties("ro.logsystem.usertype", ""));
        HiAnalyticsUtil.getInstance().onNewEvent(context, "HMS_SDK_BASE_START_RESOLUTION", (Map)object);
    }

    private ResponseWrap buildResponseWrap(int n, String string) {
        this.setResponseHeader(n);
        ResponseWrap responseWrap = new ResponseWrap(this.responseHeader);
        responseWrap.setBody(string);
        return responseWrap;
    }

    private void setResponseHeader(int n) {
        BaseAdapter baseAdapter = this;
        baseAdapter.responseHeader.setTransactionId(this.requestHeader.getTransactionId());
        baseAdapter.responseHeader.setAppID(this.requestHeader.getAppID());
        baseAdapter.responseHeader.setApiName(this.requestHeader.getApiName());
        baseAdapter.responseHeader.setSrvName(this.requestHeader.getSrvName());
        baseAdapter.responseHeader.setPkgName(this.requestHeader.getPkgName());
        baseAdapter.responseHeader.setStatusCode(1);
        baseAdapter.responseHeader.setErrorCode(n);
        baseAdapter.responseHeader.setErrorReason("Core error");
    }

    private String buildBodyStr(int n) {
        JSONObject jSONObject;
        BaseAdapter baseAdapter = jSONObject;
        try {
            new JSONObject().put("errorCode", n);
        }
        catch (JSONException jSONException) {
            HMSLog.e((String)TAG, (String)("buildBodyStr failed: " + jSONException.getMessage()));
        }
        return baseAdapter.toString();
    }

    private String getResponseHeaderForError(int n) {
        BaseAdapter baseAdapter = this;
        baseAdapter.setResponseHeader(n);
        return baseAdapter.responseHeader.toJson();
    }

    private String getJsonHeaderReplay() {
        return this.jsonHeaderReplay;
    }

    private void setJsonHeaderReplay(String string) {
        this.jsonHeaderReplay = string;
    }

    private String getJsonObjectReplay() {
        return this.jsonObjectReplay;
    }

    private void setJsonObjectReplay(String string) {
        this.jsonObjectReplay = string;
    }

    private Parcelable getParcelableReplay() {
        return this.parcelableReplay;
    }

    private void setParcelableReplay(Parcelable parcelable) {
        this.parcelableReplay = parcelable;
    }

    private BaseCallBack getBaseCallBackReplay() {
        return this.baseCallBackReplay;
    }

    private void setBaseCallBackReplay(BaseCallBack baseCallBack) {
        this.baseCallBackReplay = baseCallBack;
    }

    private void setReplayData(String string, String string2, Parcelable parcelable, BaseCallBack baseCallBack) {
        this.setJsonHeaderReplay(string);
        this.setJsonObjectReplay(string2);
        this.setParcelableReplay(parcelable);
        this.setBaseCallBackReplay(baseCallBack);
    }

    private void replayRequest() {
        if (this.jsonHeaderReplay != null && this.baseCallBackReplay != null) {
            BaseAdapter baseAdapter = this;
            baseAdapter.responseHeader = null;
            baseAdapter.responseHeader = new ResponseHeader();
            baseAdapter.baseRequest(baseAdapter.getJsonHeaderReplay(), this.getJsonObjectReplay(), this.getParcelableReplay(), this.getBaseCallBackReplay());
            return;
        }
    }

    private void initObserver() {
        this.observer = new SystemObserver(){

            public boolean onSolutionResult(Intent object, String object2) {
                if (TextUtils.isEmpty((CharSequence)object2)) {
                    HMSLog.e((String)BaseAdapter.TAG, (String)"onSolutionResult but id is null");
                    object = BaseAdapter.this.getCallBack();
                    if (object == null) {
                        HMSLog.e((String)BaseAdapter.TAG, (String)"onSolutionResult baseCallBack null");
                        return true;
                    }
                    object.onError(BaseAdapter.this.getResponseHeaderForError(-6));
                    return true;
                }
                if (((String)object2).equals(BaseAdapter.this.transactionId)) {
                    HMSLog.i((String)BaseAdapter.TAG, (String)("onSolutionResult + id is :" + (String)object2));
                    object2 = BaseAdapter.this.getCallBack();
                    if (object2 == null) {
                        HMSLog.e((String)BaseAdapter.TAG, (String)"onResult baseCallBack null");
                        return true;
                    }
                    if (object == null) {
                        HMSLog.e((String)BaseAdapter.TAG, (String)"onSolutionResult but data is null");
                        String string = BaseAdapter.this.getResponseHeaderForError(-7);
                        BaseAdapter baseAdapter = BaseAdapter.this;
                        baseAdapter.biReportRequestReturnSolution(baseAdapter.appContext, BaseAdapter.this.responseHeader, 0L);
                        object2.onError(string);
                        return true;
                    }
                    if (BaseAdapter.this.hasExtraUpdateResult((Intent)object, (BaseCallBack)object2)) {
                        return true;
                    }
                    if (BaseAdapter.this.hasExtraPrivacyResult((Intent)object, (BaseCallBack)object2)) {
                        return true;
                    }
                    HMSLog.e((String)BaseAdapter.TAG, (String)"onComplete for on activity result");
                    BaseAdapter.this.onCompleteResult((Intent)object, (BaseCallBack)object2);
                    return true;
                }
                return false;
            }

            public boolean onUpdateResult(int n) {
                return false;
            }

            public boolean onNoticeResult(int n) {
                return false;
            }
        };
    }

    private boolean hasExtraPrivacyResult(Intent intent, BaseCallBack baseCallBack) {
        if (intent.hasExtra("privacy_statement_confirm_result")) {
            if (intent.getIntExtra("privacy_statement_confirm_result", 1001) == 1001) {
                HMSLog.i((String)TAG, (String)"privacy_statement_confirm_result agreed, replay request");
                this.replayRequest();
            } else {
                BaseAdapter baseAdapter = this;
                HMSLog.i((String)TAG, (String)"privacy_statement_confirm_result rejected");
                baseCallBack.onError(baseAdapter.buildResponseWrap(907135705, baseAdapter.buildBodyStr(907135705)).toJson());
            }
            return true;
        }
        return false;
    }

    private boolean hasExtraUpdateResult(Intent intent, BaseCallBack baseCallBack) {
        if (intent.hasExtra("kit_update_result")) {
            int n = intent.getIntExtra("kit_update_result", 0);
            HMSLog.i((String)TAG, (String)("kit_update_result is " + n));
            if (n == 1) {
                HMSLog.e((String)TAG, (String)"kit update success,replay request");
                this.replayRequest();
            } else {
                BaseAdapter baseAdapter = this;
                HMSLog.e((String)TAG, (String)"kit update failed");
                baseCallBack.onError(baseAdapter.buildResponseWrap(-10, baseAdapter.buildBodyStr(n)).toJson());
            }
            return true;
        }
        return false;
    }

    private void onCompleteResult(Intent object, BaseCallBack baseCallBack) {
        Intent intent = object;
        String string = intent.getStringExtra("json_header");
        String string2 = object.getStringExtra("json_body");
        Object object2 = JsonUtil.getInfoFromJsonobject(string, "status_code");
        Object object3 = JsonUtil.getInfoFromJsonobject(string, "error_code");
        long l = 0L;
        if (intent.hasExtra("HMS_FOREGROUND_RES_UI") && (object = JsonUtil.getInfoFromJsonobject(object.getStringExtra("HMS_FOREGROUND_RES_UI"), "uiDuration")) instanceof Long) {
            l = (Long)object;
        }
        if (object2 instanceof Integer && object3 instanceof Integer) {
            BaseAdapter baseAdapter = this;
            int n = (Integer)object2;
            baseAdapter.getResponseHeaderForError((Integer)object3);
            baseAdapter.responseHeader.setStatusCode(n);
            baseAdapter.biReportRequestReturnSolution(baseAdapter.appContext, this.responseHeader, l);
        } else {
            BaseAdapter baseAdapter = this;
            baseAdapter.getResponseHeaderForError(-8);
            baseAdapter.biReportRequestReturnSolution(baseAdapter.appContext, this.responseHeader, l);
        }
        baseCallBack.onComplete(string, string2, null);
    }

    public void baseRequest(String string, String string2, Parcelable parcelable, BaseCallBack baseCallBack) {
        CoreBaseRequest coreBaseRequest;
        BaseAdapter baseAdapter = this;
        baseAdapter.setReplayData(string, string2, parcelable, baseCallBack);
        if (baseAdapter.api == null) {
            HMSLog.e((String)TAG, (String)"client is null");
            baseCallBack.onError(this.getResponseHeaderForError(-2));
            return;
        }
        this.callback = baseCallBack;
        JsonUtil.jsonToEntity(string, this.requestHeader);
        CoreBaseRequest coreBaseRequest2 = coreBaseRequest;
        coreBaseRequest2();
        coreBaseRequest2.setJsonObject(string2);
        coreBaseRequest2.setJsonHeader(string);
        coreBaseRequest.setParcelable(parcelable);
        string = this.requestHeader.getApiName();
        if (TextUtils.isEmpty((CharSequence)string)) {
            HMSLog.e((String)TAG, (String)"get uri null");
            baseCallBack.onError(this.getResponseHeaderForError(-5));
            return;
        }
        BaseAdapter baseAdapter2 = this;
        baseAdapter2.transactionId = baseAdapter2.requestHeader.getTransactionId();
        if (TextUtils.isEmpty((CharSequence)baseAdapter2.transactionId)) {
            HMSLog.e((String)TAG, (String)"get transactionId null");
            baseCallBack.onError(this.getResponseHeaderForError(-6));
            return;
        }
        BaseAdapter baseAdapter3 = this;
        HMSLog.i((String)TAG, (String)("in baseRequest + uri is :" + string + ", transactionId is : " + this.transactionId));
        baseAdapter3.biReportRequestEntryIpc(baseAdapter3.appContext, this.requestHeader);
        baseAdapter3.baseRequest((ApiClient)baseAdapter3.api.get(), string, coreBaseRequest2).setResultCallback(new BaseRequestResultCallback());
    }

    public static interface BaseCallBack {
        public void onComplete(String var1, String var2, Parcelable var3);

        public void onError(String var1);
    }

    public class BaseRequestResultCallback
    implements ResultCallback<ResolveResult<CoreBaseResponse>> {
        private AtomicBoolean isFirstRsp = new AtomicBoolean(true);

        /*
         * Enabled aggressive block sorting
         */
        private void resolutionResult(String string, BaseCallBack baseCallBack, CoreBaseResponse coreBaseResponse, int n) {
            if ("intent".equals(string)) {
                string = BaseAdapter.this.getCpActivity();
                HMSLog.i((String)BaseAdapter.TAG, (String)("activity is: " + string));
                if (string != null && !string.isFinishing()) {
                    PendingIntent pendingIntent = coreBaseResponse.getPendingIntent();
                    if (pendingIntent != null) {
                        if (Util.isAvailableLibExist(BaseAdapter.this.appContext)) {
                            BaseAdapter.this.startResolution((Activity)string, (Parcelable)pendingIntent);
                            return;
                        }
                        baseCallBack.onError(BaseAdapter.this.getResponseHeaderForError(-9));
                        return;
                    }
                    if ((coreBaseResponse = coreBaseResponse.getIntent()) != null) {
                        if (Util.isAvailableLibExist(BaseAdapter.this.appContext)) {
                            BaseAdapter.this.startResolution((Activity)string, (Parcelable)coreBaseResponse);
                            return;
                        }
                        baseCallBack.onError(BaseAdapter.this.getResponseHeaderForError(-9));
                        return;
                    }
                    if (n == 2) {
                        BaseAdapter baseAdapter = BaseAdapter.this;
                        baseCallBack.onError(baseAdapter.getResponseHeaderForError(baseAdapter.responseHeader.getErrorCode()));
                        return;
                    }
                    HMSLog.e((String)BaseAdapter.TAG, (String)"hasResolution is true but NO_SOLUTION");
                    baseCallBack.onError(BaseAdapter.this.getResponseHeaderForError(-4));
                    return;
                }
                HMSLog.e((String)BaseAdapter.TAG, (String)"activity null");
                this.handleSolutionIntent(baseCallBack, coreBaseResponse);
                return;
            }
            if ("installHMS".equals(string)) {
                HMSLog.i((String)BaseAdapter.TAG, (String)"has resolutin: installHMS, but base-sdk can't support to install HMS");
                this.handleSolutionForHms(baseCallBack);
                return;
            }
            this.handleSolutionIntent(baseCallBack, coreBaseResponse);
        }

        private void handleSolutionIntent(BaseCallBack baseCallBack, CoreBaseResponse coreBaseResponse) {
            HMSLog.i((String)BaseAdapter.TAG, (String)"baseCallBack.onComplete");
            BaseRequestResultCallback baseRequestResultCallback = coreBaseResponse.getPendingIntent();
            if (baseRequestResultCallback != null) {
                baseCallBack.onComplete(coreBaseResponse.getJsonHeader(), coreBaseResponse.getJsonBody(), (Parcelable)baseRequestResultCallback);
                return;
            }
            baseRequestResultCallback = coreBaseResponse.getIntent();
            if (baseRequestResultCallback != null) {
                baseCallBack.onComplete(coreBaseResponse.getJsonHeader(), coreBaseResponse.getJsonBody(), (Parcelable)baseRequestResultCallback);
                return;
            }
            baseCallBack.onComplete(coreBaseResponse.getJsonHeader(), coreBaseResponse.getJsonBody(), null);
        }

        private void handleSolutionForHms(final BaseCallBack baseCallBack) {
            if (!Util.isAvailableLibExist(BaseAdapter.this.appContext)) {
                HMSLog.i((String)BaseAdapter.TAG, (String)"handleSolutionForHms: no Available lib exist");
                baseCallBack.onError(BaseAdapter.this.getResponseHeaderForError(-9));
                return;
            }
            Activity activity = BaseAdapter.this.getCpActivity();
            if (activity != null && !activity.isFinishing()) {
                HMSLog.i((String)BaseAdapter.TAG, (String)"start handleSolutionForHMS");
                AvailableAdapter availableAdapter = new AvailableAdapter(10000000);
                availableAdapter.setCalledBySolutionInstallHms(true);
                availableAdapter.startResolution(activity, new AvailableAdapter.AvailableCallBack(){

                    public void onComplete(int n) {
                        Object object;
                        HMSLog.i((String)BaseAdapter.TAG, (String)("complete handleSolutionForHMS, result: " + n));
                        if (n == 0) {
                            1 v0 = object;
                            HMSPackageManager.getInstance((Context)v0.BaseAdapter.this.appContext).resetMultiServiceState();
                            BaseAdapter baseAdapter = v0.BaseAdapter.this;
                            object = baseAdapter.buildResponseWrap(11, baseAdapter.buildBodyStr(11));
                            v0.baseCallBack.onError(((ResponseWrap)object).toJson());
                            v0.BaseAdapter.this.sendBroadcastAfterResolutionHms();
                        } else {
                            1 v2 = object;
                            BaseAdapter baseAdapter = v2.BaseAdapter.this;
                            object = baseAdapter.buildResponseWrap(n, baseAdapter.buildBodyStr(n));
                            v2.baseCallBack.onError(((ResponseWrap)object).toJson());
                        }
                    }
                });
                return;
            }
            HMSLog.e((String)BaseAdapter.TAG, (String)"activity is null");
            BaseAdapter baseAdapter = BaseAdapter.this;
            baseCallBack.onError(baseAdapter.buildResponseWrap(-3, baseAdapter.buildBodyStr(-3)).toJson());
        }

        @Override
        public void onResult(ResolveResult<CoreBaseResponse> iMessageEntity) {
            BaseCallBack baseCallBack = BaseAdapter.this.getCallBack();
            if (baseCallBack == null) {
                HMSLog.e((String)BaseAdapter.TAG, (String)"onResult baseCallBack null");
                return;
            }
            if (iMessageEntity == null) {
                HMSLog.e((String)BaseAdapter.TAG, (String)"result null");
                baseCallBack.onError(BaseAdapter.this.getResponseHeaderForError(-1));
                return;
            }
            if ((iMessageEntity = ((ResolveResult)iMessageEntity).getValue()) == null) {
                HMSLog.e((String)BaseAdapter.TAG, (String)"response null");
                baseCallBack.onError(BaseAdapter.this.getResponseHeaderForError(-1));
                return;
            }
            if (TextUtils.isEmpty((CharSequence)((CoreBaseResponse)iMessageEntity).getJsonHeader())) {
                HMSLog.e((String)BaseAdapter.TAG, (String)"jsonHeader null");
                baseCallBack.onError(BaseAdapter.this.getResponseHeaderForError(-1));
                return;
            }
            JsonUtil.jsonToEntity(((CoreBaseResponse)iMessageEntity).getJsonHeader(), BaseAdapter.this.responseHeader);
            if (this.isFirstRsp.compareAndSet(true, false)) {
                BaseAdapter baseAdapter = BaseAdapter.this;
                baseAdapter.biReportRequestReturnIpc(baseAdapter.appContext, BaseAdapter.this.responseHeader);
            }
            BaseRequestResultCallback baseRequestResultCallback = this;
            String string = baseRequestResultCallback.BaseAdapter.this.responseHeader.getResolution();
            int n = BaseAdapter.this.responseHeader.getStatusCode();
            HMSLog.i((String)BaseAdapter.TAG, (String)("api is: " + BaseAdapter.this.responseHeader.getApiName() + ", resolution: " + string + ", status_code: " + n));
            baseRequestResultCallback.resolutionResult(string, baseCallBack, (CoreBaseResponse)iMessageEntity, n);
        }
    }

    private static class MPendingResultImpl
    extends PendingResultImpl<ResolveResult<CoreBaseResponse>, CoreBaseResponse> {
        public MPendingResultImpl(ApiClient apiClient, String string, IMessageEntity iMessageEntity) {
            super(apiClient, string, iMessageEntity);
        }

        @Override
        public ResolveResult<CoreBaseResponse> onComplete(CoreBaseResponse coreBaseResponse) {
            ResolveResult<CoreBaseResponse> resolveResult = new ResolveResult<CoreBaseResponse>(coreBaseResponse);
            resolveResult.setStatus(Status.SUCCESS);
            return resolveResult;
        }
    }
}

