/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secure.android.common.util;

import android.database.Cursor;
import android.text.TextUtils;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class IOUtil {
    private static final String a = "IOUtil";
    private static final int b = 4096;

    public static void close(Cursor cursor) {
        if (cursor != null) {
            cursor.close();
        }
    }

    public static void closeSecure(Reader reader) {
        IOUtil.closeSecure((Closeable)reader);
    }

    public static void closeSecure(Writer writer) {
        IOUtil.closeSecure((Closeable)writer);
    }

    public static void closeSecure(InputStream inputStream) {
        IOUtil.closeSecure((Closeable)inputStream);
    }

    public static void closeSecure(OutputStream outputStream) {
        IOUtil.closeSecure((Closeable)outputStream);
    }

    public static void closeSecure(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                Log.e((String)a, (String)"closeSecure IOException");
            }
        }
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOUtil.copy(inputStream, outputStream, new byte[4096]);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        long l = 0L;
        while (-1 != (n = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static byte[] toByteArray(InputStream closeable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream = closeable;
        closeable = byteArrayOutputStream;
        IOUtil.copy(inputStream, new ByteArrayOutputStream());
        return ((ByteArrayOutputStream)closeable).toByteArray();
    }

    public static InputStream toInputStream(byte[] byArray) throws IOException {
        return new ByteArrayInputStream(byArray);
    }

    public static void deleteSecure(File file) {
        if (file != null && file.exists() && !file.delete()) {
            Log.e((String)a, (String)"deleteSecure exception");
        }
    }

    public static void deleteSecure(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            IOUtil.deleteSecure(new File(string));
        }
    }
}

