/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import com.huawei.hmf.tasks.Task;
import com.huawei.hmf.tasks.TaskCompletionSource;
import com.huawei.hms.adapter.BinderAdapter;
import com.huawei.hms.api.Api;
import com.huawei.hms.api.ConnectionResult;
import com.huawei.hms.common.ApiException;
import com.huawei.hms.common.internal.AbstractClientBuilder;
import com.huawei.hms.common.internal.AnyClient;
import com.huawei.hms.common.internal.BaseHmsClient;
import com.huawei.hms.common.internal.BindResolveClients;
import com.huawei.hms.common.internal.ClientSettings;
import com.huawei.hms.common.internal.HmsClient;
import com.huawei.hms.common.internal.RequestHeader;
import com.huawei.hms.common.internal.RequestManager;
import com.huawei.hms.common.internal.ResolveClientBean;
import com.huawei.hms.common.internal.ResponseErrorCode;
import com.huawei.hms.common.internal.ResponseHeader;
import com.huawei.hms.common.internal.TaskApiCall;
import com.huawei.hms.common.internal.TaskApiCallWrapper;
import com.huawei.hms.common.internal.TransactionIdCreater;
import com.huawei.hms.core.aidl.IAIDLInvoke;
import com.huawei.hms.core.aidl.IMessageEntity;
import com.huawei.hms.support.api.client.Status;
import com.huawei.hms.support.api.client.SubAppInfo;
import com.huawei.hms.support.api.entity.auth.Scope;
import com.huawei.hms.support.hianalytics.b;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.utils.Checker;
import com.huawei.hms.utils.HMSBIInitializer;
import com.huawei.hms.utils.HMSPackageManager;
import com.huawei.hms.utils.Util;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class HuaweiApi<TOption extends Api.ApiOptions> {
    private static final String TAG = "HuaweiApi";
    private Context mContext;
    private TOption mOption;
    private Context mHostContext;
    private AbstractClientBuilder<?, TOption> mClientBuilder;
    private String mHostAppid;
    private String mAppID;
    private SubAppInfo mSubAppInfo;
    private WeakReference<Activity> mActivity;
    private int mKitSdkVersion;
    private int apiLevel = 1;
    private boolean isFirstReqSent = false;
    private String innerHmsPkg;
    private boolean isUseInnerHms;
    private RequestManager requestManager;

    public HuaweiApi(Activity activity, Api<TOption> api, TOption TOption, AbstractClientBuilder abstractClientBuilder, int n) {
        Checker.checkNonNull((Object)activity, (String)"Null activity is not permitted.");
        this.mActivity = new WeakReference<Activity>(activity);
        this.init((Context)activity, api, TOption, abstractClientBuilder, n, null);
    }

    public HuaweiApi(Activity activity, Api<TOption> api, TOption TOption, AbstractClientBuilder abstractClientBuilder, int n, String string) {
        Checker.checkNonNull((Object)activity, (String)"Null activity is not permitted.");
        this.mActivity = new WeakReference<Activity>(activity);
        this.init((Context)activity, api, TOption, abstractClientBuilder, n, string);
    }

    public HuaweiApi(Activity activity, Api<TOption> api, TOption TOption, AbstractClientBuilder abstractClientBuilder) {
        Checker.checkNonNull((Object)activity, (String)"Null activity is not permitted.");
        this.mActivity = new WeakReference<Activity>(activity);
        this.init((Context)activity, api, TOption, abstractClientBuilder, 0, null);
    }

    public HuaweiApi(Context context, Api<TOption> api, TOption TOption, AbstractClientBuilder abstractClientBuilder, int n) {
        Checker.checkNonNull((Object)context, (String)"Null context is not permitted.");
        this.init(context, api, TOption, abstractClientBuilder, n, null);
    }

    public HuaweiApi(Context context, Api<TOption> api, TOption TOption, AbstractClientBuilder abstractClientBuilder, int n, String string) {
        Checker.checkNonNull((Object)context, (String)"Null context is not permitted.");
        this.init(context, api, TOption, abstractClientBuilder, n, string);
    }

    public HuaweiApi(Context context, Api<TOption> api, TOption TOption, AbstractClientBuilder abstractClientBuilder) {
        Checker.checkNonNull((Object)context, (String)"Null context is not permitted.");
        this.init(context, api, TOption, abstractClientBuilder, 0, null);
    }

    private void init(Context context, Api<TOption> api, TOption TOption, AbstractClientBuilder abstractClientBuilder, int n, String string) {
        this.mContext = context.getApplicationContext();
        this.mOption = TOption;
        this.mClientBuilder = abstractClientBuilder;
        this.setHostAppId(context);
        this.mSubAppInfo = new SubAppInfo("");
        this.mKitSdkVersion = n;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (string.equals(this.mHostAppid)) {
                HMSLog.e((String)TAG, (String)"subAppId is host appid");
            } else {
                HMSLog.i((String)TAG, (String)("subAppId is " + string));
                this.mSubAppInfo = new SubAppInfo(string);
            }
        }
        this.initBI(context);
    }

    private void setHostAppId(Context context) {
        this.mAppID = this.mHostAppid = Util.getAppId(context);
    }

    private void initBI(Context context) {
        HMSBIInitializer.getInstance((Context)context).initBI();
    }

    private void innerDisconnect(HuaweiApi<?> huaweiApi, TaskCompletionSource<Boolean> taskCompletionSource) {
        HMSLog.i((String)TAG, (String)"innerDisconnect.");
        try {
            huaweiApi.getClient(RequestManager.getHandler().getLooper(), null).disconnect();
            taskCompletionSource.setResult((Object)true);
        }
        catch (Exception exception) {
            HMSLog.w((String)TAG, (String)("disconnect the binder failed for:" + exception.getMessage()));
        }
    }

    private <TResult, TClient extends AnyClient> Task<TResult> sendRequest(TaskApiCall<TClient, TResult> taskApiCall) {
        TaskApiCallWrapper<TResult> taskApiCallWrapper;
        TaskCompletionSource taskCompletionSource;
        if (taskApiCall.getToken() == null) {
            TaskCompletionSource taskCompletionSource2;
            taskCompletionSource = taskCompletionSource2;
            taskCompletionSource2 = new TaskCompletionSource();
        } else {
            TaskCompletionSource taskCompletionSource3;
            taskCompletionSource = taskCompletionSource3;
            taskCompletionSource3 = new TaskCompletionSource(taskApiCall.getToken());
        }
        TaskApiCallWrapper<TResult> taskApiCallWrapper2 = taskApiCallWrapper;
        taskApiCallWrapper = new TaskApiCallWrapper<TResult>(taskApiCall, taskCompletionSource);
        RequestManager.getHandler().post(new RequestRunnable(this, taskApiCallWrapper2));
        return taskCompletionSource.getTask();
    }

    public <TResult, TClient extends AnyClient> Task<TResult> doWrite(TaskApiCall<TClient, TResult> taskApiCall) {
        this.isFirstReqSent = true;
        if (taskApiCall == null) {
            HMSLog.e((String)TAG, (String)"in doWrite:taskApiCall is null");
            TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
            taskCompletionSource.setException((Exception)new ApiException(Status.FAILURE));
            return taskCompletionSource.getTask();
        }
        String string = TextUtils.isEmpty((CharSequence)this.mSubAppInfo.getSubAppID()) ? this.mAppID : this.mSubAppInfo.getSubAppID();
        HuaweiApi huaweiApi = this;
        b.a(huaweiApi.mContext, taskApiCall.getUri(), string, taskApiCall.getTransactionId(), String.valueOf(this.getKitSdkVersion()));
        if (huaweiApi.requestManager == null) {
            this.requestManager = RequestManager.getInstance();
        }
        return this.sendRequest(taskApiCall);
    }

    public int getApiLevel() {
        return this.apiLevel;
    }

    public void setApiLevel(int n) {
        this.apiLevel = n;
    }

    @Deprecated
    public Task<Boolean> disconnectService() {
        TaskCompletionSource taskCompletionSource;
        final TaskCompletionSource taskCompletionSource2 = taskCompletionSource;
        taskCompletionSource = new TaskCompletionSource();
        RequestManager.getInstance();
        final HuaweiApi huaweiApi = this;
        RequestManager.getHandler().post(new Runnable(){

            @Override
            public void run() {
                HuaweiApi.this.innerDisconnect(huaweiApi, (TaskCompletionSource<Boolean>)taskCompletionSource2);
            }
        });
        return taskCompletionSource.getTask();
    }

    public AnyClient getClient(Looper looper, RequestHandler requestHandler) {
        RequestHandler requestHandler2 = requestHandler;
        return this.mClientBuilder.buildClient(this.mContext, this.getClientSetting(), requestHandler2, requestHandler2);
    }

    protected ClientSettings getClientSetting() {
        ClientSettings clientSettings;
        ClientSettings clientSettings2 = clientSettings;
        clientSettings = new ClientSettings(((HuaweiApi)((Object)weakReference)).mContext.getPackageName(), ((HuaweiApi)((Object)weakReference)).mContext.getClass().getName(), ((HuaweiApi)((Object)weakReference)).getScopes(), ((HuaweiApi)((Object)weakReference)).mHostAppid, null, ((HuaweiApi)((Object)weakReference)).mSubAppInfo);
        if (!((HuaweiApi)((Object)weakReference)).isUseInnerHms) {
            ((HuaweiApi)((Object)weakReference)).innerHmsPkg = HMSPackageManager.getInstance((Context)((HuaweiApi)((Object)weakReference)).mContext).getHMSPackageNameForMultiService();
            HMSLog.i((String)TAG, (String)("No setInnerHms, hms pkg name is " + ((HuaweiApi)((Object)weakReference)).innerHmsPkg));
        }
        clientSettings2.setInnerHmsPkg(((HuaweiApi)((Object)weakReference)).innerHmsPkg);
        clientSettings2.setUseInnerHms(((HuaweiApi)((Object)weakReference)).isUseInnerHms);
        WeakReference<Activity> weakReference = ((HuaweiApi)((Object)weakReference)).mActivity;
        if (weakReference != null) {
            clientSettings2.setCpActivity((Activity)weakReference.get());
        }
        return clientSettings2;
    }

    protected List<Scope> getScopes() {
        return Collections.emptyList();
    }

    public Activity getActivity() {
        WeakReference<Activity> weakReference = ((HuaweiApi)((Object)weakReference)).mActivity;
        if (weakReference != null) {
            return (Activity)weakReference.get();
        }
        return null;
    }

    @Deprecated
    public boolean setSubAppInfo(SubAppInfo subAppInfo) {
        HMSLog.i((String)TAG, (String)"Enter setSubAppInfo");
        Object object = this.mSubAppInfo;
        if (object != null && !TextUtils.isEmpty((CharSequence)((SubAppInfo)object).getSubAppID())) {
            HMSLog.e((String)TAG, (String)"subAppInfo is already set");
            return false;
        }
        if (subAppInfo == null) {
            HMSLog.e((String)TAG, (String)"subAppInfo is null");
            return false;
        }
        object = subAppInfo.getSubAppID();
        if (TextUtils.isEmpty((CharSequence)object)) {
            HMSLog.e((String)TAG, (String)"subAppId is empty");
            return false;
        }
        if (((String)object).equals(this.mHostAppid)) {
            HMSLog.e((String)TAG, (String)"subAppId is host appid");
            return false;
        }
        if (this.isFirstReqSent) {
            HMSLog.e((String)TAG, (String)"Client has sent request to Huawei Mobile Services, setting subAppId is not allowed");
            return false;
        }
        this.mSubAppInfo = new SubAppInfo(subAppInfo);
        return true;
    }

    public void setSubAppId(String string) throws ApiException {
        if (this.setSubAppInfo(new SubAppInfo(string))) {
            return;
        }
        throw new ApiException(Status.FAILURE);
    }

    public String getAppID() {
        return this.mAppID;
    }

    public String getSubAppID() {
        return this.mSubAppInfo.getSubAppID();
    }

    public Context getContext() {
        return this.mContext;
    }

    public void setHostContext(Context context) {
        this.mHostContext = context;
    }

    public TOption getOption() {
        return this.mOption;
    }

    public int getKitSdkVersion() {
        return this.mKitSdkVersion;
    }

    public void setKitSdkVersion(int n) {
        this.mKitSdkVersion = n;
    }

    public void setInnerHms() {
        this.innerHmsPkg = this.mContext.getPackageName();
        this.isUseInnerHms = true;
        HMSLog.i((String)TAG, (String)("<setInnerHms> init inner hms pkg info:" + this.innerHmsPkg));
    }

    public static class RequestHandler<OptionsT extends Api.ApiOptions>
    implements BaseHmsClient.ConnectionCallbacks,
    BaseHmsClient.OnConnectionFailedListener {
        public final Queue<TaskApiCallbackWrapper> callbackWaitQueue;
        private final Queue<TaskApiCallbackWrapper> callbackRunQueue;
        private final AnyClient mClient;
        private ConnectionResult mConnectionResult;
        private final HuaweiApi<OptionsT> mApi;
        private ResolveClientBean mResolveClientBean;

        RequestHandler(HuaweiApi<OptionsT> huaweiApi) {
            RequestHandler requestHandler = this;
            this.callbackWaitQueue = new LinkedList<TaskApiCallbackWrapper>();
            this.callbackRunQueue = new LinkedList<TaskApiCallbackWrapper>();
            this.mApi = huaweiApi;
            requestHandler.mClient = huaweiApi.getClient(RequestManager.getHandler().getLooper(), this);
            requestHandler.mConnectionResult = null;
        }

        private TaskApiCallbackWrapper wrapperRequest(final TaskApiCallWrapper taskApiCallWrapper) {
            return new TaskApiCallbackWrapper(taskApiCallWrapper, new AnyClient.CallBack(){
                private AtomicBoolean isFirstRsp = new AtomicBoolean(true);

                @Override
                public void onCallback(IMessageEntity iMessageEntity, String string) {
                    if (!(iMessageEntity instanceof ResponseHeader)) {
                        HMSLog.e((String)HuaweiApi.TAG, (String)"header is not instance of ResponseHeader");
                        return;
                    }
                    if (((ResponseHeader)(iMessageEntity = (ResponseHeader)iMessageEntity)).getErrorCode() == 11) {
                        RequestHandler.this.disconnect();
                        HMSLog.i((String)HuaweiApi.TAG, (String)"unbind service");
                    }
                    if (!TextUtils.isEmpty((CharSequence)((ResponseHeader)iMessageEntity).getResolution())) {
                        HMSLog.e((String)HuaweiApi.TAG, (String)("Response has resolution: " + ((ResponseHeader)iMessageEntity).getResolution()));
                    }
                    if (this.isFirstRsp.compareAndSet(true, false)) {
                        b.a(RequestHandler.this.mApi.getContext(), (ResponseHeader)iMessageEntity, String.valueOf(RequestHandler.this.mApi.getKitSdkVersion()));
                    }
                    taskApiCallWrapper.getTaskApiCall().onResponse(RequestHandler.this.mClient, (ResponseErrorCode)((Object)iMessageEntity), string, taskApiCallWrapper.getTaskCompletionSource());
                }
            });
        }

        private String getTransactionId(String string, String string2) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return TransactionIdCreater.getId(this.mApi.getAppID(), string2);
            }
            return string;
        }

        private void innerConnectionFailed(ConnectionResult connectionResult) {
            boolean bl = true;
            this.mConnectionResult = connectionResult;
            Iterator iterator = this.callbackWaitQueue.iterator();
            while (iterator.hasNext()) {
                int n;
                ResponseHeader responseHeader;
                RequestHandler requestHandler = this;
                TaskApiCallWrapper taskApiCallWrapper = ((TaskApiCallbackWrapper)iterator.next()).getApiCallWrapper();
                ResponseHeader responseHeader2 = responseHeader;
                String string = "Connection Failed:" + this.errorReason(connectionResult) + "(" + connectionResult.getErrorCode() + ")";
                responseHeader2(1, 907135003, string);
                responseHeader.setTransactionId(taskApiCallWrapper.getTaskApiCall().getTransactionId());
                b.a(requestHandler.mApi.getContext(), responseHeader2, String.valueOf(this.mApi.getKitSdkVersion()));
                if (requestHandler.mConnectionResult.getResolution() != null && bl) {
                    responseHeader2.setParcelable((Parcelable)this.mConnectionResult.getResolution());
                    bl = false;
                    if (Util.isAvailableLibExist(this.mApi.getContext()) && this.mConnectionResult.getErrorCode() == 26) {
                        responseHeader2.setResolution("hasContextResolution");
                    }
                }
                if ((n = this.mConnectionResult.getErrorCode()) == 30 || n == 31) {
                    responseHeader2.setErrorCode(n);
                }
                taskApiCallWrapper.getTaskApiCall().onResponse(this.mClient, responseHeader2, null, taskApiCallWrapper.getTaskCompletionSource());
            }
            RequestHandler requestHandler = this;
            requestHandler.callbackWaitQueue.clear();
            requestHandler.callbackRunQueue.clear();
            requestHandler.mConnectionResult = null;
            requestHandler.mClient.disconnect();
        }

        private void innerConnected() {
            RequestHandler requestHandler = this;
            requestHandler.mConnectionResult = null;
            requestHandler.callbackRunQueue.clear();
            Iterator iterator = requestHandler.callbackWaitQueue.iterator();
            while (iterator.hasNext()) {
                this.postMessage((TaskApiCallbackWrapper)iterator.next());
            }
            this.callbackWaitQueue.clear();
        }

        private void innerConnectionSuspended() {
            HMSLog.i((String)HuaweiApi.TAG, (String)("wait queue size = " + this.callbackWaitQueue.size()));
            HMSLog.i((String)HuaweiApi.TAG, (String)("run queue size = " + this.callbackRunQueue.size()));
            Iterator iterator = this.callbackWaitQueue.iterator();
            while (iterator.hasNext()) {
                this.sendConnectionSuspended((TaskApiCallbackWrapper)iterator.next());
            }
            iterator = this.callbackRunQueue.iterator();
            while (iterator.hasNext()) {
                this.sendConnectionSuspended((TaskApiCallbackWrapper)iterator.next());
            }
            RequestHandler requestHandler = this;
            requestHandler.callbackWaitQueue.clear();
            requestHandler.callbackRunQueue.clear();
            requestHandler.mConnectionResult = null;
            requestHandler.mClient.disconnect();
        }

        private void sendConnectionSuspended(TaskApiCallbackWrapper object) {
            ResponseHeader responseHeader;
            object = ((TaskApiCallbackWrapper)object).getApiCallWrapper();
            ResponseHeader responseHeader2 = responseHeader;
            responseHeader2(1, 907135003, "Connection Suspended");
            responseHeader.setTransactionId(((TaskApiCallWrapper)object).getTaskApiCall().getTransactionId());
            ((TaskApiCallWrapper)object).getTaskApiCall().onResponse(this.mClient, responseHeader2, null, ((TaskApiCallWrapper)object).getTaskCompletionSource());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String errorReason(ConnectionResult connectionResult) {
            if (Util.isAvailableLibExist(this.mApi.getContext())) {
                int n = connectionResult.getErrorCode();
                if (n == -1) return "get update result, but has other error codes";
                if (n == 3) return "HuaWei Mobile Service is disabled";
                if (n == 8) return "internal error";
                if (n == 10) return "application configuration error, please developer check configuration";
                if (n == 13) return "update cancelled";
                if (n == 21) return "device is too old to be support";
                switch (n) {
                    default: {
                        return "unknown errorReason";
                    }
                    case 27: {
                        return "there is already an update popup at the front desk, but it hasn't been clicked or it is not effective for a while";
                    }
                    case 26: {
                        return "update failed, because no activity incoming, can't pop update page";
                    }
                    case 25: {
                        return "failed to get update result";
                    }
                }
            }
            int n = connectionResult.getErrorCode();
            if (n == -1) return "get update result, but has other error codes";
            if (n == 8) return "internal error";
            if (n == 10) return "application configuration error, please developer check configuration";
            return "unknown errorReason";
        }

        public AnyClient getClient() {
            return this.mClient;
        }

        void sendRequest(TaskApiCallWrapper taskApiCallWrapper) {
            RequestHandler requestHandler = binderAdapter;
            HMSLog.i((String)HuaweiApi.TAG, (String)"sendRequest");
            TaskApiCallbackWrapper taskApiCallbackWrapper = requestHandler.wrapperRequest(taskApiCallWrapper);
            if (requestHandler.mClient.isConnected()) {
                RequestHandler requestHandler2 = binderAdapter;
                RequestHandler requestHandler3 = binderAdapter;
                HMSLog.i((String)HuaweiApi.TAG, (String)"isConnected:true.");
                BinderAdapter binderAdapter = ((BaseHmsClient)((Object)requestHandler3.mClient)).getAdapter();
                binderAdapter.updateDelayTask();
                ((HmsClient)requestHandler3.mClient).setService(IAIDLInvoke.Stub.asInterface(binderAdapter.getServiceBinder()));
                requestHandler2.postMessage(taskApiCallbackWrapper);
            } else {
                RequestHandler requestHandler4 = binderAdapter;
                HMSLog.i((String)HuaweiApi.TAG, (String)"isConnected:false.");
                requestHandler4.callbackWaitQueue.add(taskApiCallbackWrapper);
                Object object = requestHandler4.mConnectionResult;
                if (object != null && ((ConnectionResult)object).getErrorCode() != 0) {
                    Object object2 = binderAdapter;
                    HMSLog.i((String)HuaweiApi.TAG, (String)("onConnectionFailed, ErrorCode:" + ((RequestHandler)((Object)binderAdapter)).mConnectionResult.getErrorCode()));
                    ((RequestHandler)object2).onConnectionFailed(((RequestHandler)object2).mConnectionResult);
                    return;
                }
                Object object3 = binderAdapter;
                RequestManager.addRequestToQueue((RequestHandler)object3);
                object = ((RequestHandler)object3).mClient;
                if (object instanceof BaseHmsClient) {
                    ((BaseHmsClient)object).setInternalRequest((RequestHandler)((Object)binderAdapter));
                }
                ((RequestHandler)((Object)binderAdapter)).connect(taskApiCallWrapper.getTaskApiCall().getMinApkVersion(), taskApiCallbackWrapper);
            }
        }

        public void postMessage(final TaskApiCallbackWrapper taskApiCallbackWrapper) {
            AnyClient.CallBack callBack;
            RequestHeader requestHeader;
            RequestHeader requestHeader2;
            RequestManager.addToConnectedReqMap(taskApiCallbackWrapper.getApiCallWrapper().getTaskApiCall().getTransactionId(), this);
            this.callbackRunQueue.add(taskApiCallbackWrapper);
            Object object = taskApiCallbackWrapper.getApiCallWrapper().getTaskApiCall().getUri();
            Object object2 = ((HuaweiApi)this.mApi).mHostContext == null ? this.mApi.getContext().getPackageName() : ((HuaweiApi)this.mApi).mHostContext.getPackageName();
            if (((HuaweiApi)this.mApi).mHostContext != null) {
                HuaweiApi<OptionsT> huaweiApi = this.mApi;
                ((HuaweiApi)huaweiApi).setHostAppId(((HuaweiApi)huaweiApi).mHostContext);
            }
            RequestHeader requestHeader3 = requestHeader2 = requestHeader;
            RequestHeader requestHeader4 = requestHeader2;
            requestHeader2();
            requestHeader2.setSrvName(((String)object).split("\\.")[0]);
            requestHeader4.setApiName((String)object);
            requestHeader4.setAppID(this.mApi.getAppID() + "|" + this.mApi.getSubAppID());
            requestHeader2.setPkgName((String)object2);
            requestHeader2.setSessionId(this.mClient.getSessionId());
            object2 = taskApiCallbackWrapper.getApiCallWrapper().getTaskApiCall();
            requestHeader3.setTransactionId(this.getTransactionId(((TaskApiCall)object2).getTransactionId(), (String)object));
            requestHeader3.setParcelable(((TaskApiCall)object2).getParcelable());
            requestHeader2.setKitSdkVersion(this.mApi.getKitSdkVersion());
            requestHeader.setApiLevel(Math.max(this.mApi.getApiLevel(), ((TaskApiCall)object2).getApiLevel()));
            object = callBack;
            callBack = new AnyClient.CallBack(){

                @Override
                public void onCallback(IMessageEntity iMessageEntity, String string) {
                    AnyClient.CallBack callBack = taskApiCallbackWrapper.getCallBack();
                    if (callBack != null) {
                        callBack.onCallback(iMessageEntity, string);
                    }
                    RequestManager.removeReqByTransId(requestHeader2.getTransactionId());
                    RequestManager.getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            RequestHandler.this.callbackRunQueue.remove(taskApiCallbackWrapper);
                        }
                    });
                }
            };
            this.mClient.post(requestHeader2, ((TaskApiCall)object2).getRequestJson(), (AnyClient.CallBack)object);
        }

        synchronized void connect(int n, TaskApiCallbackWrapper taskApiCallbackWrapper) {
            if (this.mClient.isConnected()) {
                HMSLog.d((String)HuaweiApi.TAG, (String)"client is connected");
                return;
            }
            if (this.mClient.isConnecting()) {
                HMSLog.d((String)HuaweiApi.TAG, (String)"client is isConnecting");
                return;
            }
            if (this.mApi.getActivity() != null) {
                if (this.mResolveClientBean == null) {
                    this.mResolveClientBean = new ResolveClientBean(this.mClient, n);
                }
                if (BindResolveClients.getInstance().isClientRegistered(this.mResolveClientBean)) {
                    HMSLog.i((String)HuaweiApi.TAG, (String)"mResolveClientBean has already register, return!");
                    return;
                }
                BindResolveClients.getInstance().register(this.mResolveClientBean);
            }
            this.mClient.connect(n);
        }

        void disconnect() {
            this.mClient.disconnect();
        }

        @Override
        public void onConnectionFailed(final ConnectionResult connectionResult) {
            HMSLog.i((String)HuaweiApi.TAG, (String)"onConnectionFailed");
            BindResolveClients.getInstance().unRegister(this.mResolveClientBean);
            this.mResolveClientBean = null;
            RequestManager.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    RequestHandler.this.innerConnectionFailed(connectionResult);
                }
            });
        }

        @Override
        public void onConnected() {
            HMSLog.i((String)HuaweiApi.TAG, (String)"onConnected");
            BindResolveClients.getInstance().unRegister(this.mResolveClientBean);
            this.mResolveClientBean = null;
            RequestManager.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    RequestHandler.this.innerConnected();
                }
            });
        }

        @Override
        public void onConnectionSuspended(int n) {
            HMSLog.i((String)HuaweiApi.TAG, (String)"onConnectionSuspended");
            BindResolveClients.getInstance().unRegister(this.mResolveClientBean);
            this.mResolveClientBean = null;
            RequestManager.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    RequestHandler.this.innerConnectionSuspended();
                }
            });
        }
    }

    public static class TaskApiCallbackWrapper {
        private final TaskApiCallWrapper mApiCallWrapper;
        private final AnyClient.CallBack mCallBack;

        TaskApiCallbackWrapper(TaskApiCallWrapper taskApiCallWrapper, AnyClient.CallBack callBack) {
            this.mApiCallWrapper = taskApiCallWrapper;
            this.mCallBack = callBack;
        }

        TaskApiCallWrapper getApiCallWrapper() {
            return this.mApiCallWrapper;
        }

        AnyClient.CallBack getCallBack() {
            return this.mCallBack;
        }
    }

    private static class RequestRunnable<OptionsT extends Api.ApiOptions>
    implements Runnable {
        private final HuaweiApi<OptionsT> mApi;
        private final TaskApiCallWrapper mTaskApiCallWrapper;

        public RequestRunnable(HuaweiApi<OptionsT> huaweiApi, TaskApiCallWrapper taskApiCallWrapper) {
            this.mApi = huaweiApi;
            this.mTaskApiCallWrapper = taskApiCallWrapper;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void notifyCpException(RequestHandler requestHandler, Exception exception) {
            Object object;
            TaskApiCall taskApiCall;
            TaskCompletionSource taskCompletionSource;
            String string;
            Object object2;
            block7: {
                block6: {
                    ResponseHeader responseHeader;
                    RequestRunnable requestRunnable = object2;
                    RequestHandler requestHandler2 = requestHandler;
                    object2 = null;
                    requestHandler = null;
                    string = null;
                    taskCompletionSource = null;
                    taskApiCall = null;
                    try {
                        object2 = requestHandler2.getClient();
                    }
                    catch (RuntimeException runtimeException) {
                        object = requestHandler;
                        break block6;
                    }
                    object = responseHeader;
                    {
                        responseHeader = new ResponseHeader(1, 907135001, exception.getMessage());
                    }
                    try {
                        string = new JSONObject().toString();
                        taskCompletionSource = requestRunnable.mTaskApiCallWrapper.getTaskCompletionSource();
                        taskApiCall = requestRunnable.mTaskApiCallWrapper.getTaskApiCall();
                        break block7;
                    }
                    catch (RuntimeException runtimeException) {
                        exception = runtimeException;
                    }
                }
                HMSLog.e((String)HuaweiApi.TAG, (String)("<notifyCpException> " + exception.getMessage()));
            }
            if (object2 != null && object != null && string != null && taskCompletionSource != null && taskApiCall != null) {
                taskApiCall.onResponse((AnyClient)object2, (ResponseErrorCode)object, string, taskCompletionSource);
                return;
            }
            HMSLog.e((String)HuaweiApi.TAG, (String)"<notifyCpException> isNotify is false, Can not notify CP.");
        }

        @Override
        public void run() {
            RequestHandler<OptionsT> requestHandler;
            RequestHandler<OptionsT> requestHandler2 = requestHandler;
            requestHandler2(this.mApi);
            try {
                requestHandler.sendRequest(this.mTaskApiCallWrapper);
            }
            catch (RuntimeException runtimeException) {
                this.notifyCpException(requestHandler2, runtimeException);
            }
        }
    }
}

