/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.common.binder;

import android.content.Context;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.text.TextUtils;
import com.engagelab.privates.common.MTCommon;
import com.engagelab.privates.common.api.MTCommonPrivatesApi;
import com.engagelab.privates.common.binder.MTMessengerConnection;
import com.engagelab.privates.common.binder.MainMessengerHandler;
import com.engagelab.privates.common.binder.RemoteMessengerHandler;
import com.engagelab.privates.common.business.MTCommonBusiness;
import com.engagelab.privates.common.global.MTGlobal;
import com.engagelab.privates.common.log.MTCommonLog;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MTMessenger {
    private static final String TAG = "MTMessenger";
    private static volatile MTMessenger instance;
    private Messenger mainMessenger;
    private Messenger remoteMessenger;
    private boolean serviceFlag = false;
    private boolean isInitOnMainProcess = false;
    private final ConcurrentLinkedQueue<Message> mainMessageQueue;
    private final ConcurrentLinkedQueue<Message> remoteMessageQueue;

    public MTMessenger() {
        ConcurrentLinkedQueue concurrentLinkedQueue;
        ConcurrentLinkedQueue concurrentLinkedQueue2;
        Object this_ = concurrentLinkedQueue2;
        concurrentLinkedQueue2 = new ConcurrentLinkedQueue();
        v1.mainMessageQueue = this_;
        this_ = concurrentLinkedQueue;
        concurrentLinkedQueue = new ConcurrentLinkedQueue();
        v1.remoteMessageQueue = this_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MTMessenger getInstance() {
        if (instance == null) {
            Class<MTMessenger> clazz = MTMessenger.class;
            synchronized (MTMessenger.class) {
                instance = new MTMessenger();
            }
        }
        return instance;
    }

    private boolean initConfig(Context context) {
        String string;
        String string2 = MTGlobal.getAppKey(context);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            MTCommonLog.e(TAG, "appKey is empty, please check it");
        }
        void v02 = string;
        string = MTGlobal.getAppChannel((Context)v02);
        String string3 = MTGlobal.getAppProcess((Context)v02);
        String string4 = MTGlobal.getAppVersionName((Context)v02);
        MTCommonLog.d(TAG, "appVersionCode:" + MTGlobal.getAppVersionCode((Context)v02) + ", appVersionName:" + string4 + ", appKey:" + (String)string2 + ", appChannel:" + string + ", appProcess:" + string3);
        MTCommonLog.d(TAG, "SDK_VERSION_NAME:5.1.0, SDK_VERSION_CODE:510");
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initOnMainProcess(Context context) {
        try {
            if (this.mainMessenger == null) {
                MTCommonLog.i("MTMessenger", "init common version:5.1.0");
                if (!this.initConfig((Context)var1_2)) {
                    return;
                }
                this.mainMessenger = new Messenger((Handler)new MainMessengerHandler((Context)var1_2, Looper.getMainLooper()));
                var2_3 = this.mainMessageQueue.iterator();
                while (var2_3.hasNext()) {
                    var3_4 = (Message)var2_3.next();
                    this.mainMessenger.send((Message)var3_4);
                    var2_3.remove();
                }
            }
            if (!MTGlobal.isNeedRemoteProcess) {
                return;
            }
            if (this.serviceFlag) {
                return;
            }
            v0 = this;
            v0.serviceFlag = true;
            v0.isInitOnMainProcess = true;
            if (MTGlobal.getCommonService((Context)var1_2) == null) {
                MTCommonLog.e("MTMessenger", "MTCommonService is null, please create new Service extends MTCommonService");
                return;
            }
            v1 = var1_2;
        }
        catch (Throwable var0_1) {
            MTCommonLog.w("MTMessenger", "initOnMainProcess failed " + var0_1.getMessage());
            return;
        }
        this = v2;
        {
            v2 = new MTMessengerConnection((Context)var1_2);
            var2_3 = MTGlobal.getCommonService((Context)v1);
            if (var2_3 != null) ** GOTO lbl34
        }
        {
            MTCommonLog.e("MTMessenger", "initOnMainProcess error, there are no service extends MTCommonService");
            return;
lbl34:
            // 1 sources

            v3 = var1_2;
        }
        var3_4 = v4;
        {
            v5 = this;
            var3_4();
            var3_4.setClass((Context)var1_2, var2_3.getClass());
        }
        {
            v3.bindService(v4, (ServiceConnection)v5, 1);
        }
        {
            if (Build.VERSION.SDK_INT >= 26) return;
            var1_2.startService(var3_4);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onServiceConnected(Context context, IBinder binder) {
        Iterator<Message> iterator;
        void var1_1;
        MTCommonLog.i(TAG, "onServiceConnected");
        this.serviceFlag = true;
        MTCommonBusiness.getInstance().init((Context)var1_1);
        this.remoteMessenger = new Messenger((IBinder)iterator);
        try {
            Message message;
            iterator = this.remoteMessageQueue.iterator();
            while (iterator.hasNext()) {
                message = iterator.next();
                if (101 != message.what) continue;
                this.remoteMessenger.send(message);
                iterator.remove();
            }
            iterator = this.remoteMessageQueue.iterator();
            while (iterator.hasNext()) {
                message = iterator.next();
                this.remoteMessenger.send(message);
                iterator.remove();
            }
        }
        catch (Throwable throwable) {
            MTCommonLog.w(TAG, "sendMessageToRemoteProcess failed " + throwable.getMessage());
        }
        MTMessenger mTMessenger = this;
        mTMessenger.sendMessageToMainProcess((Context)var1_1, 1001, null);
        mTMessenger.sendMessageToRemoteProcess((Context)var1_1, 1999, null);
        mTMessenger.sendMessageToRemoteProcess((Context)var1_1, 1993, null);
    }

    /*
     * WARNING - void declaration
     */
    public void onServiceDisconnected(Context context) {
        MTMessenger mTMessenger = this;
        MTCommonLog.i(TAG, "onServiceDisconnected");
        mTMessenger.serviceFlag = false;
        mTMessenger.mainMessenger = null;
        mTMessenger.remoteMessenger = null;
        mTMessenger.mainMessageQueue.clear();
        mTMessenger.remoteMessageQueue.clear();
        if (mTMessenger.isInitOnMainProcess) {
            void var1_1;
            MTCommonLog.i(TAG, "onServiceDisconnected retry init");
            MTCommonPrivatesApi.sendMessageDelayed((Context)var1_1, MTCommon.THREAD_COMMON, 1000, null, 3000L);
        }
    }

    public void initOnRemoteProcess(Context context) {
        Iterator<Message> iterator;
        block9: {
            block8: {
                if (this.remoteMessenger == null) break block8;
                return;
            }
            MTGlobal.isNeedRemoteProcess = true;
            MTCommonLog.i(TAG, "init common version:5.1.0");
            if (this.initConfig((Context)iterator)) break block9;
            return;
        }
        try {
            this.remoteMessenger = new Messenger((Handler)new RemoteMessengerHandler((Context)iterator, Looper.getMainLooper()));
            iterator = this.remoteMessageQueue.iterator();
        }
        catch (Throwable throwable) {
            MTCommonLog.w(TAG, "initOnRemoteProcess failed " + throwable.getMessage());
        }
        while (true) {
            if (!iterator.hasNext()) break;
            Iterator<Message> iterator2 = iterator;
            MTMessenger mTMessenger = this;
            Message message = iterator.next();
            mTMessenger.remoteMessenger.send(message);
            iterator2.remove();
            continue;
            break;
        }
    }

    public IBinder getBinder() {
        MTMessenger this_ = this_.remoteMessenger;
        if (this_ == null) {
            MTCommonLog.e(TAG, "getBinder null");
            return null;
        }
        return this_.getBinder();
    }

    public void initMainMessenger(Messenger messenger) {
        Iterator<Message> iterator;
        if (messenger == null) {
            return;
        }
        try {
            this.mainMessenger = iterator;
            iterator = this.mainMessageQueue.iterator();
        }
        catch (Throwable throwable) {
            MTCommonLog.w(TAG, "initMainMessenger failed " + throwable.getMessage());
        }
        while (true) {
            if (!iterator.hasNext()) break;
            Iterator<Message> iterator2 = iterator;
            MTMessenger mTMessenger = this;
            Message message = iterator.next();
            mTMessenger.mainMessenger.send(message);
            iterator2.remove();
            continue;
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void sendMessageToMainProcess(Context context, int what, Bundle bundle) {
        v0 = this;
        var4_7 = Message.obtain();
        var4_7.what = var2_4;
        var4_7.setData((Bundle)var3_6);
        var2_5 = v0.mainMessenger;
        if (var2_5 != null) ** GOTO lbl19
        v1 = this;
        v2 = v1;
        v1.mainMessageQueue.add(var4_7);
        if (!v2.isInitOnMainProcess) ** GOTO lbl18
        try {
            MTCommonPrivatesApi.sendMessage((Context)var1_3, MTCommon.THREAD_COMMON, 1000, null);
lbl18:
            // 2 sources

            return;
lbl19:
            // 1 sources

            var2_5.send(var4_7);
        }
        catch (Throwable var0_1) {
            MTCommonLog.w("MTMessenger", "sendMessageToMainProcess failed " + var0_1.getMessage());
        }
        catch (DeadObjectException var0_2) {
            MTCommonLog.w("MTMessenger", "sendMessageToMainProcess DeadObjectException " + var0_2.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendMessageToRemoteProcess(Context context, int what, Bundle bundle) {
        Messenger messenger;
        Message message;
        block8: {
            void var3_6;
            void var2_4;
            if (!MTGlobal.isNeedRemoteProcess) {
                return;
            }
            void v02 = message;
            message = Message.obtain();
            message.what = var2_4;
            message.setData((Bundle)var3_6);
            if (MTGlobal.isMainProcess((Context)v02)) {
                message.replyTo = this.mainMessenger;
            }
            if ((messenger = this.remoteMessenger) != null) break block8;
            this.remoteMessageQueue.add(message);
            return;
        }
        try {
            messenger.send(message);
            return;
        }
        catch (Throwable throwable) {
            MTCommonLog.w(TAG, "sendMessageToRemoteProcess failed " + throwable.getMessage());
            return;
        }
        catch (DeadObjectException deadObjectException) {
            MTCommonLog.w(TAG, "sendMessageToRemoteProcess DeadObjectException " + deadObjectException.getMessage());
        }
    }
}

