/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.platform.mi.business;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.engagelab.privates.common.api.MTCommonPrivatesApi;
import com.engagelab.privates.common.global.MTGlobal;
import com.engagelab.privates.common.log.MTCommonLog;
import com.engagelab.privates.common.utils.SM4Util;
import com.engagelab.privates.push.api.MTPushPrivatesApi;
import com.engagelab.privates.push.api.NotificationMessage;
import com.engagelab.privates.push.api.PlatformTokenMessage;
import com.engagelab.privates.push.utils.NotificationUtil;
import com.xiaomi.mipush.sdk.MiPushClient;
import com.xiaomi.mipush.sdk.MiPushMessage;
import org.json.JSONObject;

public class MTMiBusiness {
    private static final String TAG = "MTMiBusiness";
    private static final String XIAOMI_APPID = "XIAOMI_APPID";
    private static final String XIAOMI_APPKEY = "XIAOMI_APPKEY";
    private boolean isSupport;
    private static volatile MTMiBusiness instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MTMiBusiness getInstance() {
        if (instance != null) return instance;
        Class<MTMiBusiness> clazz = MTMiBusiness.class;
        synchronized (MTMiBusiness.class) {
            instance = new MTMiBusiness();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Context context, Bundle bundle) {
        try {
            String appId = this.getAppId(context, bundle);
            if (TextUtils.isEmpty((CharSequence)appId)) {
                MTCommonLog.e((String)TAG, (String)"not support xiaomi push, xiaomi appId is empty");
                return;
            }
            String appKey = this.getAppKey(context, bundle);
            if (TextUtils.isEmpty((CharSequence)appKey)) {
                MTCommonLog.e((String)TAG, (String)"not support xiaomi push, xiaomi appKey is empty");
                return;
            }
            this.isSupport = MiPushClient.shouldUseMIUIPush((Context)context);
            if (!this.isSupport) {
                MTCommonLog.e((String)TAG, (String)"not support xiaomi push");
                this.onNode(context, 3002, 0, 3900, 1);
                return;
            }
            MTCommonLog.d((String)TAG, (String)"support xiaomi push");
            MiPushClient.registerPush((Context)context, (String)appId, (String)appKey);
            String token = MiPushClient.getRegId((Context)context);
            if (TextUtils.isEmpty((CharSequence)token)) {
                MTCommonLog.d((String)TAG, (String)"onTokenFailed:get token is empty");
                this.onNode(context, 3003, 1, 3900, 1);
                return;
            }
            MTCommonLog.d((String)TAG, (String)("onTokenSuccess:get token is " + token));
            this.onToken(context, token, 1);
        }
        catch (Throwable throwable) {
            this.isSupport = false;
            MTCommonLog.e((String)TAG, (String)("init failed " + throwable.getMessage()));
        }
    }

    private String getAppId(Context context, Bundle bundle) {
        String appId = null;
        try {
            String metaData;
            if (null != bundle && bundle.containsKey(XIAOMI_APPID)) {
                String bundleString = bundle.getString(XIAOMI_APPID);
                if (TextUtils.isEmpty((CharSequence)bundleString)) {
                    MTCommonLog.w((String)TAG, (String)"api config : XIAOMI_APPID - not empty !");
                } else {
                    appId = bundleString.substring(3);
                }
            }
            if (TextUtils.isEmpty(appId) && !TextUtils.isEmpty((CharSequence)(metaData = MTGlobal.getMetaData((Context)context, (String)XIAOMI_APPID)))) {
                appId = metaData.substring(3);
            }
        }
        catch (Throwable e) {
            MTCommonLog.e((String)TAG, (String)(" config info error: XIAOMI_APPID - " + e));
        }
        return appId;
    }

    private String getAppKey(Context context, Bundle bundle) {
        String appKey = null;
        try {
            String metaData;
            if (null != bundle && bundle.containsKey(XIAOMI_APPKEY)) {
                String bundleString = bundle.getString(XIAOMI_APPKEY);
                if (TextUtils.isEmpty((CharSequence)bundleString)) {
                    MTCommonLog.w((String)TAG, (String)"api config : XIAOMI_APPKEY - not empty !");
                } else {
                    appKey = bundleString.substring(3);
                }
            }
            if (TextUtils.isEmpty(appKey) && !TextUtils.isEmpty((CharSequence)(metaData = MTGlobal.getMetaData((Context)context, (String)XIAOMI_APPKEY)))) {
                appKey = metaData.substring(3);
            }
        }
        catch (Throwable e) {
            MTCommonLog.e((String)TAG, (String)(" config info error: XIAOMI_APPKEY - " + e));
        }
        return appKey;
    }

    public void onToken(Context context, String token, int from) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            MTCommonLog.d((String)TAG, (String)"onToken:token is empty");
            return;
        }
        PlatformTokenMessage platformTokenMessage = new PlatformTokenMessage().setPlatform((byte)1).setToken(token);
        Bundle bundle = new Bundle();
        bundle.putParcelable("message", (Parcelable)platformTokenMessage);
        MTPushPrivatesApi.init((Context)context);
        MTCommonPrivatesApi.sendMessageToMainProcess((Context)context.getApplicationContext(), (int)3021, (Bundle)bundle);
        MTMiBusiness.getInstance().onNode(context, 3008, 0, 3901, from);
    }

    public void onNode(Context context, int code, int mCode, int type, int from) {
        Bundle bundle = new Bundle();
        bundle.putByte("platform", (byte)1);
        bundle.putInt("code", code);
        bundle.putInt("mCode", mCode);
        bundle.putInt("type", type);
        bundle.putInt("from", from);
        MTCommonPrivatesApi.sendMessageToMainProcess((Context)context, (int)3022, (Bundle)bundle);
    }

    public void onNotificationMessage(Context context, int what, MiPushMessage message) {
        try {
            String defineContent = message.getContent();
            boolean notified = message.isNotified();
            MTCommonLog.d((String)TAG, (String)("onNotificationMessage:" + message.toString()));
            if (TextUtils.isEmpty((CharSequence)defineContent)) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)(defineContent = SM4Util.decodeMessage((String)defineContent)))) {
                return;
            }
            JSONObject messageJson = new JSONObject(defineContent);
            switch (what) {
                case 3002: {
                    MTCommonLog.d((String)TAG, (String)("onNotificationMessageArrived:" + MTCommonLog.toLogString((JSONObject)messageJson)));
                    break;
                }
                case 3003: {
                    MTCommonLog.d((String)TAG, (String)("onNotificationMessageClicked:" + MTCommonLog.toLogString((JSONObject)messageJson)));
                    break;
                }
                default: {
                    MTCommonLog.d((String)TAG, (String)("onNotificationMessage:" + MTCommonLog.toLogString((JSONObject)messageJson)));
                }
            }
            String messageId = NotificationUtil.getMessageId((JSONObject)messageJson);
            if (TextUtils.isEmpty((CharSequence)messageId)) {
                return;
            }
            JSONObject contentJson = messageJson.optJSONObject("m_content");
            if (contentJson == null) {
                return;
            }
            String title = contentJson.optString("n_title");
            String content = contentJson.optString("n_content");
            Bundle extras = NotificationUtil.convertJsonToBundle((JSONObject)contentJson.optJSONObject("n_extras"));
            NotificationMessage notificationMessage = new NotificationMessage().setMessageId(messageId).setPlatform((byte)1).setPlatformMessageId(message.getMessageId()).setNotificationId(message.getNotifyId()).setTitle(title).setDisplayForeground("0").setContent(content).setExtras(extras);
            Bundle bundle = new Bundle();
            bundle.putParcelable("message", (Parcelable)notificationMessage);
            MTPushPrivatesApi.init((Context)context);
            MTCommonPrivatesApi.sendMessageToMainProcess((Context)context.getApplicationContext(), (int)what, (Bundle)bundle);
            if (!notified) {
                MTCommonPrivatesApi.sendMessageToMainProcess((Context)context.getApplicationContext(), (int)3303, (Bundle)bundle);
            } else if (what == 3002) {
                Bundle messageBundle = new Bundle();
                messageBundle.putParcelable("message", (Parcelable)notificationMessage);
                MTCommonPrivatesApi.sendMessageToRemoteProcess((Context)context, (int)3500, (Bundle)messageBundle);
            }
        }
        catch (Throwable throwable) {
            MTCommonLog.w((String)TAG, (String)("onNotificationMessage failed " + throwable.getMessage()));
        }
    }

    public void turnOnPush(Context context) {
        try {
            if (!this.isSupport) {
                return;
            }
            MiPushClient.resumePush((Context)context, null);
            this.onNode(context, 3101, 0, 3902, 0);
        }
        catch (Throwable throwable) {
            MTCommonLog.w((String)TAG, (String)("turnOnPush failed " + throwable.getMessage()));
        }
    }

    public void turnOffPush(Context context) {
        try {
            if (!this.isSupport) {
                return;
            }
            MiPushClient.pausePush((Context)context, null);
            this.onNode(context, 3102, 0, 3903, 0);
        }
        catch (Throwable throwable) {
            MTCommonLog.w((String)TAG, (String)("turnOffPush failed " + throwable.getMessage()));
        }
    }

    public void clearNotification(Context context, Bundle bundle) {
        try {
            if (!this.isSupport) {
                return;
            }
            int notifyId = bundle.getInt("notification_id");
            MiPushClient.clearNotification((Context)context, (int)notifyId);
        }
        catch (Throwable throwable) {
            MTCommonLog.w((String)TAG, (String)("clearNotification failed " + throwable.getMessage()));
        }
    }
}

