/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.oth.sound.business;

import android.content.Context;
import android.text.TextUtils;
import com.engagelab.privates.common.global.MTGlobal;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;

public class SoundJson {
    public static final int SUSS = 2000;
    public static final int HAVE_NOT_OPENED = 2001;
    public static final int NOT_UP = 2002;
    private String body;
    private Content content;
    private int code;
    private String message;

    public static SoundJson fromJson(String json) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)json)) {
            json = "{}";
        }
        SoundJson soundJson = new SoundJson();
        soundJson.setBody(json);
        JSONObject jsonObject = new JSONObject(json);
        int code = jsonObject.optInt("code", -1);
        String message = jsonObject.optString("message", "");
        soundJson.setCode(code);
        soundJson.setMessage(message);
        JSONObject jsonContent = jsonObject.optJSONObject("content");
        Content content = SoundJson.getContent(jsonContent);
        soundJson.setContent(content);
        return soundJson;
    }

    private static Content getContent(JSONObject jsonContent) {
        Content content = new Content();
        if (null != jsonContent) {
            String ar = jsonContent.optString("ar", "");
            String md5 = jsonContent.optString("md5", "");
            String lan = jsonContent.optString("lan", "");
            content.setAr(ar);
            content.setMd5(md5);
            content.setLan(lan);
        }
        return content;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean valid() {
        if (null == this.content) {
            return false;
        }
        return this.content.valid();
    }

    public String toString() {
        return "SoundJson{code=" + this.code + ", content=" + this.content + ", message='" + this.message + '\'' + ", body='" + this.body + '\'' + '}';
    }

    public static class Content {
        private String ar;
        private String md5;
        private String lan;

        public String getAr() {
            return this.ar;
        }

        public void setAr(String ar) {
            this.ar = ar;
        }

        public String getMd5() {
            return this.md5;
        }

        public void setMd5(String md5) {
            this.md5 = md5;
        }

        public String getLan() {
            return this.lan;
        }

        public void setLan(String lan) {
            this.lan = lan;
        }

        public boolean valid() {
            return !TextUtils.isEmpty((CharSequence)this.ar) && !TextUtils.isEmpty((CharSequence)this.md5) && !TextUtils.isEmpty((CharSequence)this.lan);
        }

        public String getPath(Context context) {
            File filesDir = context.getFilesDir();
            String appKey = MTGlobal.getAppKey((Context)context);
            String filePath = filesDir.getAbsolutePath() + File.separator + appKey + File.separator + this.lan + File.separator + this.md5 + ".e";
            return filePath;
        }

        public String getPathDecrypt(Context context) {
            File filesDir = context.getFilesDir();
            String appKey = MTGlobal.getAppKey((Context)context);
            String filePath = filesDir.getAbsolutePath() + File.separator + appKey + File.separator + this.lan + File.separator + this.md5 + ".d";
            return filePath;
        }

        public String getPathUnZip(Context context) {
            File filesDir = context.getFilesDir();
            String appKey = MTGlobal.getAppKey((Context)context);
            String filePath = filesDir.getAbsolutePath() + File.separator + appKey + File.separator + this.lan + File.separator + this.md5 + "_f";
            return filePath;
        }

        public String toString() {
            return "Content{ar='" + this.ar + '\'' + ", md5='" + this.md5 + '\'' + ", lan='" + this.lan + '\'' + '}';
        }
    }
}

