/*
 * Decompiled with CFR 0.152.
 */
package com.engagelab.privates.push.oth.sound.util;

import android.media.MediaPlayer;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.engagelab.privates.common.log.MTCommonLog;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SoundPlayUtil {
    private static final String TAG = "SoundPlayUtil";
    private static volatile SoundPlayUtil instance;
    private List<String> audioFiles = new CopyOnWriteArrayList<String>();
    private int currentIndex = 0;
    private boolean isPlay = false;
    private MediaPlayer mediaPlayer = new MediaPlayer();
    private long threadId = Thread.currentThread().getId();
    private static Handler handler;

    private SoundPlayUtil() {
    }

    private static synchronized SoundPlayUtil getInstance() {
        if (instance == null) {
            instance = new SoundPlayUtil();
        }
        return instance;
    }

    public static synchronized void startPlay(final List<String> soundFiles) {
        try {
            if (null == handler) {
                HandlerThread handlerThread = new HandlerThread("player_handler");
                handlerThread.start();
                handler = new PlayerHandler(handlerThread.getLooper());
            }
            handler.post(new Runnable(){

                @Override
                public void run() {
                    SoundPlayUtil.getInstance().play(soundFiles);
                }
            });
        }
        catch (Throwable e) {
            MTCommonLog.e((String)TAG, (String)("startPlay fail:" + e));
            handler = null;
        }
    }

    public synchronized void play(List<String> soundFiles) {
        try {
            MTCommonLog.d((String)TAG, (String)("play soundFiles size:" + soundFiles.size()));
            MTCommonLog.d((String)TAG, (String)("play soundFiles:" + soundFiles));
            this.audioFiles.addAll(soundFiles);
            long id = Thread.currentThread().getId();
            MTCommonLog.d((String)TAG, (String)("play Thread id:" + id));
            MTCommonLog.d((String)TAG, (String)("play Thread threadId:" + this.threadId));
            if (id != this.threadId) {
                MTCommonLog.d((String)TAG, (String)("play new MediaPlayer:" + this.threadId));
                this.mediaPlayer.release();
                this.isPlay = false;
                this.mediaPlayer = new MediaPlayer();
                this.threadId = id;
            }
            boolean playerPlaying = this.mediaPlayer.isPlaying();
            MTCommonLog.d((String)TAG, (String)("play isPlay:" + this.isPlay));
            MTCommonLog.d((String)TAG, (String)("play playerPlaying:" + playerPlaying));
            if (!this.isPlay) {
                this.isPlay = true;
                this.playNextAudio();
            }
        }
        catch (Throwable e) {
            MTCommonLog.e((String)TAG, (String)("play fail:" + e));
            this.release();
        }
    }

    private synchronized void playNextAudio() {
        try {
            MTCommonLog.d((String)TAG, (String)"playNextAudio start");
            if (this.currentIndex < this.audioFiles.size()) {
                try {
                    String path = this.audioFiles.get(this.currentIndex);
                    MTCommonLog.d((String)TAG, (String)("playNextAudio start path:" + path));
                    this.mediaPlayer.reset();
                    this.mediaPlayer.setDataSource(path);
                    this.mediaPlayer.prepare();
                    this.mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                        public void onCompletion(MediaPlayer mp) {
                            SoundPlayUtil.this.currentIndex++;
                            SoundPlayUtil.this.playNextAudio();
                        }
                    });
                    this.mediaPlayer.start();
                }
                catch (Throwable e) {
                    MTCommonLog.e((String)TAG, (String)("playNextAudio e:" + e));
                    this.release();
                }
            } else {
                this.reset();
            }
        }
        catch (Throwable e) {
            MTCommonLog.e((String)TAG, (String)("playNextAudio fail:" + e));
            this.release();
        }
    }

    private synchronized void reset() {
        this.currentIndex = 0;
        this.audioFiles.clear();
        this.isPlay = false;
    }

    public synchronized void release() {
        this.mediaPlayer.release();
        this.reset();
    }

    private static class PlayerHandler
    extends Handler {
        PlayerHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
        }
    }
}

