/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import com.huawei.hms.framework.common.Logger;

public class Utils {
    private static final String TAG = "Utils";

    public static long getCurrentTime(boolean bRealTime) {
        if (bRealTime) {
            return SystemClock.elapsedRealtime();
        }
        return System.currentTimeMillis();
    }

    public static boolean is64Bit(Context context) {
        boolean is64bit;
        block6: {
            block8: {
                Context appContext;
                block7: {
                    if (context == null) {
                        Logger.e(TAG, "Null context, please check it.");
                        return false;
                    }
                    appContext = context.getApplicationContext() == null ? context : context.getApplicationContext();
                    is64bit = false;
                    if (Build.VERSION.SDK_INT < 23) break block7;
                    is64bit = Process.is64Bit();
                    break block6;
                }
                if (Build.VERSION.SDK_INT < 21) break block8;
                try {
                    is64bit = appContext.getPackageManager().getApplicationInfo((String)appContext.getPackageName(), (int)128).nativeLibraryDir.contains("64");
                }
                catch (PackageManager.NameNotFoundException e) {
                    Logger.e(TAG, "Get application info failed: name not found, try to get baseContext.");
                    if (!(context instanceof ContextWrapper)) break block6;
                    Context baseContext = ((ContextWrapper)context).getBaseContext();
                    if (baseContext == null) {
                        Logger.w(TAG, "Get baseContext failed: null. Return default: is64-bit.");
                        return true;
                    }
                    try {
                        is64bit = baseContext.getPackageManager().getApplicationInfo((String)baseContext.getPackageName(), (int)128).nativeLibraryDir.contains("64");
                        break block6;
                    }
                    catch (PackageManager.NameNotFoundException ex) {
                        Logger.e(TAG, "Get baseContext application info failed: name not found");
                        is64bit = true;
                    }
                }
                break block6;
            }
            is64bit = false;
        }
        return is64bit;
    }
}

