/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.content.Context;
import android.content.res.AssetManager;
import com.huawei.hms.framework.common.ExecutorsUtils;
import com.huawei.hms.framework.common.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AssetsUtil {
    private static final String TAG = "AssetsUtil";
    private static final String THREAD_NAME = "AssetsUtil_Operate";
    private static final ExecutorService EXECUTOR_SERVICE = ExecutorsUtils.newSingleThreadExecutor((String)"AssetsUtil_Operate");
    private static final int GET_SP_TIMEOUT = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] list(final Context context, final String path) {
        String[] files;
        if (context == null) {
            Logger.w((String)TAG, (Object)"context is null");
            return new String[0];
        }
        FutureTask<String[]> future = new FutureTask<String[]>(new Callable<String[]>(){

            @Override
            public String[] call() throws Exception {
                return context.getAssets().list(path);
            }
        });
        EXECUTOR_SERVICE.execute(future);
        try {
            files = future.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.w((String)TAG, (String)"get local config files from sp task interrupted", (Throwable)e);
            String[] stringArray = new String[]{};
            return stringArray;
        }
        catch (ExecutionException e) {
            Logger.w((String)TAG, (String)"get local config files from sp task failed", (Throwable)e);
            String[] stringArray = new String[]{};
            return stringArray;
        }
        catch (TimeoutException e) {
            Logger.w((String)TAG, (Object)"get local config files from sp task timed out");
            String[] stringArray = new String[]{};
            return stringArray;
        }
        catch (Exception e) {
            Logger.w((String)TAG, (Object)"get local config files from sp task occur unknown Exception");
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            future.cancel(true);
        }
        return files;
    }

    public static InputStream open(Context context, String path) throws IOException {
        if (context == null) {
            Logger.w((String)TAG, (Object)"context is null");
            return null;
        }
        AssetManager assetManager = context.getAssets();
        InputStream inputStream = null;
        try {
            inputStream = assetManager.open(path);
        }
        catch (RuntimeException e) {
            Logger.e((String)TAG, (String)"AssetManager has been destroyed", (Throwable)e);
        }
        return inputStream;
    }
}

