/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.images.zah;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="WebImageCreator")
public final class WebImage
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<WebImage> CREATOR;
    @SafeParcelable.VersionField(id=1)
    final int zaa;
    @SafeParcelable.Field(id=2, getter="getUrl")
    private final Uri zab;
    @SafeParcelable.Field(id=3, getter="getWidth")
    private final int zac;
    @SafeParcelable.Field(id=4, getter="getHeight")
    private final int zad;

    public int getHeight() {
        return this.zad;
    }

    public int getWidth() {
        return this.zac;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zab, this.zac, this.zad};
        return Objects.hashCode((Object[])objectArray);
    }

    @NonNull
    public Uri getUrl() {
        return this.zab;
    }

    @NonNull
    public String toString() {
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{this.zac, this.zad, this.zab.toString()};
        return String.format(locale, "Image %dx%d %s", objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    @NonNull
    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.zab.toString());
            jSONObject.put("width", this.zac);
            jSONObject.put("height", this.zad);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            return jSONObject;
        }
    }

    static {
        zah zah2;
        CREATOR = zah2 = new zah();
    }

    /*
     * WARNING - void declaration
     */
    public WebImage(@NonNull Uri url) throws IllegalArgumentException {
        this((Uri)var1_1, 0, 0);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public WebImage(@NonNull JSONObject json) throws IllegalArgumentException {
        void var1_1;
        Uri uri = Uri.EMPTY;
        if (var1_1.has("url")) {
            try {
                Uri uri2;
                uri = uri2 = Uri.parse((String)var1_1.getString("url"));
            }
            catch (JSONException jSONException) {}
        }
        this(uri, var1_1.optInt("width", 0), var1_1.optInt("height", 0));
    }

    /*
     * WARNING - void declaration
     */
    public WebImage(@NonNull Uri url, int width, int height) throws IllegalArgumentException {
        this(1, (Uri)var1_3, (int)var2_4, (int)var3_5);
        void var3_5;
        void var2_4;
        void var1_3;
        if (var1_3 == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("url cannot be null");
            throw illegalArgumentException;
        }
        if (var2_4 < 0 || var3_5 < 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("width and height must not be negative");
            throw illegalArgumentException;
        }
    }

    @SafeParcelable.Constructor
    WebImage(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) Uri uri, @SafeParcelable.Param(id=3) int n2, @SafeParcelable.Param(id=4) int n3) {
        this.zaa = n;
        this.zab = uri;
        this.zac = n2;
        this.zad = n3;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.zaa);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.getUrl(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)3, (int)this.getWidth());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)4, (int)this.getHeight());
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object other) {
        WebImage webImage;
        if (this == webImage) {
            return true;
        }
        if (webImage == null || !(webImage instanceof WebImage)) {
            return false;
        }
        webImage = webImage;
        return Objects.equal((Object)this.zab, (Object)webImage.zab) && this.zac == webImage.zac && this.zad == webImage.zad;
    }
}

