/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.app.ActivityManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import com.huawei.hms.framework.common.ContextCompat;
import com.huawei.hms.framework.common.Logger;
import java.util.List;

public class ActivityUtil {
    private static final String TAG = "ActivityUtil";

    public static boolean isForeground(Context context) {
        ActivityManager activityManager;
        if (context != null && (activityManager = (ActivityManager)ContextCompat.getSystemService(context, "activity")) != null) {
            List appProcesses = null;
            try {
                appProcesses = activityManager.getRunningAppProcesses();
            }
            catch (RuntimeException e) {
                Logger.w((String)TAG, (String)"activityManager getRunningAppProcesses occur exception: ", (Throwable)e);
            }
            if (appProcesses != null) {
                for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
                    if (appProcess.processName == null || !appProcess.processName.equals(context.getPackageName()) || appProcess.importance != 100) continue;
                    Logger.v((String)TAG, (Object)"isForeground true");
                    return true;
                }
            }
        }
        return false;
    }

    public static PendingIntent getActivities(Context context, int requestCode, Intent[] intents, int flags) {
        if (context == null) {
            Logger.w((String)TAG, (Object)"context is null");
            return null;
        }
        PendingIntent pendingIntent = null;
        try {
            pendingIntent = PendingIntent.getActivities((Context)context, (int)requestCode, (Intent[])intents, (int)flags);
        }
        catch (RuntimeException e) {
            Logger.e((String)TAG, (String)"dealType rethrowFromSystemServer:", (Throwable)e);
        }
        return pendingIntent;
    }
}

